/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content;

import com.box.androidsdk.content.BoxApi;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.requests.BoxRequestsFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Locale;

public class BoxApiFile
extends BoxApi {
    public BoxApiFile(BoxSession session) {
        super(session);
    }

    protected String getFilesUrl() {
        return String.format(Locale.ENGLISH, "%s/files", this.getBaseUri());
    }

    protected String getFileInfoUrl(String id) {
        return String.format(Locale.ENGLISH, "%s/%s", this.getFilesUrl(), id);
    }

    protected String getFileCopyUrl(String id) {
        return String.format(Locale.ENGLISH, this.getFileInfoUrl(id) + "/copy", new Object[0]);
    }

    protected String getFileUploadUrl() {
        return String.format(Locale.ENGLISH, "%s/files/content", this.getBaseUploadUri());
    }

    protected String getFileUploadNewVersionUrl(String id) {
        return String.format(Locale.ENGLISH, "%s/files/%s/content", this.getBaseUploadUri(), id);
    }

    protected String getTrashedFileUrl(String id) {
        return this.getFileInfoUrl(id) + "/trash";
    }

    protected String getFileCommentsUrl(String id) {
        return this.getFileInfoUrl(id) + "/comments";
    }

    protected String getFileVersionsUrl(String id) {
        return this.getFileInfoUrl(id) + "/versions";
    }

    protected String getPromoteFileVersionUrl(String id) {
        return this.getFileVersionsUrl(id) + "/current";
    }

    protected String getDeleteFileVersionUrl(String id, String versionId) {
        return String.format(Locale.ENGLISH, "%s/%s", this.getFileVersionsUrl(id), versionId);
    }

    protected String getFileDownloadUrl(String id) {
        return this.getFileInfoUrl(id) + "/content";
    }

    protected String getThumbnailFileDownloadUrl(String id) {
        return this.getFileInfoUrl(id) + "/thumbnail.png";
    }

    protected String getCommentUrl() {
        return this.getBaseUri() + "/comments";
    }

    public BoxRequestsFile.GetFileInfo getInfoRequest(String id) {
        BoxRequestsFile.GetFileInfo request = new BoxRequestsFile.GetFileInfo(id, this.getFileInfoUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFile.UpdateFile getUpdateRequest(String id) {
        BoxRequestsFile.UpdateFile request = new BoxRequestsFile.UpdateFile(id, this.getFileInfoUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFile.CopyFile getCopyRequest(String id, String parentId) {
        BoxRequestsFile.CopyFile request = new BoxRequestsFile.CopyFile(id, parentId, this.getFileCopyUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFile.UpdateFile getRenameRequest(String id, String newName) {
        BoxRequestsFile.UpdateFile request = new BoxRequestsFile.UpdateFile(id, this.getFileInfoUrl(id), this.mSession);
        request.setName(newName);
        return request;
    }

    public BoxRequestsFile.UpdateFile getMoveRequest(String id, String parentId) {
        BoxRequestsFile.UpdateFile request = new BoxRequestsFile.UpdateFile(id, this.getFileInfoUrl(id), this.mSession);
        request.setParentId(parentId);
        return request;
    }

    public BoxRequestsFile.DeleteFile getDeleteRequest(String id) {
        BoxRequestsFile.DeleteFile request = new BoxRequestsFile.DeleteFile(id, this.getFileInfoUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFile.UpdatedSharedFile getCreateSharedLinkRequest(String id) {
        BoxRequestsFile.UpdatedSharedFile request = (BoxRequestsFile.UpdatedSharedFile)new BoxRequestsFile.UpdatedSharedFile(id, this.getFileInfoUrl(id), this.mSession).setAccess(null);
        return request;
    }

    public BoxRequestsFile.UpdateFile getDisableSharedLinkRequest(String id) {
        BoxRequestsFile.UpdateFile request = (BoxRequestsFile.UpdateFile)new BoxRequestsFile.UpdateFile(id, this.getFileInfoUrl(id), this.mSession).setSharedLink(null);
        return request;
    }

    public BoxRequestsFile.AddCommentToFile getAddCommentRequest(String fileId, String message) {
        BoxRequestsFile.AddCommentToFile request = new BoxRequestsFile.AddCommentToFile(fileId, message, this.getCommentUrl(), this.mSession);
        return request;
    }

    public BoxRequestsFile.UploadFile getUploadRequest(InputStream fileInputStream, String fileName, String destinationFolderId) {
        BoxRequestsFile.UploadFile request = new BoxRequestsFile.UploadFile(fileInputStream, fileName, destinationFolderId, this.getFileUploadUrl(), this.mSession);
        return request;
    }

    public BoxRequestsFile.UploadFile getUploadRequest(File file, String destinationFolderId) {
        BoxRequestsFile.UploadFile request = new BoxRequestsFile.UploadFile(file, destinationFolderId, this.getFileUploadUrl(), this.mSession);
        return request;
    }

    public BoxRequestsFile.UploadNewVersion getUploadNewVersionRequest(InputStream fileInputStream, String destinationFileId) {
        BoxRequestsFile.UploadNewVersion request = new BoxRequestsFile.UploadNewVersion(fileInputStream, this.getFileUploadNewVersionUrl(destinationFileId), this.mSession);
        return request;
    }

    public BoxRequestsFile.UploadNewVersion getUploadNewVersionRequest(File file, String destinationFileId) {
        try {
            BoxRequestsFile.UploadNewVersion request = this.getUploadNewVersionRequest(new FileInputStream(file), destinationFileId);
            request.setUploadSize(file.length());
            request.setModifiedDate(new Date(file.lastModified()));
            return request;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public BoxRequestsFile.DownloadFile getDownloadRequest(File target, String fileId) throws IOException {
        if (!target.exists()) {
            throw new FileNotFoundException();
        }
        BoxRequestsFile.DownloadFile request = new BoxRequestsFile.DownloadFile(target, this.getFileDownloadUrl(fileId), this.mSession);
        return request;
    }

    public BoxRequestsFile.DownloadFile getDownloadRequest(OutputStream outputStream, String fileId) {
        BoxRequestsFile.DownloadFile request = new BoxRequestsFile.DownloadFile(outputStream, this.getFileDownloadUrl(fileId), this.mSession);
        return request;
    }

    public BoxRequestsFile.DownloadThumbnail getDownloadThumbnailRequest(File target, String fileId) throws IOException {
        if (!target.exists()) {
            throw new FileNotFoundException();
        }
        BoxRequestsFile.DownloadThumbnail request = new BoxRequestsFile.DownloadThumbnail(target, this.getThumbnailFileDownloadUrl(fileId), this.mSession);
        return request;
    }

    public BoxRequestsFile.DownloadThumbnail getDownloadThumbnailRequest(OutputStream outputStream, String fileId) {
        BoxRequestsFile.DownloadThumbnail request = new BoxRequestsFile.DownloadThumbnail(outputStream, this.getThumbnailFileDownloadUrl(fileId), this.mSession);
        return request;
    }

    public BoxRequestsFile.GetTrashedFile getTrashedFileRequest(String id) {
        BoxRequestsFile.GetTrashedFile request = new BoxRequestsFile.GetTrashedFile(id, this.getTrashedFileUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFile.DeleteTrashedFile getDeleteTrashedFileRequest(String id) {
        BoxRequestsFile.DeleteTrashedFile request = new BoxRequestsFile.DeleteTrashedFile(id, this.getTrashedFileUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFile.RestoreTrashedFile getRestoreTrashedFileRequest(String id) {
        BoxRequestsFile.RestoreTrashedFile request = new BoxRequestsFile.RestoreTrashedFile(id, this.getFileInfoUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFile.GetFileComments getCommentsRequest(String id) {
        BoxRequestsFile.GetFileComments request = new BoxRequestsFile.GetFileComments(id, this.getFileCommentsUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFile.GetFileVersions getVersionsRequest(String id) {
        BoxRequestsFile.GetFileVersions request = new BoxRequestsFile.GetFileVersions(id, this.getFileVersionsUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFile.PromoteFileVersion getPromoteVersionRequest(String id, String versionId) {
        BoxRequestsFile.PromoteFileVersion request = new BoxRequestsFile.PromoteFileVersion(id, versionId, this.getPromoteFileVersionUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFile.DeleteFileVersion getDeleteVersionRequest(String id, String versionId) {
        BoxRequestsFile.DeleteFileVersion request = new BoxRequestsFile.DeleteFileVersion(versionId, this.getDeleteFileVersionUrl(id, versionId), this.mSession);
        return request;
    }

    public BoxRequestsFile.AddFileToCollection getAddToCollectionRequest(String fileId, String collectionId) {
        BoxRequestsFile.AddFileToCollection request = new BoxRequestsFile.AddFileToCollection(fileId, collectionId, this.getFileInfoUrl(fileId), this.mSession);
        return request;
    }

    public BoxRequestsFile.DeleteFileFromCollection getDeleteFromCollectionRequest(String id) {
        BoxRequestsFile.DeleteFileFromCollection request = new BoxRequestsFile.DeleteFileFromCollection(id, this.getFileInfoUrl(id), this.mSession);
        return request;
    }
}

