/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content;

import com.box.androidsdk.content.BoxApi;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.requests.BoxRequestsFolder;

public class BoxApiFolder
extends BoxApi {
    public BoxApiFolder(BoxSession session) {
        super(session);
    }

    protected String getFoldersUrl() {
        return String.format("%s/folders", this.getBaseUri());
    }

    protected String getFolderInfoUrl(String id) {
        return String.format("%s/%s", this.getFoldersUrl(), id);
    }

    protected String getFolderItemsUrl(String id) {
        return this.getFolderInfoUrl(id) + "/items";
    }

    protected String getFolderCollaborationsUrl(String id) {
        return this.getFolderInfoUrl(id) + "/collaborations";
    }

    protected String getFolderCopyUrl(String id) {
        return this.getFolderInfoUrl(id) + "/copy";
    }

    protected String getTrashedFolderUrl(String id) {
        return this.getFolderInfoUrl(id) + "/trash";
    }

    protected String getTrashedItemsUrl() {
        return this.getFoldersUrl() + "/trash/items";
    }

    public BoxRequestsFolder.GetFolderInfo getInfoRequest(String id) {
        BoxRequestsFolder.GetFolderInfo request = new BoxRequestsFolder.GetFolderInfo(id, this.getFolderInfoUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFolder.GetFolderItems getItemsRequest(String id) {
        BoxRequestsFolder.GetFolderItems request = new BoxRequestsFolder.GetFolderItems(id, this.getFolderItemsUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFolder.CreateFolder getCreateRequest(String parentId, String name) {
        BoxRequestsFolder.CreateFolder request = new BoxRequestsFolder.CreateFolder(parentId, name, this.getFoldersUrl(), this.mSession);
        return request;
    }

    public BoxRequestsFolder.UpdateFolder getUpdateRequest(String id) {
        BoxRequestsFolder.UpdateFolder request = new BoxRequestsFolder.UpdateFolder(id, this.getFolderInfoUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFolder.UpdateFolder getRenameRequest(String id, String newName) {
        BoxRequestsFolder.UpdateFolder request = (BoxRequestsFolder.UpdateFolder)new BoxRequestsFolder.UpdateFolder(id, this.getFolderInfoUrl(id), this.mSession).setName(newName);
        return request;
    }

    public BoxRequestsFolder.UpdateFolder getMoveRequest(String id, String parentId) {
        BoxRequestsFolder.UpdateFolder request = (BoxRequestsFolder.UpdateFolder)new BoxRequestsFolder.UpdateFolder(id, this.getFolderInfoUrl(id), this.mSession).setParentId(parentId);
        return request;
    }

    public BoxRequestsFolder.CopyFolder getCopyRequest(String id, String parentId) {
        BoxRequestsFolder.CopyFolder request = new BoxRequestsFolder.CopyFolder(id, parentId, this.getFolderCopyUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFolder.DeleteFolder getDeleteRequest(String id) {
        BoxRequestsFolder.DeleteFolder request = new BoxRequestsFolder.DeleteFolder(id, this.getFolderInfoUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFolder.GetCollaborations getCollaborationsRequest(String id) {
        BoxRequestsFolder.GetCollaborations request = new BoxRequestsFolder.GetCollaborations(id, this.getFolderCollaborationsUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFolder.UpdateSharedFolder getCreateSharedLinkRequest(String id) {
        BoxRequestsFolder.UpdateSharedFolder request = (BoxRequestsFolder.UpdateSharedFolder)new BoxRequestsFolder.UpdateSharedFolder(id, this.getFolderInfoUrl(id), this.mSession).setAccess(null);
        return request;
    }

    public BoxRequestsFolder.UpdateFolder getDisableSharedLinkRequest(String id) {
        BoxRequestsFolder.UpdateFolder request = (BoxRequestsFolder.UpdateFolder)new BoxRequestsFolder.UpdateFolder(id, this.getFolderInfoUrl(id), this.mSession).setSharedLink(null);
        return request;
    }

    public BoxRequestsFolder.AddFolderToCollection getAddToCollectionRequest(String folderId, String collectionId) {
        BoxRequestsFolder.AddFolderToCollection request = new BoxRequestsFolder.AddFolderToCollection(folderId, collectionId, this.getFolderInfoUrl(folderId), this.mSession);
        return request;
    }

    public BoxRequestsFolder.DeleteFolderFromCollection getDeleteFromCollectionRequest(String id) {
        BoxRequestsFolder.DeleteFolderFromCollection request = new BoxRequestsFolder.DeleteFolderFromCollection(id, this.getFolderInfoUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFolder.GetTrashedItems getTrashedItemsRequest() {
        BoxRequestsFolder.GetTrashedItems request = new BoxRequestsFolder.GetTrashedItems(this.getTrashedItemsUrl(), this.mSession);
        return request;
    }

    public BoxRequestsFolder.GetTrashedFolder getTrashedFolderRequest(String id) {
        BoxRequestsFolder.GetTrashedFolder request = new BoxRequestsFolder.GetTrashedFolder(id, this.getTrashedFolderUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFolder.DeleteTrashedFolder getDeleteTrashedFolderRequest(String id) {
        BoxRequestsFolder.DeleteTrashedFolder request = new BoxRequestsFolder.DeleteTrashedFolder(id, this.getTrashedFolderUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsFolder.RestoreTrashedFolder getRestoreTrashedFolderRequest(String id) {
        BoxRequestsFolder.RestoreTrashedFolder request = new BoxRequestsFolder.RestoreTrashedFolder(id, this.getFolderInfoUrl(id), this.mSession);
        return request;
    }
}

