/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content;

import com.box.androidsdk.content.BoxApi;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.requests.BoxRequestsUser;

public class BoxApiUser
extends BoxApi {
    public BoxApiUser(BoxSession session) {
        super(session);
    }

    protected String getUsersUrl() {
        return String.format("%s/users", this.getBaseUri());
    }

    protected String getUserInformationUrl(String id) {
        return String.format("%s/%s", this.getUsersUrl(), id);
    }

    public BoxRequestsUser.GetUserInfo getCurrentUserInfoRequest() {
        BoxRequestsUser.GetUserInfo request = new BoxRequestsUser.GetUserInfo(this.getUserInformationUrl("me"), this.mSession);
        return request;
    }

    public BoxRequestsUser.GetUserInfo getUserInfoRequest(String id) {
        BoxRequestsUser.GetUserInfo request = new BoxRequestsUser.GetUserInfo(this.getUserInformationUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsUser.GetEnterpriseUsers getEnterpriseUsersRequest() {
        BoxRequestsUser.GetEnterpriseUsers request = new BoxRequestsUser.GetEnterpriseUsers(this.getUsersUrl(), this.mSession);
        return request;
    }

    public BoxRequestsUser.CreateEnterpriseUser getCreateEnterpriseUserRequest(String login, String name) {
        BoxRequestsUser.CreateEnterpriseUser request = new BoxRequestsUser.CreateEnterpriseUser(this.getUsersUrl(), this.mSession, login, name);
        return request;
    }

    public BoxRequestsUser.DeleteEnterpriseUser getDeleteEnterpriseUserRequest(String userId) {
        BoxRequestsUser.DeleteEnterpriseUser request = new BoxRequestsUser.DeleteEnterpriseUser(this.getUserInformationUrl(userId), this.mSession, userId);
        return request;
    }
}

