/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content;

import com.box.androidsdk.content.models.BoxError;
import com.box.androidsdk.content.requests.BoxHttpResponse;

public class BoxException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final int responseCode;
    private String response;
    private BoxHttpResponse boxHttpResponse;

    public BoxException(String message) {
        super(message);
        this.responseCode = 0;
        this.boxHttpResponse = null;
        this.response = null;
    }

    public BoxException(String message, BoxHttpResponse response) {
        super(message, null);
        this.boxHttpResponse = response;
        this.responseCode = response != null ? response.getResponseCode() : 0;
        try {
            this.response = response.getStringBody();
        }
        catch (Exception e) {
            this.response = null;
        }
    }

    public BoxException(String message, Throwable cause) {
        super(message, cause);
        this.responseCode = 0;
        this.response = null;
    }

    public BoxException(String message, int responseCode, String response, Throwable cause) {
        super(message, cause);
        this.responseCode = responseCode;
        this.response = response;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponse() {
        return this.response;
    }

    public BoxError getAsBoxError() {
        try {
            BoxError error = new BoxError();
            error.createFromJson(this.getResponse());
            return error;
        }
        catch (Exception e) {
            return null;
        }
    }
}

