/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content;

import com.box.androidsdk.content.BoxException;
import com.box.androidsdk.content.models.BoxObject;
import com.box.androidsdk.content.requests.BoxRequest;
import com.box.androidsdk.content.requests.BoxResponse;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public class BoxFutureTask<E extends BoxObject>
extends FutureTask<BoxResponse<E>> {
    protected final BoxRequest mRequest;
    protected ArrayList<OnCompletedListener<E>> mCompletedListeners = new ArrayList();

    public BoxFutureTask(Class<E> clazz, final BoxRequest request) {
        super(new Callable<BoxResponse<E>>(){

            @Override
            public BoxResponse<E> call() throws Exception {
                Object ret = null;
                Exception ex = null;
                try {
                    ret = request.send();
                }
                catch (Exception e) {
                    ex = e;
                }
                return new BoxResponse<Object>(ret, ex, request);
            }
        });
        this.mRequest = request;
    }

    @Override
    protected void done() {
        BoxResponse<Object> response = null;
        Exception ex = null;
        try {
            response = (BoxResponse<Object>)this.get();
        }
        catch (InterruptedException e) {
            ex = e;
        }
        catch (ExecutionException e) {
            ex = e;
        }
        if (ex != null) {
            response = new BoxResponse<Object>(null, new BoxException("Unable to retrieve response from FutureTask.", ex), this.mRequest);
        }
        ArrayList<OnCompletedListener<E>> listener = this.getCompletionListeners();
        for (OnCompletedListener<Object> onCompletedListener : listener) {
            onCompletedListener.onCompleted(response);
        }
    }

    public ArrayList<OnCompletedListener<E>> getCompletionListeners() {
        return this.mCompletedListeners;
    }

    public BoxFutureTask<E> addOnCompletedListener(OnCompletedListener<E> listener) {
        this.mCompletedListeners.add(listener);
        return this;
    }

    public static interface OnCompletedListener<E extends BoxObject> {
        public void onCompleted(BoxResponse<E> var1);
    }
}

