/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.auth;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import com.box.androidsdk.content.auth.BoxAuthentication;
import com.box.androidsdk.content.utils.BoxLogUtils;
import com.box.androidsdk.content.utils.SdkUtils;
import com.box.sdk.android.R;
import java.util.List;

public class AuthenticatedAccountsAdapter
extends ArrayAdapter<BoxAuthentication.BoxAuthenticationInfo> {
    private static final int[] THUMB_COLORS = new int[]{-6381922, -10234140, -41121, -8465078, -5299724, -25001, -1752253, -10631001, -888412, -13733450, -1937604, -9007174, -11091626, -1061074, -11680004, -11528315, -1152974, -20195, -2195471};
    private static final int CREATE_NEW_TYPE_ID = 2;

    public AuthenticatedAccountsAdapter(Context context, int resource, List<BoxAuthentication.BoxAuthenticationInfo> objects) {
        super(context, resource, objects);
    }

    public int getViewTypeCount() {
        return 2;
    }

    public BoxAuthentication.BoxAuthenticationInfo getItem(int position) {
        if (position == this.getCount() - 1) {
            return new DifferentAuthenticationInfo();
        }
        return (BoxAuthentication.BoxAuthenticationInfo)super.getItem(position);
    }

    public int getItemViewType(int position) {
        if (position == this.getCount() - 1) {
            return 2;
        }
        return super.getItemViewType(position);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        BoxAuthentication.BoxAuthenticationInfo info;
        if (this.getItemViewType(position) == 2) {
            return LayoutInflater.from((Context)this.getContext()).inflate(R.layout.boxsdk_list_item_new_account, parent, false);
        }
        View rowView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.boxsdk_list_item_account, parent, false);
        ViewHolder holder = (ViewHolder)rowView.getTag();
        if (holder == null) {
            holder = new ViewHolder();
            holder.titleView = (TextView)rowView.findViewById(R.id.box_account_title);
            holder.descriptionView = (TextView)rowView.findViewById(R.id.box_account_description);
            holder.initialsView = (TextView)rowView.findViewById(R.id.box_account_initials);
            rowView.setTag((Object)holder);
        }
        if ((info = this.getItem(position)) != null && info.getUser() != null) {
            boolean hasName = !SdkUtils.isEmptyString(info.getUser().getName());
            String title = hasName ? info.getUser().getName() : info.getUser().getLogin();
            holder.titleView.setText((CharSequence)title);
            if (hasName) {
                holder.descriptionView.setText((CharSequence)info.getUser().getLogin());
            }
            this.setColorsThumb(holder.initialsView, position);
        } else if (info != null) {
            BoxLogUtils.e("invalid account info", info.toJson());
        }
        return rowView;
    }

    public int getCount() {
        return super.getCount() + 1;
    }

    @TargetApi(value=16)
    public void setColorsThumb(TextView initialsView, int position) {
        Drawable drawable2 = initialsView.getResources().getDrawable(R.drawable.boxsdk_thumb_background);
        drawable2.setColorFilter(THUMB_COLORS[position % THUMB_COLORS.length], PorterDuff.Mode.MULTIPLY);
        if (Build.VERSION.SDK_INT > 15) {
            initialsView.setBackground(drawable2);
        } else {
            initialsView.setBackgroundDrawable(drawable2);
        }
    }

    public static class DifferentAuthenticationInfo
    extends BoxAuthentication.BoxAuthenticationInfo {
    }

    public static class ViewHolder {
        public TextView titleView;
        public TextView descriptionView;
        public TextView initialsView;
    }
}

