/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.auth;

import com.box.androidsdk.content.BoxApi;
import com.box.androidsdk.content.BoxException;
import com.box.androidsdk.content.auth.BoxAuthentication;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.requests.BoxRequest;
import com.box.androidsdk.content.utils.SdkUtils;

class BoxApiAuthentication
extends BoxApi {
    static final String RESPONSE_TYPE_CODE = "code";
    static final String REFRESH_TOKEN = "refresh_token";
    static final String GRANT_TYPE = "grant_type";
    static final String GRANT_TYPE_AUTH_CODE = "authorization_code";
    static final String GRANT_TYPE_REFRESH = "refresh_token";
    static final String OAUTH_TOKEN_REQUEST_URL = "https://api.box.com/oauth2/token";
    static final String OAUTH_TOKEN_REVOKE_URL = "https://api.box.com/oauth2/revoke";

    BoxApiAuthentication(BoxSession account) {
        super(account);
        this.mBaseUri = "https://api.box.com";
    }

    BoxRefreshAuthRequest refreshOAuth(String refreshToken, String clientId, String clientSecret) {
        BoxRefreshAuthRequest request = new BoxRefreshAuthRequest(this.mSession, refreshToken, clientId, clientSecret);
        return request;
    }

    BoxCreateAuthRequest createOAuth(String code, String clientId, String clientSecret) {
        BoxCreateAuthRequest request = new BoxCreateAuthRequest(this.mSession, code, clientId, clientSecret);
        return request;
    }

    BoxRevokeAuthRequest revokeOAuth(String token, String clientId, String clientSecret) {
        BoxRevokeAuthRequest request = new BoxRevokeAuthRequest(this.mSession, token, clientId, clientSecret);
        return request;
    }

    static class BoxRevokeAuthRequest
    extends BoxRequest<BoxAuthentication.BoxAuthenticationInfo, BoxRevokeAuthRequest> {
        public BoxRevokeAuthRequest(BoxSession session, String token, String clientId, String clientSecret) {
            super(BoxAuthentication.BoxAuthenticationInfo.class, BoxApiAuthentication.OAUTH_TOKEN_REVOKE_URL, session);
            this.mRequestMethod = BoxRequest.Methods.POST;
            this.setContentType(BoxRequest.ContentTypes.URL_ENCODED);
            this.mBodyMap.put("client_id", clientId);
            this.mBodyMap.put("client_secret", clientSecret);
            this.mBodyMap.put("token", token);
        }
    }

    static class BoxCreateAuthRequest
    extends BoxRequest<BoxAuthentication.BoxAuthenticationInfo, BoxCreateAuthRequest> {
        public BoxCreateAuthRequest(BoxSession session, String code, String clientId, String clientSecret) {
            super(BoxAuthentication.BoxAuthenticationInfo.class, BoxApiAuthentication.OAUTH_TOKEN_REQUEST_URL, session);
            this.mRequestMethod = BoxRequest.Methods.POST;
            this.setContentType(BoxRequest.ContentTypes.URL_ENCODED);
            this.mBodyMap.put(BoxApiAuthentication.GRANT_TYPE, BoxApiAuthentication.GRANT_TYPE_AUTH_CODE);
            this.mBodyMap.put(BoxApiAuthentication.RESPONSE_TYPE_CODE, code);
            this.mBodyMap.put("client_id", clientId);
            this.mBodyMap.put("client_secret", clientSecret);
        }

        public BoxCreateAuthRequest setDevice(String deviceId, String deviceName) {
            if (!SdkUtils.isEmptyString(deviceId) && !SdkUtils.isEmptyString(deviceName)) {
                this.mBodyMap.put("device_id", deviceId);
                this.mBodyMap.put("device_name", deviceName);
            }
            return this;
        }
    }

    static class BoxRefreshAuthRequest
    extends BoxRequest<BoxAuthentication.BoxAuthenticationInfo, BoxRefreshAuthRequest> {
        public BoxRefreshAuthRequest(BoxSession session, String refreshToken, String clientId, String clientSecret) {
            super(BoxAuthentication.BoxAuthenticationInfo.class, BoxApiAuthentication.OAUTH_TOKEN_REQUEST_URL, session);
            this.mContentType = BoxRequest.ContentTypes.URL_ENCODED;
            this.mRequestMethod = BoxRequest.Methods.POST;
            this.mBodyMap.put(BoxApiAuthentication.GRANT_TYPE, "refresh_token");
            this.mBodyMap.put("refresh_token", refreshToken);
            this.mBodyMap.put("client_id", clientId);
            this.mBodyMap.put("client_secret", clientSecret);
        }

        @Override
        public BoxAuthentication.BoxAuthenticationInfo send() throws BoxException {
            BoxAuthentication.BoxAuthenticationInfo info = (BoxAuthentication.BoxAuthenticationInfo)super.send();
            info.setUser(this.mSession.getUser());
            return info;
        }
    }
}

