/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.auth;

import android.content.Context;
import android.content.Intent;
import com.box.androidsdk.content.BoxConfig;
import com.box.androidsdk.content.BoxException;
import com.box.androidsdk.content.auth.BoxApiAuthentication;
import com.box.androidsdk.content.auth.OAuthActivity;
import com.box.androidsdk.content.models.BoxCollaborator;
import com.box.androidsdk.content.models.BoxJsonObject;
import com.box.androidsdk.content.models.BoxMapJsonObject;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.models.BoxUser;
import com.box.androidsdk.content.utils.SdkUtils;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BoxAuthentication {
    private static BoxAuthentication mAuthentication = new BoxAuthentication();
    private ConcurrentLinkedQueue<WeakReference<AuthListener>> mListeners = new ConcurrentLinkedQueue();
    private ConcurrentHashMap<String, BoxAuthenticationInfo> mCurrentAccessInfo;
    private ConcurrentHashMap<String, FutureTask> mRefreshingTasks = new ConcurrentHashMap();
    public static final ThreadPoolExecutor AUTH_EXECUTOR = SdkUtils.createDefaultThreadPoolExecutor(1, 20, 3600L, TimeUnit.SECONDS);
    private int EXPIRATION_GRACE = 1000;
    private AuthStorage authStorage = new AuthStorage();

    private BoxAuthentication() {
    }

    public BoxAuthenticationInfo getAuthInfo(String userId, Context context) {
        return userId == null ? null : this.getAuthInfoMap(context).get(userId);
    }

    public Map<String, BoxAuthenticationInfo> getStoredAuthInfo(Context context) {
        return this.getAuthInfoMap(context);
    }

    public String getLastAuthenticatedUserId(Context context) {
        return this.authStorage.getLastAuthentictedUserId(context);
    }

    public static BoxAuthentication getInstance() {
        return mAuthentication;
    }

    public void setAuthStorage(AuthStorage storage) {
        this.authStorage = storage;
    }

    public AuthStorage getAuthStorage() {
        return this.authStorage;
    }

    public synchronized void startAuthenticationUI(BoxSession session) {
        this.startAuthenticateUI(session, false);
    }

    protected synchronized void startAuthenticationUsingBoxApp(BoxSession session) {
        this.startAuthenticateUI(session, true);
    }

    public synchronized void onAuthenticated(BoxAuthenticationInfo info, Context context) {
        this.getAuthInfoMap(context).put(info.getUser().getId(), info.clone());
        this.authStorage.storeLastAuthenticatedUserId(info.getUser().getId(), context);
        this.authStorage.storeAuthInfoMap(this.mCurrentAccessInfo, context);
        for (WeakReference<AuthListener> reference : this.mListeners) {
            AuthListener rc = (AuthListener)reference.get();
            if (rc == null) continue;
            rc.onAuthCreated(info);
        }
    }

    public synchronized void onAuthenticationFailure(BoxAuthenticationInfo info, Exception ex) {
        for (WeakReference<AuthListener> reference : this.mListeners) {
            AuthListener rc = (AuthListener)reference.get();
            if (rc == null) continue;
            rc.onAuthFailure(info, ex);
        }
    }

    public synchronized void onLoggedOut(BoxAuthenticationInfo info, Exception ex) {
        for (WeakReference<AuthListener> reference : this.mListeners) {
            AuthListener rc = (AuthListener)reference.get();
            if (rc == null) continue;
            rc.onLoggedOut(info, ex);
        }
    }

    public synchronized void logout(BoxSession session) throws BoxException {
        BoxUser user = session.getUser();
        if (user == null) {
            return;
        }
        Context context = session.getApplicationContext();
        String userId = user.getId();
        this.getAuthInfoMap(session.getApplicationContext());
        BoxAuthenticationInfo info = this.mCurrentAccessInfo.get(userId);
        BoxApiAuthentication.BoxRevokeAuthRequest request = new BoxApiAuthentication.BoxRevokeAuthRequest(session, info.accessToken(), session.getClientId(), session.getClientSecret());
        request.send();
        info.wipeOutAuth();
        this.mCurrentAccessInfo.remove(userId);
        if (this.authStorage.getLastAuthentictedUserId(context).equals(userId)) {
            this.authStorage.storeLastAuthenticatedUserId(null, context);
        }
        this.authStorage.storeAuthInfoMap(this.mCurrentAccessInfo, context);
    }

    public synchronized void logoutAllUsers(Context context) {
        this.getAuthInfoMap(context);
        for (String userId : this.mCurrentAccessInfo.keySet()) {
            BoxAuthenticationInfo info = this.mCurrentAccessInfo.get(userId);
            if (info.getClientId() == null) continue;
            if (info.getClientId().equals(BoxConfig.CLIENT_ID)) {
                try {
                    BoxApiAuthentication.BoxRevokeAuthRequest request = new BoxApiAuthentication.BoxRevokeAuthRequest(new BoxSession(context, userId), info.accessToken(), BoxConfig.CLIENT_ID, BoxConfig.CLIENT_SECRET);
                    request.send();
                    this.onLoggedOut(info.clone(), null);
                    info.wipeOutAuth();
                }
                catch (BoxException e) {
                    e.printStackTrace();
                    this.onLoggedOut(info, e);
                }
                continue;
            }
            this.onLoggedOut(info, new NonDefaultClientLogoutException());
        }
        this.mCurrentAccessInfo.clear();
        this.authStorage.storeLastAuthenticatedUserId(null, context);
        this.authStorage.clearAuthInfoMap(context);
    }

    public synchronized void refresh(BoxSession session) throws BoxException {
        BoxUser user = session.getUser();
        this.getAuthInfoMap(session.getApplicationContext());
        BoxAuthenticationInfo info = this.mCurrentAccessInfo.get(user.getId());
        if (info == null) {
            this.mCurrentAccessInfo.put(user.getId(), session.getAuthInfo());
            info = this.mCurrentAccessInfo.get(user.getId());
        }
        if (!session.getAuthInfo().accessToken().equals(info.accessToken())) {
            BoxAuthenticationInfo.cloneInfo(session.getAuthInfo(), info);
            return;
        }
        FutureTask task = this.mRefreshingTasks.get(user.getId());
        if (task != null) {
            return;
        }
        this.doRefresh(session, user.getId(), info.refreshToken());
    }

    public synchronized void addListener(AuthListener listener) {
        this.mListeners.add(new WeakReference<AuthListener>(listener));
    }

    protected synchronized void startAuthenticateUI(BoxSession session, boolean viaBoxApp) {
        Context context = session.getApplicationContext();
        Intent intent = OAuthActivity.createOAuthActivityIntent(context, session, viaBoxApp);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    private void doRefresh(BoxSession session, String userId, String refreshToken) throws BoxException {
        session.getAuthInfo().setAccessToken("");
        BoxApiAuthentication.BoxRefreshAuthRequest request = new BoxApiAuthentication(session).refreshOAuth(refreshToken, session.getClientId(), session.getClientSecret());
        BoxAuthenticationInfo refreshInfo = request.send();
        if (refreshInfo != null) {
            refreshInfo.setRefreshTime(System.currentTimeMillis());
            this.getAuthInfoMap(session.getApplicationContext()).put(userId, refreshInfo);
            this.authStorage.storeAuthInfoMap(this.mCurrentAccessInfo, session.getApplicationContext());
            for (WeakReference<AuthListener> reference : this.mListeners) {
                AuthListener rc = (AuthListener)reference.get();
                if (rc == null) continue;
                rc.onRefreshed(refreshInfo);
            }
        }
    }

    private ConcurrentHashMap<String, BoxAuthenticationInfo> getAuthInfoMap(Context context) {
        if (this.mCurrentAccessInfo == null) {
            this.mCurrentAccessInfo = this.authStorage.loadAuthInfoMap(context);
        }
        return this.mCurrentAccessInfo;
    }

    public static class AuthStorage {
        private static final String AUTH_STORAGE_NAME = AuthStorage.class.getCanonicalName() + "_SharedPref";
        private static final String AUTH_MAP_STORAGE_KEY = AuthStorage.class.getCanonicalName() + "_authInfoMap";
        private static final String AUTH_STORAGE_LAST_AUTH_USER_ID_KEY = AuthStorage.class.getCanonicalName() + "_lastAuthUserId";

        protected void storeAuthInfoMap(Map<String, BoxAuthenticationInfo> authInfo, Context context) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : authInfo.keySet()) {
                map.put(key, authInfo.get(key));
            }
            BoxMapJsonObject infoMapObj = new BoxMapJsonObject(map);
            context.getSharedPreferences(AUTH_STORAGE_NAME, 0).edit().putString(AUTH_MAP_STORAGE_KEY, infoMapObj.toJson()).apply();
        }

        protected void clearAuthInfoMap(Context context) {
            context.getSharedPreferences(AUTH_STORAGE_NAME, 0).edit().remove(AUTH_MAP_STORAGE_KEY).apply();
        }

        protected void storeLastAuthenticatedUserId(String userId, Context context) {
            if (SdkUtils.isEmptyString(userId)) {
                context.getSharedPreferences(AUTH_STORAGE_NAME, 0).edit().remove(AUTH_STORAGE_LAST_AUTH_USER_ID_KEY).apply();
            } else {
                context.getSharedPreferences(AUTH_STORAGE_NAME, 0).edit().putString(AUTH_STORAGE_LAST_AUTH_USER_ID_KEY, userId).apply();
            }
        }

        protected String getLastAuthentictedUserId(Context context) {
            return context.getSharedPreferences(AUTH_STORAGE_NAME, 0).getString(AUTH_STORAGE_LAST_AUTH_USER_ID_KEY, null);
        }

        protected ConcurrentHashMap<String, BoxAuthenticationInfo> loadAuthInfoMap(Context context) {
            ConcurrentHashMap<String, BoxAuthenticationInfo> map = new ConcurrentHashMap<String, BoxAuthenticationInfo>();
            String json = context.getSharedPreferences(AUTH_STORAGE_NAME, 0).getString(AUTH_MAP_STORAGE_KEY, "");
            if (json.length() > 0) {
                BoxMapJsonObject obj = new BoxMapJsonObject();
                obj.createFromJson(json);
                HashMap<String, Object> parsed = obj.getPropertiesAsHashMap();
                for (Map.Entry<String, Object> entry : parsed.entrySet()) {
                    BoxAuthenticationInfo info = null;
                    if (entry.getValue() instanceof String) {
                        info = new BoxAuthenticationInfo();
                        info.createFromJson((String)entry.getValue());
                    } else if (entry.getValue() instanceof BoxAuthenticationInfo) {
                        info = (BoxAuthenticationInfo)entry.getValue();
                    }
                    map.put(entry.getKey(), info);
                }
            }
            return map;
        }
    }

    public static class BoxAuthenticationInfo
    extends BoxJsonObject {
        private static final long serialVersionUID = 2878150977399126399L;
        private static final String FIELD_REFRESH_TIME = "refresh_time";
        public static final String FIELD_CLIENT_ID = "client_id";
        public static final String FIELD_ACCESS_TOKEN = "access_token";
        public static final String FIELD_REFRESH_TOKEN = "refresh_token";
        public static final String FIELD_EXPIRES_IN = "expires_in";
        public static final String FIELD_USER = "user";

        public BoxAuthenticationInfo clone() {
            BoxAuthenticationInfo cloned = new BoxAuthenticationInfo();
            BoxAuthenticationInfo.cloneInfo(cloned, this);
            return cloned;
        }

        public static void cloneInfo(BoxAuthenticationInfo targetInfo, BoxAuthenticationInfo sourceInfo) {
            targetInfo.setAccessToken(sourceInfo.accessToken());
            targetInfo.setRefreshToken(sourceInfo.refreshToken());
            targetInfo.setRefreshTime(sourceInfo.getRefreshTime());
            targetInfo.setClientId(sourceInfo.getClientId());
            if (targetInfo.getUser() == null) {
                targetInfo.setUser(sourceInfo.getUser());
            }
        }

        public String getClientId() {
            return (String)this.mProperties.get(FIELD_CLIENT_ID);
        }

        public String accessToken() {
            return (String)this.mProperties.get(FIELD_ACCESS_TOKEN);
        }

        public String refreshToken() {
            return (String)this.mProperties.get(FIELD_REFRESH_TOKEN);
        }

        public Long expiresIn() {
            return (Long)this.mProperties.get(FIELD_EXPIRES_IN);
        }

        public Long getRefreshTime() {
            return (Long)this.mProperties.get(FIELD_REFRESH_TIME);
        }

        public void setRefreshTime(Long refreshTime) {
            this.mProperties.put(FIELD_REFRESH_TIME, refreshTime);
        }

        public void setClientId(String clientId) {
            this.mProperties.put(FIELD_CLIENT_ID, clientId);
        }

        public void setAccessToken(String access) {
            this.mProperties.put(FIELD_ACCESS_TOKEN, access);
        }

        public void setRefreshToken(String refresh) {
            this.mProperties.put(FIELD_REFRESH_TOKEN, refresh);
        }

        public void setUser(BoxUser user) {
            this.mProperties.put(FIELD_USER, user);
        }

        public BoxUser getUser() {
            return (BoxUser)this.mProperties.get(FIELD_USER);
        }

        public void wipeOutAuth() {
            this.setUser(null);
            this.setClientId(null);
            this.setAccessToken(null);
            this.setRefreshToken(null);
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            String memberName = member.getName();
            JsonValue value = member.getValue();
            if (memberName.equals(FIELD_ACCESS_TOKEN)) {
                this.mProperties.put(FIELD_ACCESS_TOKEN, value.asString());
                return;
            }
            if (memberName.equals(FIELD_REFRESH_TOKEN)) {
                this.mProperties.put(FIELD_REFRESH_TOKEN, value.asString());
                return;
            }
            if (memberName.equals(FIELD_USER)) {
                this.mProperties.put(FIELD_USER, BoxCollaborator.createCollaboratorFromJson(value.asObject()));
                return;
            }
            if (memberName.equals(FIELD_EXPIRES_IN)) {
                this.mProperties.put(FIELD_EXPIRES_IN, value.asLong());
                return;
            }
            if (memberName.equals(FIELD_REFRESH_TIME)) {
                this.mProperties.put(FIELD_REFRESH_TIME, SdkUtils.parseJsonValueToLong(value));
                return;
            }
            if (memberName.equals(FIELD_CLIENT_ID)) {
                this.mProperties.put(FIELD_CLIENT_ID, value.asString());
                return;
            }
            super.parseJSONMember(member);
        }
    }

    public static class NonDefaultClientLogoutException
    extends Exception {
    }

    public static interface AuthListener {
        public void onRefreshed(BoxAuthenticationInfo var1);

        public void onAuthCreated(BoxAuthenticationInfo var1);

        public void onAuthFailure(BoxAuthenticationInfo var1, Exception var2);

        public void onLoggedOut(BoxAuthenticationInfo var1, Exception var2);
    }
}

