/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.auth;

import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.box.androidsdk.content.auth.AuthenticatedAccountsAdapter;
import com.box.androidsdk.content.auth.BoxAuthentication;
import com.box.sdk.android.R;
import java.util.ArrayList;
import java.util.Map;

public class ChooseAuthenticationFragment
extends Fragment {
    private ListView mListView;
    private static final String EXTRA_BOX_AUTHENTICATION_INFOS = "boxAuthenticationInfos";

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ArrayList<BoxAuthentication.BoxAuthenticationInfo> infos = this.getAuthenticationInfoList();
        View view = inflater.inflate(R.layout.boxsdk_choose_auth_activity, null);
        this.mListView = (ListView)view.findViewById(R.id.boxsdk_accounts_list);
        if (infos == null) {
            this.getActivity().getFragmentManager().beginTransaction().remove((Fragment)this).commit();
        } else {
            this.mListView.setAdapter((ListAdapter)new AuthenticatedAccountsAdapter((Context)this.getActivity(), R.layout.support_simple_spinner_dropdown_item, infos));
            this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    if (parent.getAdapter() instanceof AuthenticatedAccountsAdapter) {
                        AuthenticatedAccountsAdapter accountsAdapter = (AuthenticatedAccountsAdapter)parent.getAdapter();
                        BoxAuthentication.BoxAuthenticationInfo info = accountsAdapter.getItem(position);
                        if (info instanceof AuthenticatedAccountsAdapter.DifferentAuthenticationInfo) {
                            if (ChooseAuthenticationFragment.this.getActivity() instanceof OnAuthenticationChosen) {
                                ((OnAuthenticationChosen)ChooseAuthenticationFragment.this.getActivity()).onDifferentAuthenticationChosen();
                            }
                        } else if (ChooseAuthenticationFragment.this.getActivity() instanceof OnAuthenticationChosen) {
                            ((OnAuthenticationChosen)ChooseAuthenticationFragment.this.getActivity()).onAuthenticationChosen(info);
                        }
                    }
                }
            });
        }
        return view;
    }

    public ArrayList<BoxAuthentication.BoxAuthenticationInfo> getAuthenticationInfoList() {
        if (this.getArguments() != null && this.getArguments().getCharSequenceArrayList(EXTRA_BOX_AUTHENTICATION_INFOS) != null) {
            ArrayList jsonSerialized = this.getArguments().getCharSequenceArrayList(EXTRA_BOX_AUTHENTICATION_INFOS);
            ArrayList<BoxAuthentication.BoxAuthenticationInfo> list = new ArrayList<BoxAuthentication.BoxAuthenticationInfo>(jsonSerialized.size());
            for (CharSequence sequence : jsonSerialized) {
                BoxAuthentication.BoxAuthenticationInfo info = new BoxAuthentication.BoxAuthenticationInfo();
                info.createFromJson(sequence.toString());
                list.add(info);
            }
            return list;
        }
        Map<String, BoxAuthentication.BoxAuthenticationInfo> map = BoxAuthentication.getInstance().getStoredAuthInfo((Context)this.getActivity());
        if (map != null) {
            ArrayList<BoxAuthentication.BoxAuthenticationInfo> list = new ArrayList<BoxAuthentication.BoxAuthenticationInfo>(map.size());
            for (String key : map.keySet()) {
                list.add(map.get(key));
            }
            return list;
        }
        return null;
    }

    public static ChooseAuthenticationFragment createAuthenticationActivity(Context context) {
        ChooseAuthenticationFragment fragment = new ChooseAuthenticationFragment();
        return fragment;
    }

    public static ChooseAuthenticationFragment createChooseAuthenticationFragment(Context context, ArrayList<BoxAuthentication.BoxAuthenticationInfo> listOfAuthInfo) {
        ChooseAuthenticationFragment fragment = ChooseAuthenticationFragment.createAuthenticationActivity(context);
        Bundle b = fragment.getArguments();
        if (b == null) {
            b = new Bundle();
        }
        ArrayList<String> jsonSerialized = new ArrayList<String>(listOfAuthInfo.size());
        for (BoxAuthentication.BoxAuthenticationInfo info : listOfAuthInfo) {
            jsonSerialized.add(info.toJson());
        }
        b.putCharSequenceArrayList(EXTRA_BOX_AUTHENTICATION_INFOS, jsonSerialized);
        fragment.setArguments(b);
        return fragment;
    }

    public static interface OnAuthenticationChosen {
        public void onAuthenticationChosen(BoxAuthentication.BoxAuthenticationInfo var1);

        public void onDifferentAuthenticationChosen();
    }
}

