/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.auth;

import android.app.Activity;
import android.app.Dialog;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Bundle;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.widget.Toast;
import com.box.androidsdk.content.BoxApiUser;
import com.box.androidsdk.content.BoxFutureTask;
import com.box.androidsdk.content.auth.BoxApiAuthentication;
import com.box.androidsdk.content.auth.BoxAuthentication;
import com.box.androidsdk.content.auth.ChooseAuthenticationFragment;
import com.box.androidsdk.content.auth.OAuthWebView;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.models.BoxUser;
import com.box.androidsdk.content.requests.BoxResponse;
import com.box.androidsdk.content.utils.SdkUtils;
import com.box.sdk.android.R;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class OAuthActivity
extends Activity
implements ChooseAuthenticationFragment.OnAuthenticationChosen {
    public static final int REQUEST_BOX_APP_FOR_AUTH_CODE = 1;
    public static final String REQUEST_BOX_APP_FOR_AUTH_INTENT_ACTON = "com.box.android.requestBoxAppForAuth";
    public static final String AUTH_CODE = "authcode";
    public static final String EXTRA_USER_ID_RESTRICTION = "restrictToUserId";
    public static final String EXTRA_DISABLE_ACCOUNT_CHOOSING = "disableAccountChoosing";
    public static final int AUTH_TYPE_WEBVIEW = 0;
    public static final int AUTH_TYPE_APP = 1;
    protected static final String LOGIN_VIA_BOX_APP = "loginviaboxapp";
    public static final String AUTH_INFO = "authinfo";
    private static final String CHOOSE_AUTH_TAG = "choose_auth";
    private String mClientId;
    private String mClientSecret;
    private String mDeviceId;
    private String mDeviceName;
    private String mRedirectUrl;
    protected OAuthWebView oauthView;
    protected OAuthWebView.OAuthWebViewClient oauthClient;
    private static Dialog dialog;
    private boolean mAuthWasSuccessful = false;
    private int authType = 0;
    private AtomicBoolean apiCallStarted = new AtomicBoolean(false);

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.getContentView());
        Intent intent = this.getIntent();
        this.mClientId = intent.getStringExtra("client_id");
        this.mClientSecret = intent.getStringExtra("client_secret");
        this.mDeviceId = intent.getStringExtra("boxdeviceid");
        this.mDeviceName = intent.getStringExtra("boxdevicename");
        this.mRedirectUrl = intent.getStringExtra("redirect_uri");
        boolean loginViaBoxApp = intent.getBooleanExtra(LOGIN_VIA_BOX_APP, false);
        this.authType = loginViaBoxApp ? 1 : 0;
        this.apiCallStarted.getAndSet(false);
        this.startOAuth();
    }

    public void onReceivedAuthCode(String code) {
        if (this.authType == 0) {
            this.oauthView.setVisibility(4);
        }
        this.startMakingOAuthAPICall(code);
    }

    public void finish() {
        this.clearCachedAuthenticationData();
        if (!this.mAuthWasSuccessful) {
            BoxAuthentication.getInstance().onAuthenticationFailure(null, null);
        }
        super.finish();
    }

    public void onAuthFailure(OAuthWebView.AuthFailure failure) {
        if (SdkUtils.isEmptyString(failure.message)) {
            Toast.makeText((Context)this, (int)R.string.boxsdk_Authentication_fail, (int)1).show();
        } else {
            switch (failure.type) {
                case 1: {
                    Resources resources = this.getResources();
                    Toast.makeText((Context)this, (CharSequence)String.format("%s\n%s: %s", resources.getString(R.string.boxsdk_Authentication_fail), resources.getString(R.string.boxsdk_details), resources.getString(R.string.boxsdk_Authentication_fail_url_mismatch)), (int)1).show();
                    break;
                }
                default: {
                    Toast.makeText((Context)this, (int)R.string.boxsdk_Authentication_fail, (int)1).show();
                }
            }
        }
        this.finish();
    }

    protected int getContentView() {
        return R.layout.boxsdk_activity_oauth;
    }

    protected void startOAuth() {
        if (!this.getIntent().getBooleanExtra(EXTRA_DISABLE_ACCOUNT_CHOOSING, false) && this.getFragmentManager().findFragmentByTag(CHOOSE_AUTH_TAG) == null) {
            Map<String, BoxAuthentication.BoxAuthenticationInfo> map = BoxAuthentication.getInstance().getStoredAuthInfo((Context)this);
            if (SdkUtils.isEmptyString(this.getIntent().getStringExtra(EXTRA_USER_ID_RESTRICTION)) && map != null && map.size() > 0) {
                FragmentTransaction transaction = this.getFragmentManager().beginTransaction();
                transaction.replace(R.id.oauth_container, (Fragment)ChooseAuthenticationFragment.createAuthenticationActivity((Context)this), CHOOSE_AUTH_TAG);
                transaction.addToBackStack(CHOOSE_AUTH_TAG);
                transaction.commit();
            }
        }
        switch (this.authType) {
            case 0: {
                this.oauthView = this.createOAuthView();
                this.oauthClient = this.createOAuthWebViewClient(this.oauthView.getStateString());
                this.oauthView.setWebViewClient(this.oauthClient);
                this.oauthView.authenticate(this.mClientId, this.mRedirectUrl);
                break;
            }
            case 1: {
                Intent intent = new Intent(REQUEST_BOX_APP_FOR_AUTH_INTENT_ACTON);
                intent.putExtra("client_id", this.mClientId);
                intent.putExtra("redirect_uri", this.mRedirectUrl);
                this.startActivityForResult(intent, 1);
            }
        }
    }

    public void onBackPressed() {
        if (this.getFragmentManager().findFragmentByTag(CHOOSE_AUTH_TAG) != null) {
            this.dismissSpinnerAndFailAuthenticate(this.getString(R.string.boxsdk_Authentication_cancelled));
        }
        super.onBackPressed();
    }

    @Override
    public void onAuthenticationChosen(BoxAuthentication.BoxAuthenticationInfo authInfo) {
        if (authInfo != null) {
            BoxAuthentication.getInstance().onAuthenticated(authInfo, (Context)this);
            this.dismissSpinnerAndFinishAuthenticate(authInfo);
        }
    }

    @Override
    public void onDifferentAuthenticationChosen() {
        Fragment fragment = this.getFragmentManager().findFragmentByTag(CHOOSE_AUTH_TAG);
        if (fragment != null) {
            this.getFragmentManager().popBackStack();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (-1 == resultCode && 1 == requestCode) {
            String authCode = data.getStringExtra(AUTH_CODE);
            this.startMakingOAuthAPICall(authCode);
        }
    }

    protected void startMakingOAuthAPICall(String code) {
        if (this.apiCallStarted.getAndSet(true)) {
            return;
        }
        this.showSpinner();
        final BoxSession session = new BoxSession((Context)this, null, this.mClientId, this.mClientSecret, this.mRedirectUrl);
        BoxApiAuthentication api = new BoxApiAuthentication(session);
        BoxApiAuthentication.BoxCreateAuthRequest request = api.createOAuth(code, this.mClientId, this.mClientSecret).setDevice(this.mDeviceId, this.mDeviceName);
        BoxFutureTask<BoxAuthentication.BoxAuthenticationInfo> task = request.toTask().addOnCompletedListener(new BoxFutureTask.OnCompletedListener<BoxAuthentication.BoxAuthenticationInfo>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted(BoxResponse<BoxAuthentication.BoxAuthenticationInfo> response) {
                if (!response.isSuccess()) {
                    OAuthActivity.this.dismissSpinnerAndFailAuthenticate(OAuthActivity.this.getAuthCreationErrorString(response.getException()));
                } else {
                    BoxAuthentication.BoxAuthenticationInfo auth = response.getResult();
                    BoxAuthentication.BoxAuthenticationInfo sessionAuth = session.getAuthInfo();
                    sessionAuth.setAccessToken(auth.accessToken());
                    sessionAuth.setRefreshToken(auth.refreshToken());
                    sessionAuth.setRefreshTime(System.currentTimeMillis());
                    sessionAuth.setClientId(session.getClientId());
                    BoxApiUser userApi = new BoxApiUser(session);
                    boolean fail = true;
                    Exception exception = null;
                    try {
                        BoxUser user = (BoxUser)userApi.getCurrentUserInfoRequest().send();
                        String restrictedUserId = OAuthActivity.this.getIntent().getStringExtra(OAuthActivity.EXTRA_USER_ID_RESTRICTION);
                        if (!SdkUtils.isEmptyString(restrictedUserId) && !user.getId().equals(restrictedUserId)) {
                            throw new RuntimeException("Unexpected user logged in. Expected " + restrictedUserId + " received " + user.getId());
                        }
                        sessionAuth.setUser(user);
                        BoxAuthentication.getInstance().onAuthenticated(sessionAuth, (Context)OAuthActivity.this);
                        fail = false;
                    }
                    catch (Exception e) {
                        exception = e;
                    }
                    finally {
                        if (!fail) {
                            OAuthActivity.this.dismissSpinnerAndFinishAuthenticate(sessionAuth);
                        } else {
                            OAuthActivity.this.dismissSpinnerAndFailAuthenticate(OAuthActivity.this.getAuthCreationErrorString(exception));
                        }
                    }
                }
            }
        });
        BoxAuthentication.AUTH_EXECUTOR.submit(task);
    }

    protected void dismissSpinnerAndFinishAuthenticate(final BoxAuthentication.BoxAuthenticationInfo auth) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                OAuthActivity.this.dismissSpinner();
                Intent intent = new Intent();
                intent.putExtra(OAuthActivity.AUTH_INFO, (Serializable)auth);
                OAuthActivity.this.setResult(-1, intent);
                OAuthActivity.this.mAuthWasSuccessful = true;
                OAuthActivity.this.finish();
            }
        });
    }

    protected void dismissSpinnerAndFailAuthenticate(final String error) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                OAuthActivity.this.dismissSpinner();
                Toast.makeText((Context)OAuthActivity.this, (CharSequence)error, (int)1).show();
                OAuthActivity.this.setResult(0);
                OAuthActivity.this.finish();
            }
        });
    }

    protected OAuthWebView createOAuthView() {
        OAuthWebView webview = (OAuthWebView)this.findViewById(this.getOAuthWebViewRId());
        webview.setVisibility(0);
        webview.getSettings().setJavaScriptEnabled(true);
        return webview;
    }

    protected OAuthWebView.OAuthWebViewClient createOAuthWebViewClient(String optionalState) {
        return new OAuthWebView.OAuthWebViewClient(this, this.mRedirectUrl, optionalState);
    }

    protected int getOAuthWebViewRId() {
        return R.id.oauthview;
    }

    protected Dialog showDialogWhileWaitingForAuthenticationAPICall() {
        return ProgressDialog.show((Context)this, (CharSequence)this.getText(R.string.boxsdk_Authenticating), (CharSequence)this.getText(R.string.boxsdk_Please_wait));
    }

    protected void showSpinner() {
        try {
            dialog = this.showDialogWhileWaitingForAuthenticationAPICall();
        }
        catch (Exception e) {
            dialog = null;
            return;
        }
    }

    protected void dismissSpinner() {
        if (dialog != null && dialog.isShowing()) {
            try {
                dialog.dismiss();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            dialog = null;
        }
    }

    public void onDestroy() {
        this.apiCallStarted.set(false);
        this.dismissSpinner();
        super.onDestroy();
    }

    public static Intent createOAuthActivityIntent(Context context, String clientId, String clientSecret, String redirectUrl, boolean loginViaBoxApp) {
        Intent intent = new Intent(context, OAuthActivity.class);
        intent.putExtra("client_id", clientId);
        intent.putExtra("client_secret", clientSecret);
        if (!SdkUtils.isEmptyString(redirectUrl)) {
            intent.putExtra("redirect_uri", redirectUrl);
        }
        intent.putExtra(LOGIN_VIA_BOX_APP, loginViaBoxApp);
        return intent;
    }

    public static Intent createOAuthActivityIntent(Context context, BoxSession session, boolean loginViaBoxApp) {
        Intent intent = OAuthActivity.createOAuthActivityIntent(context, session.getClientId(), session.getClientSecret(), session.getRedirectUrl(), loginViaBoxApp);
        if (!SdkUtils.isEmptyString(session.getUserId())) {
            intent.putExtra(EXTRA_USER_ID_RESTRICTION, session.getUserId());
        }
        return intent;
    }

    private String getAuthCreationErrorString(Exception e) {
        String error = this.getString(R.string.boxsdk_Authentication_fail);
        if (e != null) {
            error = error + ":" + e;
        }
        return error;
    }

    private void clearCachedAuthenticationData() {
        if (this.oauthView != null) {
            this.oauthView.clearCache(true);
            this.oauthView.clearFormData();
            this.oauthView.clearHistory();
        }
        CookieSyncManager.createInstance((Context)this);
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.removeAllCookie();
        this.deleteDatabase("webview.db");
        this.deleteDatabase("webviewCache.db");
        File cacheDirectory = this.getCacheDir();
        SdkUtils.deleteFolderRecursive(cacheDirectory);
        cacheDirectory.mkdir();
    }
}

