/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.auth;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.EditText;
import com.box.androidsdk.content.BoxConfig;
import com.box.androidsdk.content.auth.OAuthActivity;
import com.box.androidsdk.content.utils.SdkUtils;
import com.box.sdk.android.R;

public class OAuthWebView
extends WebView {
    private static final String STATE = "state";
    private String state;

    public OAuthWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public String getStateString() {
        return this.state;
    }

    public void authenticate(String clientId, String redirectUrl) {
        this.state = SdkUtils.generateStateToken();
        this.loadUrl(this.buildUrl(clientId, redirectUrl).build().toString());
    }

    protected Uri.Builder buildUrl(String clientId, String redirectUrl) {
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("https");
        builder.authority("app.box.com");
        builder.appendPath("api");
        builder.appendPath("oauth2");
        builder.appendPath("authorize");
        builder.appendQueryParameter("response_type", "code");
        builder.appendQueryParameter("client_id", clientId);
        builder.appendQueryParameter("redirect_uri", redirectUrl);
        builder.appendQueryParameter(STATE, this.state);
        return builder;
    }

    public static class AuthFailure {
        public static final int TYPE_USER_INTERACTION = 0;
        public static final int TYPE_URL_MISMATCH = 1;
        public int type;
        public String message;

        public AuthFailure(int failType, String failMessage) {
            this.type = failType;
            this.message = failMessage;
        }
    }

    private static class InvalidUrlException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private InvalidUrlException() {
        }
    }

    public static interface OnPageFinishedListener {
        public void onPageFinished(WebView var1, String var2);
    }

    public static class OAuthWebViewClient
    extends WebViewClient {
        private boolean sslErrorDialogButtonClicked;
        private OAuthActivity mActivity;
        private String mRedirectUrl;
        private OnPageFinishedListener mOnPageFinishedListener;
        private String state;

        public OAuthWebViewClient(OAuthActivity activity, String redirectUrl, String stateString) {
            this.mActivity = activity;
            this.mRedirectUrl = redirectUrl;
            this.state = stateString;
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            try {
                String code = this.getCodeFromUrl(url);
                if (!SdkUtils.isEmptyString(code)) {
                    this.mActivity.onReceivedAuthCode(code);
                }
            }
            catch (InvalidUrlException e) {
                this.mActivity.onAuthFailure(new AuthFailure(1, null));
            }
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (this.mOnPageFinishedListener != null) {
                this.mOnPageFinishedListener.onPageFinished(view, url);
            }
        }

        public void onReceivedHttpAuthRequest(WebView view, final HttpAuthHandler handler, String host, String realm) {
            LayoutInflater factory = this.mActivity.getLayoutInflater();
            final View textEntryView = factory.inflate(R.layout.boxsdk_alert_dialog_text_entry, null);
            AlertDialog loginAlert = new AlertDialog.Builder((Context)this.mActivity).setTitle(R.string.boxsdk_alert_dialog_text_entry).setView(textEntryView).setPositiveButton(R.string.boxsdk_alert_dialog_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                    String userName = ((EditText)textEntryView.findViewById(R.id.username_edit)).getText().toString();
                    String password = ((EditText)textEntryView.findViewById(R.id.password_edit)).getText().toString();
                    handler.proceed(userName, password);
                }
            }).setNegativeButton(R.string.boxsdk_alert_dialog_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                    handler.cancel();
                    OAuthWebViewClient.this.mActivity.onAuthFailure(new AuthFailure(0, null));
                }
            }).create();
            loginAlert.show();
        }

        public void onReceivedSslError(WebView view, final SslErrorHandler handler, SslError error) {
            String sslErrorType;
            Resources resources = view.getContext().getResources();
            StringBuilder sslErrorMessage = new StringBuilder(resources.getString(R.string.boxsdk_There_are_problems_with_the_security_certificate_for_this_site));
            sslErrorMessage.append(" ");
            switch (error.getPrimaryError()) {
                case 4: {
                    sslErrorType = view.getResources().getString(R.string.boxsdk_ssl_error_warning_DATE_INVALID);
                    break;
                }
                case 1: {
                    sslErrorType = resources.getString(R.string.boxsdk_ssl_error_warning_EXPIRED);
                    break;
                }
                case 2: {
                    sslErrorType = resources.getString(R.string.boxsdk_ssl_error_warning_ID_MISMATCH);
                    break;
                }
                case 0: {
                    sslErrorType = resources.getString(R.string.boxsdk_ssl_error_warning_NOT_YET_VALID);
                    break;
                }
                case 3: {
                    sslErrorType = resources.getString(R.string.boxsdk_ssl_error_warning_UNTRUSTED);
                    break;
                }
                case 5: {
                    sslErrorType = resources.getString(R.string.boxsdk_ssl_error_warning_INVALID);
                    break;
                }
                default: {
                    sslErrorType = resources.getString(R.string.boxsdk_ssl_error_warning_INVALID);
                }
            }
            sslErrorMessage.append(sslErrorType);
            sslErrorMessage.append(" ");
            sslErrorMessage.append(resources.getString(R.string.boxsdk_ssl_should_not_proceed));
            this.sslErrorDialogButtonClicked = false;
            AlertDialog.Builder alertBuilder = new AlertDialog.Builder(view.getContext()).setTitle(R.string.boxsdk_Security_Warning).setMessage((CharSequence)sslErrorMessage.toString()).setIcon(R.drawable.boxsdk_dialog_warning).setNegativeButton(R.string.boxsdk_Go_back, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                    OAuthWebViewClient.this.sslErrorDialogButtonClicked = true;
                    handler.cancel();
                    OAuthWebViewClient.this.mActivity.onAuthFailure(new AuthFailure(0, null));
                }
            });
            if (BoxConfig.ALLOW_SSL_ERROR) {
                alertBuilder.setPositiveButton(R.string.boxsdk_Continue, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        OAuthWebViewClient.this.sslErrorDialogButtonClicked = true;
                        handler.proceed();
                    }
                });
            }
            AlertDialog loginAlert = alertBuilder.create();
            loginAlert.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    if (!OAuthWebViewClient.this.sslErrorDialogButtonClicked) {
                        OAuthWebViewClient.this.mActivity.onAuthFailure(new AuthFailure(0, null));
                    }
                }
            });
            loginAlert.show();
        }

        public void destroy() {
            this.mActivity = null;
        }

        private String getCodeFromUrl(String url) throws InvalidUrlException {
            String stateQ;
            Uri redirectUri;
            Uri uri = Uri.parse((String)url);
            if (!(SdkUtils.isEmptyString(this.mRedirectUrl) || (redirectUri = Uri.parse((String)this.mRedirectUrl)).getScheme() != null && redirectUri.getScheme().equals(uri.getScheme()) && redirectUri.getAuthority().equals(uri.getAuthority()))) {
                return null;
            }
            String code = null;
            try {
                code = uri.getQueryParameter("code");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!(SdkUtils.isEmptyString(code) || SdkUtils.isEmptyString(this.state) || this.state.equals(stateQ = uri.getQueryParameter(OAuthWebView.STATE)))) {
                throw new InvalidUrlException();
            }
            return code;
        }

        public void setOnPageFinishedListener(OnPageFinishedListener listener) {
            this.mOnPageFinishedListener = listener;
        }
    }
}

