/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.models;

import android.text.TextUtils;
import com.box.androidsdk.content.models.BoxItem;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class BoxBookmark
extends BoxItem {
    public static final String TYPE = "web_link";
    public static final String FIELD_URL = "url";
    public static final String FIELD_COMMENT_COUNT = "comment_count";
    public static final String[] ALL_FIELDS = new String[]{"type", "id", "sequence_id", "etag", "name", "url", "created_at", "modified_at", "description", "path_collection", "created_by", "modified_by", "trashed_at", "purged_at", "owned_by", "shared_link", "parent", "item_status", "permissions", "comment_count"};

    public BoxBookmark() {
    }

    public BoxBookmark(Map<String, Object> map) {
        super(map);
    }

    public static BoxBookmark createFromId(String bookmarkId) {
        LinkedHashMap<String, Object> bookmarkMap = new LinkedHashMap<String, Object>();
        bookmarkMap.put("id", bookmarkId);
        bookmarkMap.put("type", TYPE);
        return new BoxBookmark(bookmarkMap);
    }

    public String getUrl() {
        return (String)this.mProperties.get(FIELD_URL);
    }

    @Override
    public Long getCommentCount() {
        return super.getCommentCount();
    }

    @Override
    public Long getSize() {
        return null;
    }

    public EnumSet<Permission> getPermissions() {
        return (EnumSet)this.mProperties.get("permissions");
    }

    @Override
    protected void parseJSONMember(JsonObject.Member member) {
        String memberName = member.getName();
        JsonValue value = member.getValue();
        if (memberName.equals(FIELD_URL)) {
            this.mProperties.put(FIELD_URL, value.asString());
            return;
        }
        if (memberName.equals("permissions")) {
            this.mProperties.put("permissions", this.parsePermissions(value.asObject()));
            return;
        }
        super.parseJSONMember(member);
    }

    private EnumSet<Permission> parsePermissions(JsonObject jsonObject) {
        EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
        for (JsonObject.Member member : jsonObject) {
            JsonValue value = member.getValue();
            if (value.isNull() || !value.asBoolean()) continue;
            String memberName = member.getName();
            if (memberName.equals("can_rename")) {
                permissions.add(Permission.CAN_RENAME);
                continue;
            }
            if (memberName.equals("can_delete")) {
                permissions.add(Permission.CAN_DELETE);
                continue;
            }
            if (memberName.equals("can_share")) {
                permissions.add(Permission.CAN_SHARE);
                continue;
            }
            if (memberName.equals("can_set_share_access")) {
                permissions.add(Permission.CAN_SET_SHARE_ACCESS);
                continue;
            }
            if (!memberName.equals("can_comment")) continue;
            permissions.add(Permission.CAN_COMMENT);
        }
        return permissions;
    }

    public static enum Permission {
        CAN_RENAME("can_rename"),
        CAN_DELETE("can_delete"),
        CAN_SHARE("can_share"),
        CAN_SET_SHARE_ACCESS("can_set_share_access"),
        CAN_COMMENT("can_comment");

        private final String value;

        private Permission(String value) {
            this.value = value;
        }

        public static Permission fromString(String text) {
            if (!TextUtils.isEmpty((CharSequence)text)) {
                for (Permission a : Permission.values()) {
                    if (!text.equalsIgnoreCase(a.name())) continue;
                    return a;
                }
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "No enum with text %s found", text));
        }

        public String toString() {
            return this.value;
        }
    }
}

