/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.models;

import android.text.TextUtils;
import com.box.androidsdk.content.models.BoxCollaborator;
import com.box.androidsdk.content.models.BoxEntity;
import com.box.androidsdk.content.models.BoxFolder;
import com.box.androidsdk.content.models.BoxUser;
import com.box.androidsdk.content.utils.BoxDateFormat;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class BoxCollaboration
extends BoxEntity {
    private static final long serialVersionUID = 8125965031679671555L;
    public static final String TYPE = "collaboration";
    public static final String FIELD_CREATED_BY = "created_by";
    public static final String FIELD_CREATED_AT = "created_at";
    public static final String FIELD_MODIFIED_AT = "modified_at";
    public static final String FIELD_EXPIRES_AT = "expires_at";
    public static final String FIELD_STATUS = "status";
    public static final String FIELD_ACCESSIBLE_BY = "accessible_by";
    public static final String FIELD_ROLE = "role";
    public static final String FIELD_ACKNOWLEDGED_AT = "acknowledged_at";
    public static final String FIELD_ITEM = "item";
    public static final String[] ALL_FIELDS = new String[]{"type", "id", "created_by", "created_at", "modified_at", "expires_at", "status", "accessible_by", "role", "acknowledged_at", "item"};

    public BoxCollaboration() {
    }

    public BoxCollaboration(Map<String, Object> map) {
        super(map);
    }

    public BoxCollaborator getCreatedBy() {
        return (BoxCollaborator)this.mProperties.get(FIELD_CREATED_BY);
    }

    public Date getCreatedAt() {
        return (Date)this.mProperties.get(FIELD_CREATED_AT);
    }

    public Date getModifiedAt() {
        return (Date)this.mProperties.get(FIELD_MODIFIED_AT);
    }

    public Date getExpiresAt() {
        return (Date)this.mProperties.get(FIELD_EXPIRES_AT);
    }

    public Status getStatus() {
        return (Status)((Object)this.mProperties.get(FIELD_STATUS));
    }

    public BoxCollaborator getAccessibleBy() {
        return (BoxCollaborator)this.mProperties.get(FIELD_ACCESSIBLE_BY);
    }

    public Role getRole() {
        return (Role)((Object)this.mProperties.get(FIELD_ROLE));
    }

    public Date getAcknowledgedAt() {
        return (Date)this.mProperties.get(FIELD_ACKNOWLEDGED_AT);
    }

    public BoxFolder getItem() {
        return (BoxFolder)this.mProperties.get(FIELD_ITEM);
    }

    @Override
    protected void parseJSONMember(JsonObject.Member member) {
        block12: {
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals(FIELD_CREATED_BY)) {
                    this.mProperties.put(FIELD_CREATED_BY, BoxCollaborator.createCollaboratorFromJson(value.asObject()));
                    return;
                }
                if (memberName.equals(FIELD_CREATED_AT)) {
                    this.mProperties.put(FIELD_CREATED_AT, BoxDateFormat.parse(value.asString()));
                    return;
                }
                if (memberName.equals(FIELD_MODIFIED_AT)) {
                    this.mProperties.put(FIELD_MODIFIED_AT, BoxDateFormat.parse(value.asString()));
                    return;
                }
                if (memberName.equals(FIELD_EXPIRES_AT)) {
                    this.mProperties.put(FIELD_EXPIRES_AT, BoxDateFormat.parse(value.asString()));
                    return;
                }
                if (memberName.equals(FIELD_STATUS)) {
                    this.mProperties.put(FIELD_STATUS, Status.fromString(value.asString()));
                    return;
                }
                if (memberName.equals(FIELD_ACCESSIBLE_BY)) {
                    BoxUser accessibleBy = new BoxUser();
                    accessibleBy.createFromJson(value.asObject());
                    this.mProperties.put(FIELD_ACCESSIBLE_BY, accessibleBy);
                    return;
                }
                if (memberName.equals(FIELD_ROLE)) {
                    this.mProperties.put(FIELD_ROLE, Role.fromString(value.asString()));
                    return;
                }
                if (memberName.equals(FIELD_ACKNOWLEDGED_AT)) {
                    this.mProperties.put(FIELD_ACKNOWLEDGED_AT, BoxDateFormat.parse(value.asString()));
                    return;
                }
                if (memberName.equals(FIELD_ITEM)) {
                    JsonObject itemObj = value.asObject();
                    String itemType = itemObj.get("type").asString();
                    if (!itemType.equals("folder")) {
                        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unsupported type \"%s\" for collaboration found", itemType));
                    }
                    BoxFolder entity = new BoxFolder();
                    entity.createFromJson(itemObj);
                    this.mProperties.put(FIELD_ITEM, entity);
                    return;
                }
            }
            catch (ParseException e) {
                if ($assertionsDisabled) break block12;
                throw new AssertionError((Object)"A ParseException indicates a bug in the SDK.");
            }
        }
        super.parseJSONMember(member);
    }

    public static enum Role {
        EDITOR("editor"),
        VIEWER("viewer"),
        PREVIEWER("previewer"),
        UPLOADER("uploader"),
        PREVIEWER_UPLOADER("previewer uploader"),
        VIEWER_UPLOADER("viewer uploader"),
        CO_OWNER("co-owner"),
        OWNER("owner");

        private final String mValue;

        private Role(String value) {
            this.mValue = value;
        }

        public static Role fromString(String text) {
            if (!TextUtils.isEmpty((CharSequence)text)) {
                for (Role e : Role.values()) {
                    if (!text.equalsIgnoreCase(e.toString())) continue;
                    return e;
                }
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "No enum with text %s found", text));
        }

        public String toString() {
            return this.mValue;
        }
    }

    public static enum Status {
        ACCEPTED("accepted"),
        PENDING("pending"),
        REJECTED("rejected");

        private final String mValue;

        private Status(String value) {
            this.mValue = value;
        }

        public static Status fromString(String text) {
            if (!TextUtils.isEmpty((CharSequence)text)) {
                for (Status e : Status.values()) {
                    if (!text.equalsIgnoreCase(e.toString())) continue;
                    return e;
                }
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "No enum with text %s found", text));
        }

        public String toString() {
            return this.mValue;
        }
    }
}

