/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.models;

import com.box.androidsdk.content.models.BoxEntity;
import com.box.androidsdk.content.models.BoxGroup;
import com.box.androidsdk.content.models.BoxUser;
import com.box.androidsdk.content.utils.BoxDateFormat;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;

public abstract class BoxCollaborator
extends BoxEntity {
    private static final long serialVersionUID = 4995483369186543255L;
    public static final String FIELD_NAME = "name";
    public static final String FIELD_CREATED_AT = "created_at";
    public static final String FIELD_MODIFIED_AT = "modified_at";

    public BoxCollaborator() {
    }

    public BoxCollaborator(Map<String, Object> map) {
        super(map);
    }

    public String getName() {
        return (String)this.mProperties.get(FIELD_NAME);
    }

    public Date getCreatedAt() {
        return (Date)this.mProperties.get(FIELD_CREATED_AT);
    }

    public Date getModifiedAt() {
        return (Date)this.mProperties.get(FIELD_MODIFIED_AT);
    }

    @Override
    protected void parseJSONMember(JsonObject.Member member) {
        block5: {
            try {
                JsonValue value = member.getValue();
                if (member.getName().equals(FIELD_NAME)) {
                    this.mProperties.put(FIELD_NAME, value.asString());
                    return;
                }
                if (member.getName().equals(FIELD_CREATED_AT)) {
                    this.mProperties.put(FIELD_CREATED_AT, BoxDateFormat.parse(value.asString()));
                    return;
                }
                if (member.getName().equals(FIELD_MODIFIED_AT)) {
                    this.mProperties.put(FIELD_MODIFIED_AT, BoxDateFormat.parse(value.asString()));
                    return;
                }
            }
            catch (ParseException e) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)"A ParseException indicates a bug in the SDK.");
            }
        }
        super.parseJSONMember(member);
    }

    public static BoxCollaborator createCollaboratorFromJson(String json) {
        BoxEntity createdByEntity = new BoxEntity();
        createdByEntity.createFromJson(json);
        if (createdByEntity.getType().equals("user")) {
            BoxUser user = new BoxUser();
            user.createFromJson(json);
            return user;
        }
        if (createdByEntity.getType().equals("group")) {
            BoxGroup group = new BoxGroup();
            group.createFromJson(json);
            return group;
        }
        return null;
    }

    public static BoxCollaborator createCollaboratorFromJson(JsonObject json) {
        BoxEntity createdByEntity = new BoxEntity();
        createdByEntity.createFromJson(json);
        if (createdByEntity.getType().equals("user")) {
            BoxUser user = new BoxUser();
            user.createFromJson(json);
            return user;
        }
        if (createdByEntity.getType().equals("group")) {
            BoxGroup group = new BoxGroup();
            group.createFromJson(json);
            return group;
        }
        return null;
    }
}

