/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.models;

import com.box.androidsdk.content.models.BoxCollaborator;
import com.box.androidsdk.content.models.BoxEntity;
import com.box.androidsdk.content.models.BoxJsonObject;
import com.box.androidsdk.content.utils.BoxDateFormat;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.text.ParseException;
import java.util.Map;

public class BoxEnterpriseEvent
extends BoxJsonObject {
    private static final long serialVersionUID = -4732748896882484735L;
    public static final String TYPE = "event";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_EVENT_ID = "event_id";
    public static final String FIELD_CREATED_BY = "created_by";
    public static final String FIELD_EVENT_TYPE = "event_type";
    public static final String FIELD_SESSION_ID = "session_id";
    public static final String FIELD_IS_PACKAGE = "is_package";
    public static final String FIELD_SOURCE = "source";
    public static final String FIELD_CREATED_AT = "created_at";
    public static final String FIELD_RECORDED_AT = "recorded_at";
    public static final String FIELD_IP_ADDRESS = "ip_address";
    public static final String FIELD_ACCESSIBLE_BY = "accessible_by";
    public static final String FIELD_ADDITIONAL_DETAILS = "additional_details";

    @Override
    protected void parseJSONMember(JsonObject.Member member) {
        String memberName = member.getName();
        JsonValue value = member.getValue();
        if (memberName.equals(FIELD_ACCESSIBLE_BY)) {
            this.mProperties.put(FIELD_ACCESSIBLE_BY, BoxCollaborator.createEntityFromJson(value.asObject()));
            return;
        }
        if (memberName.equals(FIELD_ADDITIONAL_DETAILS)) {
            this.mProperties.put(FIELD_ADDITIONAL_DETAILS, value.toString());
            return;
        }
        if (memberName.equals(FIELD_IP_ADDRESS)) {
            this.mProperties.put(FIELD_IP_ADDRESS, value.asString());
            return;
        }
        if (memberName.equals(FIELD_TYPE)) {
            this.mProperties.put(FIELD_TYPE, value.asString());
            return;
        }
        if (memberName.equals(FIELD_EVENT_ID)) {
            this.mProperties.put(FIELD_EVENT_ID, value.asString());
            return;
        }
        if (memberName.equals(FIELD_CREATED_BY)) {
            this.mProperties.put(FIELD_CREATED_BY, BoxCollaborator.createCollaboratorFromJson(value.asObject()));
            return;
        }
        if (memberName.equals(FIELD_EVENT_TYPE)) {
            this.mProperties.put(FIELD_EVENT_TYPE, value.asString());
            return;
        }
        if (memberName.equals(FIELD_SESSION_ID)) {
            this.mProperties.put(FIELD_SESSION_ID, value.asString());
            return;
        }
        if (memberName.equals(FIELD_IS_PACKAGE)) {
            this.mProperties.put(FIELD_IS_PACKAGE, value.asBoolean());
            return;
        }
        if (memberName.equals(FIELD_SOURCE)) {
            this.mProperties.put(FIELD_SOURCE, BoxEntity.createEntityFromJson(value.asObject()));
            return;
        }
        if (memberName.equals(FIELD_CREATED_AT)) {
            try {
                this.mProperties.put(FIELD_CREATED_AT, BoxDateFormat.parse(value.asString()));
            }
            catch (ParseException e) {
                this.mProperties.put(FIELD_CREATED_AT, null);
            }
            return;
        }
        if (memberName.equals(FIELD_RECORDED_AT)) {
            try {
                this.mProperties.put(FIELD_RECORDED_AT, BoxDateFormat.parse(value.asString()));
            }
            catch (ParseException e) {
                this.mProperties.put(FIELD_RECORDED_AT, null);
            }
            return;
        }
        super.parseJSONMember(member);
    }

    public String getType() {
        return (String)this.mProperties.get(TYPE);
    }

    public String getEventId() {
        return (String)this.mProperties.get(FIELD_EVENT_ID);
    }

    public BoxCollaborator getCreatedBy() {
        return (BoxCollaborator)this.mProperties.get(FIELD_CREATED_BY);
    }

    public BoxCollaborator getAccessibleBy() {
        return (BoxCollaborator)this.mProperties.get(FIELD_ACCESSIBLE_BY);
    }

    public String getAdditionalDetails() {
        return (String)this.mProperties.get(FIELD_ADDITIONAL_DETAILS);
    }

    public String getIpAddress() {
        return (String)this.mProperties.get(FIELD_IP_ADDRESS);
    }

    public String getEventType() {
        return (String)this.mProperties.get(FIELD_EVENT_TYPE);
    }

    public String getSessionId() {
        return (String)this.mProperties.get(FIELD_SESSION_ID);
    }

    public Boolean getIsPackage() {
        return (Boolean)this.mProperties.get(FIELD_IS_PACKAGE);
    }

    public BoxEntity getSource() {
        return (BoxEntity)this.mProperties.get(FIELD_SOURCE);
    }

    public BoxEnterpriseEvent() {
    }

    public BoxEnterpriseEvent(Map<String, Object> map) {
        super(map);
    }

    public static enum Type {
        GROUP_ADD_USER,
        NEW_USER,
        GROUP_CREATION,
        GROUP_DELETION,
        DELETE_USER,
        GROUP_EDITED,
        EDIT_USER,
        GROUP_ADD_FOLDER,
        GROUP_REMOVE_USER,
        GROUP_REMOVE_FOLDER,
        ADMIN_LOGIN,
        ADD_DEVICE_ASSOCIATION,
        FAILED_LOGIN,
        LOGIN,
        USER_AUTHENTICATE_OAUTH2_TOKEN_REFRESH,
        REMOVE_DEVICE_ASSOCIATION,
        TERMS_OF_SERVICE_AGREE,
        TERMS_OF_SERVICE_REJECT,
        COPY,
        DELETE,
        DOWNLOAD,
        EDIT,
        LOCK,
        MOVE,
        PREVIEW,
        RENAME,
        STORAGE_EXPIRATION,
        UNDELETE,
        UNLOCK,
        UPLOAD,
        SHARE,
        ITEM_SHARED_UPDATE,
        UPDATE_SHARE_EXPIRATION,
        SHARE_EXPIRATION,
        UNSHARE,
        COLLABORATION_ACCEPT,
        COLLABORATION_ROLE_CHANGE,
        UPDATE_COLLABORATION_EXPIRATION,
        COLLABORATION_REMOVE,
        COLLABORATION_INVITE,
        COLLABORATION_EXPIRATION,
        ITEM_SYNC,
        ITEM_UNSYNC;

    }
}

