/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.models;

import android.text.TextUtils;
import com.box.androidsdk.content.models.BoxItem;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class BoxFile
extends BoxItem {
    private static final long serialVersionUID = -4732748896882484735L;
    public static final String TYPE = "file";
    public static final String FIELD_SHA1 = "sha1";
    public static final String FIELD_VERSION_NUMBER = "version_number";
    public static final String FIELD_EXTENSION = "extension";
    public static final String FIELD_IS_PACKAGE = "is_package";
    public static final String FIELD_COMMENT_COUNT = "comment_count";
    public static final String FIELD_SIZE = "size";
    public static final String FIELD_CONTENT_CREATED_AT = "content_created_at";
    public static final String FIELD_CONTENT_MODIFIED_AT = "content_modified_at";
    public static final String[] ALL_FIELDS = new String[]{"type", "id", "sequence_id", "etag", "sha1", "name", "created_at", "modified_at", "description", "size", "path_collection", "created_by", "modified_by", "trashed_at", "purged_at", "content_created_at", "content_modified_at", "owned_by", "shared_link", "parent", "item_status", "version_number", "comment_count", "permissions", "extension", "is_package"};

    public BoxFile() {
    }

    public BoxFile(Map<String, Object> map) {
        super(map);
    }

    public static BoxFile createFromId(String fileId) {
        LinkedHashMap<String, Object> fileMap = new LinkedHashMap<String, Object>();
        fileMap.put("id", fileId);
        fileMap.put("type", TYPE);
        return new BoxFile(fileMap);
    }

    public String getSha1() {
        return (String)this.mProperties.get(FIELD_SHA1);
    }

    public String getVersionNumber() {
        return (String)this.mProperties.get(FIELD_VERSION_NUMBER);
    }

    public EnumSet<Permission> getPermissions() {
        return (EnumSet)this.mProperties.get("permissions");
    }

    public String getExtension() {
        return (String)this.mProperties.get(FIELD_EXTENSION);
    }

    public Boolean getIsPackage() {
        return (Boolean)this.mProperties.get(FIELD_IS_PACKAGE);
    }

    @Override
    public Date getContentCreatedAt() {
        return super.getContentCreatedAt();
    }

    @Override
    public Long getSize() {
        return super.getSize();
    }

    @Override
    public Date getContentModifiedAt() {
        return super.getContentModifiedAt();
    }

    @Override
    public Long getCommentCount() {
        return super.getCommentCount();
    }

    @Override
    protected void parseJSONMember(JsonObject.Member member) {
        String memberName = member.getName();
        JsonValue value = member.getValue();
        if (memberName.equals(FIELD_SHA1)) {
            this.mProperties.put(FIELD_SHA1, value.asString());
            return;
        }
        if (memberName.equals(FIELD_VERSION_NUMBER)) {
            this.mProperties.put(FIELD_VERSION_NUMBER, value.asString());
            return;
        }
        if (memberName.equals("permissions")) {
            this.mProperties.put("permissions", this.parsePermissions(value.asObject()));
            return;
        }
        if (memberName.equals(FIELD_EXTENSION)) {
            this.mProperties.put(FIELD_EXTENSION, value.asString());
            return;
        }
        if (memberName.equals(FIELD_IS_PACKAGE)) {
            this.mProperties.put(FIELD_IS_PACKAGE, value.asBoolean());
            return;
        }
        super.parseJSONMember(member);
    }

    private EnumSet<Permission> parsePermissions(JsonObject jsonObject) {
        EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
        for (JsonObject.Member member : jsonObject) {
            JsonValue value = member.getValue();
            if (value.isNull() || !value.asBoolean()) continue;
            String memberName = member.getName();
            if (memberName.equals("can_download")) {
                permissions.add(Permission.CAN_DOWNLOAD);
                continue;
            }
            if (memberName.equals("can_upload")) {
                permissions.add(Permission.CAN_UPLOAD);
                continue;
            }
            if (memberName.equals("can_rename")) {
                permissions.add(Permission.CAN_RENAME);
                continue;
            }
            if (memberName.equals("can_delete")) {
                permissions.add(Permission.CAN_DELETE);
                continue;
            }
            if (memberName.equals("can_share")) {
                permissions.add(Permission.CAN_SHARE);
                continue;
            }
            if (memberName.equals("can_set_share_access")) {
                permissions.add(Permission.CAN_SET_SHARE_ACCESS);
                continue;
            }
            if (memberName.equals("can_preview")) {
                permissions.add(Permission.CAN_PREVIEW);
                continue;
            }
            if (!memberName.equals("can_comment")) continue;
            permissions.add(Permission.CAN_COMMENT);
        }
        return permissions;
    }

    public static enum Permission {
        CAN_DOWNLOAD("can_download"),
        CAN_UPLOAD("can_upload"),
        CAN_RENAME("can_rename"),
        CAN_DELETE("can_delete"),
        CAN_SHARE("can_share"),
        CAN_SET_SHARE_ACCESS("can_set_share_access"),
        CAN_PREVIEW("can_preview"),
        CAN_COMMENT("can_comment");

        private final String value;

        private Permission(String value) {
            this.value = value;
        }

        public static Permission fromString(String text) {
            if (!TextUtils.isEmpty((CharSequence)text)) {
                for (Permission a : Permission.values()) {
                    if (!text.equalsIgnoreCase(a.name())) continue;
                    return a;
                }
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "No enum with text %s found", text));
        }

        public String toString() {
            return this.value;
        }
    }
}

