/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.models;

import android.text.TextUtils;
import com.box.androidsdk.content.models.BoxCollaboration;
import com.box.androidsdk.content.models.BoxItem;
import com.box.androidsdk.content.models.BoxListItems;
import com.box.androidsdk.content.models.BoxSharedLink;
import com.box.androidsdk.content.models.BoxUploadEmail;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class BoxFolder
extends BoxItem {
    private static final long serialVersionUID = 8020073615785970254L;
    public static final String TYPE = "folder";
    public static final String FIELD_FOLDER_UPLOAD_EMAIL = "folder_upload_email";
    public static final String FIELD_HAS_COLLABORATIONS = "has_collaborations";
    public static final String FIELD_SYNC_STATE = "sync_state";
    public static final String FIELD_CAN_NON_OWNERS_INVITE = "can_non_owners_invite";
    public static final String FIELD_ITEM_COLLECTION = "item_collection";
    public static final String FIELD_IS_EXTERNALLY_OWNED = "is_externally_owned";
    public static final String FIELD_ALLOWED_INVITEE_ROLES = "allowed_invitee_roles";
    public static final String FIELD_SIZE = "size";
    public static final String FIELD_CONTENT_CREATED_AT = "content_created_at";
    public static final String FIELD_CONTENT_MODIFIED_AT = "content_modified_at";
    public static final String[] ALL_FIELDS = new String[]{"type", "id", "sequence_id", "etag", "name", "created_at", "modified_at", "description", "size", "path_collection", "created_by", "modified_by", "trashed_at", "purged_at", "content_created_at", "content_modified_at", "owned_by", "shared_link", "folder_upload_email", "parent", "item_status", "item_collection", "sync_state", "has_collaborations", "permissions", "can_non_owners_invite", "is_externally_owned", "allowed_shared_link_access_levels", "allowed_invitee_roles"};

    public BoxFolder() {
    }

    public BoxFolder(Map<String, Object> map) {
        super(map);
    }

    public static BoxFolder createFromId(String folderId) {
        LinkedHashMap<String, Object> folderMap = new LinkedHashMap<String, Object>();
        folderMap.put("id", folderId);
        folderMap.put("type", TYPE);
        return new BoxFolder(folderMap);
    }

    public BoxUploadEmail getUploadEmail() {
        return (BoxUploadEmail)this.mProperties.get(FIELD_FOLDER_UPLOAD_EMAIL);
    }

    public Boolean getHasCollaborations() {
        return (Boolean)this.mProperties.get(FIELD_HAS_COLLABORATIONS);
    }

    public SyncState getSyncState() {
        return (SyncState)((Object)this.mProperties.get(FIELD_SYNC_STATE));
    }

    public EnumSet<Permission> getPermissions() {
        return (EnumSet)this.mProperties.get("permissions");
    }

    public Boolean getCanNonOwnersInvite() {
        return (Boolean)this.mProperties.get(FIELD_CAN_NON_OWNERS_INVITE);
    }

    public BoxListItems getItemCollection() {
        return this.mProperties.containsKey(FIELD_ITEM_COLLECTION) ? (BoxListItems)this.mProperties.get(FIELD_ITEM_COLLECTION) : null;
    }

    public Boolean getIsExternallyOwned() {
        return (Boolean)this.mProperties.get(FIELD_IS_EXTERNALLY_OWNED);
    }

    @Override
    public ArrayList<BoxSharedLink.Access> getAllowedSharedLinkAccessLevels() {
        return (ArrayList)this.mProperties.get("allowed_shared_link_access_levels");
    }

    public ArrayList<BoxCollaboration.Role> getAllowedInviteeRoles() {
        return (ArrayList)this.mProperties.get(FIELD_ALLOWED_INVITEE_ROLES);
    }

    @Override
    public Date getContentCreatedAt() {
        return super.getContentCreatedAt();
    }

    @Override
    public Long getSize() {
        return super.getSize();
    }

    @Override
    public Date getContentModifiedAt() {
        return super.getContentModifiedAt();
    }

    @Override
    protected void parseJSONMember(JsonObject.Member member) {
        String memberName = member.getName();
        JsonValue value = member.getValue();
        if (memberName.equals(FIELD_FOLDER_UPLOAD_EMAIL)) {
            BoxUploadEmail uploadEmail = new BoxUploadEmail();
            uploadEmail.createFromJson(value.asObject());
            this.mProperties.put(FIELD_FOLDER_UPLOAD_EMAIL, uploadEmail);
            return;
        }
        if (memberName.equals(FIELD_HAS_COLLABORATIONS)) {
            this.mProperties.put(FIELD_HAS_COLLABORATIONS, value.asBoolean());
            return;
        }
        if (memberName.equals(FIELD_SYNC_STATE)) {
            this.mProperties.put(FIELD_SYNC_STATE, SyncState.fromString(value.asString()));
            return;
        }
        if (memberName.equals("permissions")) {
            this.mProperties.put("permissions", this.parsePermissions(value.asObject()));
            return;
        }
        if (memberName.equals(FIELD_CAN_NON_OWNERS_INVITE)) {
            this.mProperties.put(FIELD_CAN_NON_OWNERS_INVITE, value.asBoolean());
            return;
        }
        if (memberName.equals(FIELD_ITEM_COLLECTION)) {
            JsonObject jsonObject = value.asObject();
            BoxListItems collection = new BoxListItems();
            collection.createFromJson(jsonObject);
            this.mProperties.put(FIELD_ITEM_COLLECTION, collection);
            return;
        }
        if (memberName.equals(FIELD_IS_EXTERNALLY_OWNED)) {
            this.mProperties.put(FIELD_IS_EXTERNALLY_OWNED, value.asBoolean());
            return;
        }
        if (memberName.equals(FIELD_ALLOWED_INVITEE_ROLES)) {
            JsonArray rolesArr = value.asArray();
            ArrayList<BoxCollaboration.Role> allowedRoles = new ArrayList<BoxCollaboration.Role>();
            for (JsonValue val : rolesArr) {
                allowedRoles.add(BoxCollaboration.Role.fromString(val.asString()));
            }
            this.mProperties.put(FIELD_ALLOWED_INVITEE_ROLES, allowedRoles);
            return;
        }
        super.parseJSONMember(member);
    }

    private EnumSet<Permission> parsePermissions(JsonObject jsonObject) {
        EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
        for (JsonObject.Member member : jsonObject) {
            JsonValue value = member.getValue();
            if (value.isNull() || !value.asBoolean()) continue;
            String memberName = member.getName();
            if (memberName.equals("can_download")) {
                permissions.add(Permission.CAN_DOWNLOAD);
                continue;
            }
            if (memberName.equals("can_upload")) {
                permissions.add(Permission.CAN_UPLOAD);
                continue;
            }
            if (memberName.equals("can_rename")) {
                permissions.add(Permission.CAN_RENAME);
                continue;
            }
            if (memberName.equals("can_delete")) {
                permissions.add(Permission.CAN_DELETE);
                continue;
            }
            if (memberName.equals("can_share")) {
                permissions.add(Permission.CAN_SHARE);
                continue;
            }
            if (memberName.equals("can_invite_collaborator")) {
                permissions.add(Permission.CAN_INVITE_COLLABORATOR);
                continue;
            }
            if (!memberName.equals("can_set_share_access")) continue;
            permissions.add(Permission.CAN_SET_SHARE_ACCESS);
        }
        return permissions;
    }

    public static enum Permission {
        CAN_DOWNLOAD("can_download"),
        CAN_UPLOAD("can_upload"),
        CAN_RENAME("can_rename"),
        CAN_DELETE("can_delete"),
        CAN_SHARE("can_share"),
        CAN_INVITE_COLLABORATOR("can_invite_collaborator"),
        CAN_SET_SHARE_ACCESS("can_set_share_access");

        private final String mValue;

        private Permission(String value) {
            this.mValue = value;
        }

        public static Permission fromString(String text) {
            if (!TextUtils.isEmpty((CharSequence)text)) {
                for (Permission e : Permission.values()) {
                    if (!text.equalsIgnoreCase(e.toString())) continue;
                    return e;
                }
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "No enum with text %s found", text));
        }

        public String toString() {
            return this.mValue;
        }
    }

    public static enum SyncState {
        SYNCED("synced"),
        NOT_SYNCED("not_synced"),
        PARTIALLY_SYNCED("partially_synced");

        private final String mValue;

        private SyncState(String value) {
            this.mValue = value;
        }

        public static SyncState fromString(String text) {
            if (!TextUtils.isEmpty((CharSequence)text)) {
                for (SyncState e : SyncState.values()) {
                    if (!text.equalsIgnoreCase(e.toString())) continue;
                    return e;
                }
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "No enum with text %s found", text));
        }

        public String toString() {
            return this.mValue;
        }
    }
}

