/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.models;

import com.box.androidsdk.content.models.BoxBookmark;
import com.box.androidsdk.content.models.BoxEntity;
import com.box.androidsdk.content.models.BoxFile;
import com.box.androidsdk.content.models.BoxFolder;
import com.box.androidsdk.content.models.BoxList;
import com.box.androidsdk.content.models.BoxSharedLink;
import com.box.androidsdk.content.models.BoxUser;
import com.box.androidsdk.content.utils.BoxDateFormat;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class BoxItem
extends BoxEntity {
    private static final long serialVersionUID = 4876182952337609430L;
    public static final String FIELD_NAME = "name";
    public static final String FIELD_SEQUENCE_ID = "sequence_id";
    public static final String FIELD_ETAG = "etag";
    public static final String FIELD_CREATED_AT = "created_at";
    public static final String FIELD_MODIFIED_AT = "modified_at";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_PATH_COLLECTION = "path_collection";
    public static final String FIELD_CREATED_BY = "created_by";
    public static final String FIELD_MODIFIED_BY = "modified_by";
    public static final String FIELD_TRASHED_AT = "trashed_at";
    public static final String FIELD_PURGED_AT = "purged_at";
    public static final String FIELD_OWNED_BY = "owned_by";
    public static final String FIELD_SHARED_LINK = "shared_link";
    public static final String FIELD_PARENT = "parent";
    public static final String FIELD_ITEM_STATUS = "item_status";
    public static final String FIELD_PERMISSIONS = "permissions";
    public static final String FIELD_SYNCED = "synced";
    public static final String FIELD_ALLOWED_SHARED_LINK_ACCESS_LEVELS = "allowed_shared_link_access_levels";

    public BoxItem() {
    }

    public BoxItem(Map<String, Object> map) {
        super(map);
    }

    public String getEtag() {
        return (String)this.mProperties.get(FIELD_ETAG);
    }

    public String getName() {
        return (String)this.mProperties.get(FIELD_NAME);
    }

    public Date getCreatedAt() {
        return (Date)this.mProperties.get(FIELD_CREATED_AT);
    }

    public Date getModifiedAt() {
        return (Date)this.mProperties.get(FIELD_MODIFIED_AT);
    }

    public String getDescription() {
        return (String)this.mProperties.get(FIELD_DESCRIPTION);
    }

    public Long getSize() {
        return (Long)this.mProperties.get("size");
    }

    public BoxList<BoxFolder> getPathCollection() {
        return (BoxList)this.mProperties.get(FIELD_PATH_COLLECTION);
    }

    public BoxUser getCreatedBy() {
        return (BoxUser)this.mProperties.get(FIELD_CREATED_BY);
    }

    public BoxUser getModifiedBy() {
        return (BoxUser)this.mProperties.get(FIELD_MODIFIED_BY);
    }

    public Date getTrashedAt() {
        return (Date)this.mProperties.get(FIELD_TRASHED_AT);
    }

    public Date getPurgedAt() {
        return (Date)this.mProperties.get(FIELD_PURGED_AT);
    }

    protected Date getContentCreatedAt() {
        return (Date)this.mProperties.get("content_created_at");
    }

    protected Date getContentModifiedAt() {
        return (Date)this.mProperties.get("content_modified_at");
    }

    public BoxUser getOwnedBy() {
        return (BoxUser)this.mProperties.get(FIELD_OWNED_BY);
    }

    public BoxSharedLink getSharedLink() {
        return (BoxSharedLink)this.mProperties.get(FIELD_SHARED_LINK);
    }

    public String getSequenceID() {
        return (String)this.mProperties.get(FIELD_SEQUENCE_ID);
    }

    public ArrayList<BoxSharedLink.Access> getAllowedSharedLinkAccessLevels() {
        return (ArrayList)this.mProperties.get(FIELD_ALLOWED_SHARED_LINK_ACCESS_LEVELS);
    }

    public BoxFolder getParent() {
        return (BoxFolder)this.mProperties.get(FIELD_PARENT);
    }

    public String getItemStatus() {
        return (String)this.mProperties.get(FIELD_ITEM_STATUS);
    }

    public Boolean getIsSynced() {
        return (Boolean)this.mProperties.get(FIELD_SYNCED);
    }

    protected Long getCommentCount() {
        return (Long)this.mProperties.get("comment_count");
    }

    @Override
    protected void parseJSONMember(JsonObject.Member member) {
        block24: {
            try {
                JsonValue value = member.getValue();
                if (member.getName().equals(FIELD_NAME)) {
                    this.mProperties.put(FIELD_NAME, value.asString());
                    return;
                }
                if (member.getName().equals(FIELD_SEQUENCE_ID)) {
                    this.mProperties.put(FIELD_SEQUENCE_ID, value.asString());
                    return;
                }
                if (member.getName().equals(FIELD_ETAG)) {
                    this.mProperties.put(FIELD_ETAG, value.asString());
                    return;
                }
                if (member.getName().equals(FIELD_CREATED_AT)) {
                    this.mProperties.put(FIELD_CREATED_AT, BoxDateFormat.parse(value.asString()));
                    return;
                }
                if (member.getName().equals(FIELD_MODIFIED_AT)) {
                    this.mProperties.put(FIELD_MODIFIED_AT, BoxDateFormat.parse(value.asString()));
                    return;
                }
                if (member.getName().equals(FIELD_DESCRIPTION)) {
                    this.mProperties.put(FIELD_DESCRIPTION, value.asString());
                    return;
                }
                if (member.getName().equals("size")) {
                    this.mProperties.put("size", Long.valueOf(value.toString()));
                    return;
                }
                if (member.getName().equals(FIELD_TRASHED_AT)) {
                    this.mProperties.put(FIELD_TRASHED_AT, BoxDateFormat.parse(value.asString()));
                    return;
                }
                if (member.getName().equals(FIELD_PURGED_AT)) {
                    this.mProperties.put(FIELD_PURGED_AT, BoxDateFormat.parse(value.asString()));
                    return;
                }
                if (member.getName().equals("content_created_at")) {
                    this.mProperties.put("content_created_at", BoxDateFormat.parse(value.asString()));
                    return;
                }
                if (member.getName().equals("content_modified_at")) {
                    this.mProperties.put("content_modified_at", BoxDateFormat.parse(value.asString()));
                    return;
                }
                if (member.getName().equals(FIELD_PATH_COLLECTION)) {
                    JsonObject jsonObject = value.asObject();
                    BoxList collection = new BoxList();
                    collection.createFromJson(jsonObject);
                    this.mProperties.put(FIELD_PATH_COLLECTION, collection);
                    return;
                }
                if (member.getName().equals(FIELD_CREATED_BY)) {
                    this.mProperties.put(FIELD_CREATED_BY, this.parseUserInfo(value.asObject()));
                    return;
                }
                if (member.getName().equals(FIELD_MODIFIED_BY)) {
                    this.mProperties.put(FIELD_MODIFIED_BY, this.parseUserInfo(value.asObject()));
                    return;
                }
                if (member.getName().equals(FIELD_OWNED_BY)) {
                    this.mProperties.put(FIELD_OWNED_BY, this.parseUserInfo(value.asObject()));
                    return;
                }
                if (member.getName().equals(FIELD_SHARED_LINK)) {
                    BoxSharedLink sl = new BoxSharedLink();
                    sl.createFromJson(value.asObject());
                    this.mProperties.put(FIELD_SHARED_LINK, sl);
                    return;
                }
                if (member.getName().equals(FIELD_PARENT)) {
                    BoxFolder folder = new BoxFolder();
                    folder.createFromJson(value.asObject());
                    this.mProperties.put(FIELD_PARENT, folder);
                    return;
                }
                if (member.getName().equals(FIELD_ITEM_STATUS)) {
                    this.mProperties.put(FIELD_ITEM_STATUS, value.asString());
                    return;
                }
                if (member.getName().equals(FIELD_SYNCED)) {
                    this.mProperties.put(FIELD_SYNCED, value.asBoolean());
                    return;
                }
                if (member.getName().equals("comment_count")) {
                    this.mProperties.put("comment_count", value.asLong());
                    return;
                }
                if (member.getName().equals(FIELD_ALLOWED_SHARED_LINK_ACCESS_LEVELS)) {
                    JsonArray accessArr = value.asArray();
                    ArrayList<BoxSharedLink.Access> accessLevels = new ArrayList<BoxSharedLink.Access>();
                    for (JsonValue val : accessArr) {
                        accessLevels.add(BoxSharedLink.Access.fromString(val.asString()));
                    }
                    this.mProperties.put(FIELD_ALLOWED_SHARED_LINK_ACCESS_LEVELS, accessLevels);
                    return;
                }
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block24;
                throw new AssertionError((Object)"A ParseException indicates a bug in the SDK.");
            }
        }
        super.parseJSONMember(member);
    }

    private List<BoxFolder> parsePathCollection(JsonObject jsonObject) {
        int count = jsonObject.get("total_count").asInt();
        ArrayList<BoxFolder> pathCollection = new ArrayList<BoxFolder>(count);
        JsonArray entries = jsonObject.get("entries").asArray();
        for (JsonValue value : entries) {
            JsonObject entry = value.asObject();
            BoxFolder folder = new BoxFolder();
            folder.createFromJson(entry);
            pathCollection.add(folder);
        }
        return pathCollection;
    }

    private BoxUser parseUserInfo(JsonObject jsonObject) {
        BoxUser user = new BoxUser();
        user.createFromJson(jsonObject);
        return user;
    }

    private List<String> parseTags(JsonArray jsonArray) {
        ArrayList<String> tags = new ArrayList<String>(jsonArray.size());
        for (JsonValue value : jsonArray) {
            tags.add(value.asString());
        }
        return tags;
    }

    @Override
    protected JsonValue parseJsonObject(Map.Entry<String, Object> entry) {
        return super.parseJsonObject(entry);
    }

    public static BoxItem createBoxItemFromJson(String json) {
        BoxEntity createdByEntity = new BoxEntity();
        createdByEntity.createFromJson(json);
        if (createdByEntity.getType().equals("file")) {
            BoxFile file = new BoxFile();
            file.createFromJson(json);
            return file;
        }
        if (createdByEntity.getType().equals("web_link")) {
            BoxBookmark bookmark = new BoxBookmark();
            bookmark.createFromJson(json);
            return bookmark;
        }
        if (createdByEntity.getType().equals("folder")) {
            BoxFolder folder = new BoxFolder();
            folder.createFromJson(json);
            return folder;
        }
        return null;
    }

    public static BoxItem createBoxItemFromJson(JsonObject json) {
        BoxEntity createdByEntity = new BoxEntity();
        createdByEntity.createFromJson(json);
        if (createdByEntity.getType().equals("file")) {
            BoxFile file = new BoxFile();
            file.createFromJson(json);
            return file;
        }
        if (createdByEntity.getType().equals("web_link")) {
            BoxBookmark bookmark = new BoxBookmark();
            bookmark.createFromJson(json);
            return bookmark;
        }
        if (createdByEntity.getType().equals("folder")) {
            BoxFolder folder = new BoxFolder();
            folder.createFromJson(json);
            return folder;
        }
        return null;
    }
}

