/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.models;

import com.box.androidsdk.content.models.BoxEntity;
import com.box.androidsdk.content.models.BoxObject;
import com.box.androidsdk.content.utils.BoxDateFormat;
import com.box.androidsdk.content.utils.SdkUtils;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class BoxJsonObject
extends BoxObject
implements Serializable {
    private static final long serialVersionUID = 7174936367401884790L;
    protected final LinkedHashMap<String, Object> mProperties;

    public BoxJsonObject() {
        this.mProperties = new LinkedHashMap();
    }

    public BoxJsonObject(Map<String, Object> map) {
        this.mProperties = new LinkedHashMap<String, Object>(map);
    }

    public void createFromJson(String json) {
        this.createFromJson(JsonObject.readFrom((String)json));
    }

    public void createFromJson(JsonObject object) {
        for (JsonObject.Member member : object) {
            if (member.getValue().isNull()) {
                this.parseNullJsonMember(member);
                continue;
            }
            this.parseJSONMember(member);
        }
    }

    public void parseNullJsonMember(JsonObject.Member member) {
        if (!SdkUtils.isEmptyString(member.getName())) {
            this.mProperties.put(member.getName(), null);
        }
    }

    protected void parseJSONMember(JsonObject.Member member) {
        String memberName = member.getName();
        JsonValue value = member.getValue();
        if (!(this instanceof BoxEntity)) {
            System.out.println("unhandled json member '" + memberName + "' xxx  " + value + " current object " + this.getClass());
        }
        try {
            this.mProperties.put(memberName, value.asString());
        }
        catch (UnsupportedOperationException e) {
            this.mProperties.put(memberName, value.toString());
        }
    }

    public String toJson() {
        return this.toJsonObject().toString();
    }

    protected JsonObject toJsonObject() {
        JsonObject jsonObj = new JsonObject();
        for (Map.Entry<String, Object> entry : this.mProperties.entrySet()) {
            JsonValue value = this.parseJsonObject(entry);
            jsonObj.add(entry.getKey(), value);
        }
        return jsonObj;
    }

    protected JsonValue parseJsonObject(Map.Entry<String, Object> entry) {
        Object obj = entry.getValue();
        return obj instanceof BoxJsonObject ? ((BoxJsonObject)obj).toJsonObject() : (obj instanceof Integer ? JsonValue.valueOf((int)((Integer)obj)) : (obj instanceof Long ? JsonValue.valueOf((long)((Long)obj)) : (obj instanceof Float ? JsonValue.valueOf((float)((Float)obj).floatValue()) : (obj instanceof Double ? JsonValue.valueOf((double)((Double)obj)) : (obj instanceof Boolean ? JsonValue.valueOf((boolean)((Boolean)obj)) : (obj instanceof Enum ? JsonValue.valueOf((String)obj.toString()) : (obj instanceof Date ? JsonValue.valueOf((String)BoxDateFormat.format((Date)obj)) : (obj instanceof String ? JsonValue.valueOf((String)((String)obj)) : (obj instanceof Collection ? this.parseJsonArray((Collection)obj) : JsonValue.valueOf(null))))))))));
    }

    private JsonArray parseJsonArray(Collection collection) {
        JsonArray arr = new JsonArray();
        for (Object o : collection) {
            arr.add(JsonValue.valueOf((String)o.toString()));
        }
        return arr;
    }

    public HashMap<String, Object> getPropertiesAsHashMap() {
        return SdkUtils.cloneSerializable(this.mProperties);
    }
}

