/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.models;

import com.box.androidsdk.content.models.BoxEntity;
import com.box.androidsdk.content.models.BoxJsonObject;
import com.box.androidsdk.content.models.BoxOrder;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BoxList<E extends BoxJsonObject>
extends BoxJsonObject
implements Collection<E> {
    private static final long serialVersionUID = 8036181424029520417L;
    protected final Collection<E> collection = new ArrayList();
    public static final String FIELD_ORDER = "order";
    public static final String FIELD_TOTAL_COUNT = "total_count";
    public static final String FIELD_ENTRIES = "entries";
    public static final String FIELD_OFFSET = "offset";
    public static final String FIELD_LIMIT = "limit";

    public BoxList() {
    }

    public BoxList(Map<String, Object> map) {
        super(map);
    }

    public Long offset() {
        return (Long)this.mProperties.get(FIELD_OFFSET);
    }

    public Long limit() {
        return (Long)this.mProperties.get(FIELD_LIMIT);
    }

    public Long fullSize() {
        return (Long)this.mProperties.get(FIELD_TOTAL_COUNT);
    }

    @Override
    protected void parseJSONMember(JsonObject.Member member) {
        String memberName = member.getName();
        JsonValue value = member.getValue();
        if (memberName.equals(FIELD_ORDER)) {
            this.mProperties.put(FIELD_ORDER, this.parseOrder(value));
            return;
        }
        if (memberName.equals(FIELD_TOTAL_COUNT)) {
            this.mProperties.put(FIELD_TOTAL_COUNT, value.asLong());
            return;
        }
        if (memberName.equals(FIELD_OFFSET)) {
            this.mProperties.put(FIELD_OFFSET, value.asLong());
            return;
        }
        if (memberName.equals(FIELD_LIMIT)) {
            this.mProperties.put(FIELD_LIMIT, value.asLong());
            return;
        }
        if (memberName.equals(FIELD_ENTRIES)) {
            JsonArray entries = value.asArray();
            for (JsonValue entry : entries) {
                JsonObject obj = entry.asObject();
                this.collection.add(BoxEntity.createEntityFromJson(obj));
            }
            this.mProperties.put(FIELD_ENTRIES, this.collection);
            return;
        }
        super.parseJSONMember(member);
    }

    private ArrayList<BoxOrder> parseOrder(JsonValue jsonObject) {
        JsonArray entries = jsonObject.asArray();
        ArrayList<BoxOrder> orders = new ArrayList<BoxOrder>(entries.size());
        for (JsonValue entry : entries) {
            BoxOrder order = new BoxOrder();
            order.createFromJson(entry.asObject());
            orders.add(order);
        }
        return orders;
    }

    @Override
    protected JsonValue parseJsonObject(Map.Entry<String, Object> entry) {
        if (entry.getKey().equals(FIELD_ENTRIES)) {
            JsonArray jsonArr = new JsonArray();
            Collection collection = (Collection)entry.getValue();
            for (BoxJsonObject obj : collection) {
                jsonArr.add((JsonValue)obj.toJsonObject());
            }
            return jsonArr;
        }
        return super.parseJsonObject(entry);
    }

    @Override
    public boolean add(E e) {
        return this.collection.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.collection.addAll(c);
    }

    @Override
    public void clear() {
        this.collection.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.collection.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.collection.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.collection.equals(o);
    }

    @Override
    public int hashCode() {
        return this.collection.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.collection.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.collection.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.collection.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.collection.retainAll(c);
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public Object[] toArray() {
        return this.collection.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.collection.toArray(a);
    }

    public E get(int index) {
        if (this.collection instanceof List) {
            return (E)((BoxJsonObject)((List)this.collection).get(index));
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        Iterator<E> iterator = this.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            if (index == i) {
                return (E)((BoxJsonObject)iterator.next());
            }
            iterator.next();
        }
        throw new IndexOutOfBoundsException();
    }

    public ArrayList<BoxOrder> getSortOrders() {
        return (ArrayList)this.mProperties.get(FIELD_ORDER);
    }
}

