/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.models;

import com.box.androidsdk.content.models.BoxEnterpriseEvent;
import com.box.androidsdk.content.models.BoxEvent;
import com.box.androidsdk.content.models.BoxList;
import com.box.androidsdk.content.utils.IStreamPosition;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Collection;
import java.util.HashSet;

public class BoxListEnterpriseEvents
extends BoxList<BoxEnterpriseEvent>
implements IStreamPosition {
    private static final long serialVersionUID = 940295540206254689L;
    public static final String FIELD_CHUNK_SIZE = "chunk_size";
    public static final String FIELD_NEXT_STREAM_POSITION = "next_stream_position";
    private boolean mFilterDuplicates = true;
    private final HashSet<String> mEventIds = new HashSet();

    @Override
    protected void parseJSONMember(JsonObject.Member member) {
        String memberName = member.getName();
        JsonValue value = member.getValue();
        if (memberName.equals(FIELD_NEXT_STREAM_POSITION)) {
            this.mProperties.put(FIELD_NEXT_STREAM_POSITION, value.asString());
            return;
        }
        if (memberName.equals(FIELD_CHUNK_SIZE)) {
            this.mProperties.put(FIELD_CHUNK_SIZE, value.asLong());
            return;
        }
        if (memberName.equals("entries")) {
            JsonArray entries = value.asArray();
            for (JsonValue entry : entries) {
                BoxEnterpriseEvent event = new BoxEnterpriseEvent();
                JsonObject obj = entry.asObject();
                event.createFromJson(obj);
                this.add(event);
            }
            this.mProperties.put("entries", this.collection);
            return;
        }
        super.parseJSONMember(member);
    }

    @Override
    public boolean add(BoxEnterpriseEvent boxEnterpriseEvent) {
        if (this.mFilterDuplicates && this.mEventIds.contains(boxEnterpriseEvent.getEventId())) {
            return false;
        }
        this.mEventIds.add(boxEnterpriseEvent.getEventId());
        return super.add(boxEnterpriseEvent);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof BoxEvent) {
            this.mEventIds.remove(((BoxEvent)o).getEventId());
        }
        return super.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            if (!(o instanceof BoxEvent)) continue;
            this.mEventIds.remove(((BoxEvent)o).getEventId());
        }
        return super.removeAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends BoxEnterpriseEvent> c) {
        boolean addSuccessful = true;
        for (BoxEnterpriseEvent boxEnterpriseEvent : c) {
            addSuccessful &= this.add(boxEnterpriseEvent);
        }
        return addSuccessful;
    }

    @Override
    public void clear() {
        this.mEventIds.clear();
        super.clear();
    }

    public Long getChunkSize() {
        return (Long)this.mProperties.get(FIELD_CHUNK_SIZE);
    }

    @Override
    public Long getNextStreamPosition() {
        String longValue = (String)this.mProperties.get(FIELD_NEXT_STREAM_POSITION);
        return Long.parseLong(longValue.replace("\"", ""));
    }

    public void setFilterDuplicates(boolean filterDuplicates) {
        this.mFilterDuplicates = filterDuplicates;
    }
}

