/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.models;

import com.box.androidsdk.content.models.BoxEvent;
import com.box.androidsdk.content.models.BoxList;
import com.box.androidsdk.content.utils.IStreamPosition;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Collection;
import java.util.HashSet;

public class BoxListEvents
extends BoxList<BoxEvent>
implements IStreamPosition {
    private static final long serialVersionUID = 2397451459829964208L;
    public static final String FIELD_CHUNK_SIZE = "chunk_size";
    public static final String FIELD_NEXT_STREAM_POSITION = "next_stream_position";
    private boolean mFilterDuplicates = true;
    private final HashSet<String> mEventIds = new HashSet();

    @Override
    protected void parseJSONMember(JsonObject.Member member) {
        String memberName = member.getName();
        JsonValue value = member.getValue();
        if (memberName.equals(FIELD_NEXT_STREAM_POSITION)) {
            this.mProperties.put(FIELD_NEXT_STREAM_POSITION, value.asLong());
            return;
        }
        if (memberName.equals(FIELD_CHUNK_SIZE)) {
            this.mProperties.put(FIELD_CHUNK_SIZE, value.asLong());
            return;
        }
        if (memberName.equals("entries")) {
            JsonArray entries = value.asArray();
            for (JsonValue entry : entries) {
                BoxEvent event = new BoxEvent();
                JsonObject obj = entry.asObject();
                event.createFromJson(obj);
                this.add(event);
            }
            this.mProperties.put("entries", this.collection);
            return;
        }
        super.parseJSONMember(member);
    }

    @Override
    public boolean add(BoxEvent boxEvent) {
        if (this.mFilterDuplicates && this.mEventIds.contains(boxEvent.getEventId())) {
            return false;
        }
        this.mEventIds.add(boxEvent.getEventId());
        return super.add(boxEvent);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof BoxEvent) {
            this.mEventIds.remove(((BoxEvent)o).getEventId());
        }
        return super.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            if (!(o instanceof BoxEvent)) continue;
            this.mEventIds.remove(((BoxEvent)o).getEventId());
        }
        return super.removeAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends BoxEvent> c) {
        boolean addSuccessful = true;
        for (BoxEvent boxEvent : c) {
            addSuccessful &= this.add(boxEvent);
        }
        return addSuccessful;
    }

    @Override
    public void clear() {
        this.mEventIds.clear();
        super.clear();
    }

    public Long getChunkSize() {
        return (Long)this.mProperties.get(FIELD_CHUNK_SIZE);
    }

    @Override
    public Long getNextStreamPosition() {
        return (Long)this.mProperties.get(FIELD_NEXT_STREAM_POSITION);
    }

    public void setFilterDuplicates(boolean filterDuplicates) {
        this.mFilterDuplicates = filterDuplicates;
    }
}

