/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.models;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;
import com.box.androidsdk.content.BoxConfig;
import com.box.androidsdk.content.BoxException;
import com.box.androidsdk.content.BoxFutureTask;
import com.box.androidsdk.content.auth.BoxAuthentication;
import com.box.androidsdk.content.models.BoxObject;
import com.box.androidsdk.content.models.BoxSharedLinkSession;
import com.box.androidsdk.content.models.BoxUser;
import com.box.androidsdk.content.requests.BoxRequest;
import com.box.androidsdk.content.utils.SdkUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BoxSession
extends BoxObject
implements BoxAuthentication.AuthListener {
    private static final ThreadPoolExecutor AUTH_CREATION_EXECUTOR = SdkUtils.createDefaultThreadPoolExecutor(1, 20, 3600L, TimeUnit.SECONDS);
    private String mUserAgent = "com.box.sdk.android";
    private Context applicationContext;
    private BoxAuthentication.AuthListener sessionAuthListener;
    private String mUserId;
    protected String mClientId;
    protected String mClientSecret;
    protected String mClientRedirectUrl;
    protected BoxAuthentication.BoxAuthenticationInfo mAuthInfo;

    public BoxSession(Context context) {
        this(context, BoxSession.getBestStoredUserId(context));
    }

    private static String getBestStoredUserId(Context context) {
        String lastAuthenticatedUserId = BoxAuthentication.getInstance().getLastAuthenticatedUserId(context);
        Map<String, BoxAuthentication.BoxAuthenticationInfo> authInfoMap = BoxAuthentication.getInstance().getStoredAuthInfo(context);
        if (authInfoMap != null) {
            Iterator<String> i$;
            if (!SdkUtils.isEmptyString(lastAuthenticatedUserId) && authInfoMap.get(lastAuthenticatedUserId) != null) {
                return lastAuthenticatedUserId;
            }
            if (authInfoMap.size() == 1 && (i$ = authInfoMap.keySet().iterator()).hasNext()) {
                String authUserId = i$.next();
                return authUserId;
            }
        }
        return null;
    }

    public BoxSession(Context context, String userId) {
        this(context, userId, BoxConfig.CLIENT_ID, BoxConfig.CLIENT_SECRET, BoxConfig.REDIRECT_URL);
    }

    public BoxSession(Context context, String userId, String clientId, String clientSecret, String redirectUrl) {
        this.mClientId = clientId;
        this.mClientSecret = clientSecret;
        this.mClientRedirectUrl = redirectUrl;
        if (SdkUtils.isEmptyString(this.mClientId) || SdkUtils.isEmptyString(this.mClientSecret)) {
            throw new RuntimeException("Session must have a valid client id and client secret specified.");
        }
        this.applicationContext = context;
        if (!SdkUtils.isEmptyString(userId)) {
            this.mAuthInfo = BoxAuthentication.getInstance().getAuthInfo(userId, context);
            this.mUserId = userId;
        }
        if (this.mAuthInfo == null) {
            this.mUserId = userId;
            this.mAuthInfo = new BoxAuthentication.BoxAuthenticationInfo();
        }
        this.mAuthInfo.setClientId(this.mClientId);
        this.setupSession();
    }

    protected BoxSession(BoxSession session) {
        this.applicationContext = session.applicationContext;
        this.mAuthInfo = session.getAuthInfo();
        this.setupSession();
    }

    public Context getApplicationContext() {
        return this.applicationContext;
    }

    public void setSessionAuthListener(BoxAuthentication.AuthListener listener) {
        this.sessionAuthListener = listener;
    }

    protected void setupSession() {
        boolean isDebug = false;
        try {
            if (this.applicationContext != null && this.applicationContext.getPackageManager() != null) {
                PackageInfo info = this.applicationContext.getPackageManager().getPackageInfo(this.applicationContext.getPackageName(), 0);
                isDebug = (info.applicationInfo.flags & 2) != 0;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        BoxConfig.IS_DEBUG = isDebug;
        BoxAuthentication.getInstance().addListener(this);
    }

    public BoxUser getUser() {
        return this.mAuthInfo.getUser();
    }

    public String getUserId() {
        return this.mUserId;
    }

    protected void setUserId(String userId) {
        this.mUserId = userId;
    }

    public BoxAuthentication.BoxAuthenticationInfo getAuthInfo() {
        return this.mAuthInfo;
    }

    public String getUserAgent() {
        return this.mUserAgent;
    }

    public BoxFutureTask<BoxSession> authenticate() {
        return this.authenticate(false);
    }

    protected BoxFutureTask<BoxSession> authenticateUsingBoxApp() {
        return this.authenticate(true);
    }

    protected BoxFutureTask<BoxSession> authenticate(boolean viaBoxApp) {
        BoxSessionAuthCreationRequest req = new BoxSessionAuthCreationRequest(this, viaBoxApp);
        BoxFutureTask<BoxSession> task = req.toTask();
        AUTH_CREATION_EXECUTOR.submit(task);
        return task;
    }

    public BoxFutureTask<BoxSession> logout() {
        BoxFutureTask<BoxSession> task = new BoxSessionLogoutRequest(this).toTask();
        AUTH_CREATION_EXECUTOR.submit(task);
        return task;
    }

    public BoxFutureTask<BoxSession> refresh() {
        BoxFutureTask<BoxSession> task = new BoxSessionRefreshRequest(this).toTask();
        AUTH_CREATION_EXECUTOR.submit(task);
        return task;
    }

    public BoxSharedLinkSession getSharedLinkSession(String sharedLinkUri) {
        return new BoxSharedLinkSession(sharedLinkUri, this);
    }

    @Override
    public void onRefreshed(BoxAuthentication.BoxAuthenticationInfo info) {
        if (this.sameUser(info)) {
            BoxAuthentication.BoxAuthenticationInfo.cloneInfo(this.mAuthInfo, info);
            if (this.sessionAuthListener != null) {
                this.sessionAuthListener.onRefreshed(info);
            }
        }
    }

    @Override
    public void onAuthCreated(BoxAuthentication.BoxAuthenticationInfo info) {
        if (this.sameUser(info)) {
            BoxAuthentication.BoxAuthenticationInfo.cloneInfo(this.mAuthInfo, info);
            if (this.sessionAuthListener != null) {
                this.sessionAuthListener.onAuthCreated(info);
            }
        }
    }

    @Override
    public void onAuthFailure(BoxAuthentication.BoxAuthenticationInfo info, Exception ex) {
        if ((this.sameUser(info) || info == null && this.getUserId() == null) && this.sessionAuthListener != null) {
            this.sessionAuthListener.onAuthFailure(info, ex);
        }
    }

    @Override
    public void onLoggedOut(BoxAuthentication.BoxAuthenticationInfo info, Exception ex) {
        if (this.sameUser(info)) {
            if (ex instanceof BoxAuthentication.NonDefaultClientLogoutException) {
                this.logout();
            } else if (this.sessionAuthListener != null) {
                this.sessionAuthListener.onLoggedOut(info, ex);
            }
        }
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getClientSecret() {
        return this.mClientSecret;
    }

    public String getRedirectUrl() {
        return this.mClientRedirectUrl;
    }

    private boolean sameUser(BoxAuthentication.BoxAuthenticationInfo info) {
        return info != null && info.getUser() != null && this.getUserId() != null && this.getUserId().equals(info.getUser().getId());
    }

    private static class BoxSessionAuthCreationRequest
    extends BoxRequest<BoxSession, BoxSessionAuthCreationRequest>
    implements BoxAuthentication.AuthListener {
        private final BoxSession mSession;
        private CountDownLatch authLatch;
        private final boolean viaBoxApp;

        public BoxSessionAuthCreationRequest(BoxSession session, boolean viaBoxApp) {
            super(null, " ", null);
            this.mSession = session;
            this.viaBoxApp = viaBoxApp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BoxSession send() {
            BoxSession boxSession = this.mSession;
            synchronized (boxSession) {
                if (this.mSession.getUser() == null) {
                    BoxAuthentication.getInstance().addListener(this);
                    this.launchAuthUI(this.viaBoxApp);
                } else {
                    BoxAuthentication.BoxAuthenticationInfo info = BoxAuthentication.getInstance().getAuthInfo(this.mSession.getUserId(), this.mSession.getApplicationContext());
                    if (info != null) {
                        BoxAuthentication.BoxAuthenticationInfo.cloneInfo(this.mSession.mAuthInfo, info);
                    } else {
                        this.mSession.mAuthInfo.setUser(null);
                        this.launchAuthUI(this.viaBoxApp);
                    }
                }
                return this.mSession;
            }
        }

        private void launchAuthUI(final boolean viaBoxApp) {
            this.authLatch = new CountDownLatch(1);
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (!viaBoxApp) {
                        BoxAuthentication.getInstance().startAuthenticationUI(BoxSessionAuthCreationRequest.this.mSession);
                    }
                }
            });
            try {
                this.authLatch.await();
            }
            catch (InterruptedException e) {
                this.authLatch.countDown();
            }
        }

        @Override
        public void onRefreshed(BoxAuthentication.BoxAuthenticationInfo info) {
        }

        @Override
        public void onAuthCreated(BoxAuthentication.BoxAuthenticationInfo info) {
            BoxAuthentication.BoxAuthenticationInfo.cloneInfo(this.mSession.mAuthInfo, info);
            this.mSession.setUserId(info.getUser().getId());
            this.mSession.onAuthCreated(info);
            this.authLatch.countDown();
        }

        @Override
        public void onAuthFailure(BoxAuthentication.BoxAuthenticationInfo info, Exception ex) {
            this.authLatch.countDown();
        }

        @Override
        public void onLoggedOut(BoxAuthentication.BoxAuthenticationInfo info, Exception ex) {
        }
    }

    private static class BoxSessionRefreshRequest
    extends BoxRequest<BoxSession, BoxSessionRefreshRequest> {
        private BoxSession mSession;

        public BoxSessionRefreshRequest(BoxSession session) {
            super(null, " ", null);
            this.mSession = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BoxSession send() throws BoxException {
            BoxSession boxSession = this.mSession;
            synchronized (boxSession) {
                if (this.mSession.getUser() != null) {
                    BoxAuthentication.getInstance().refresh(this.mSession);
                    BoxAuthentication.BoxAuthenticationInfo.cloneInfo(this.mSession.mAuthInfo, BoxAuthentication.getInstance().getAuthInfo(this.mSession.getUserId(), this.mSession.getApplicationContext()));
                }
            }
            return this.mSession;
        }
    }

    private static class BoxSessionLogoutRequest
    extends BoxRequest<BoxSession, BoxSessionLogoutRequest> {
        private BoxSession mSession;

        public BoxSessionLogoutRequest(BoxSession session) {
            super(null, " ", null);
            this.mSession = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BoxSession send() throws BoxException {
            BoxSession boxSession = this.mSession;
            synchronized (boxSession) {
                if (this.mSession.getUser() != null) {
                    BoxAuthentication.getInstance().logout(this.mSession);
                    this.mSession.getAuthInfo().wipeOutAuth();
                }
            }
            return this.mSession;
        }
    }
}

