/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.models;

import android.text.TextUtils;
import com.box.androidsdk.content.models.BoxJsonObject;
import com.box.androidsdk.content.utils.BoxDateFormat;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class BoxSharedLink
extends BoxJsonObject {
    private static final long serialVersionUID = -4595593930118314932L;
    public static final String FIELD_URL = "url";
    public static final String FIELD_DOWNLOAD_URL = "download_url";
    public static final String FIELD_VANITY_URL = "vanity_url";
    public static final String FIELD_IS_PASSWORD_ENABLED = "is_password_enabled";
    public static final String FIELD_UNSHARED_AT = "unshared_at";
    public static final String FIELD_DOWNLOAD_COUNT = "download_count";
    public static final String FIELD_PREVIEW_COUNT = "preview_count";
    public static final String FIELD_ACCESS = "access";
    public static final String FIELD_PERMISSIONS = "permissions";
    public static final String FIELD_EFFECTIVE_ACCESS = "effective_access";
    public static final String FIELD_PASSWORD = "password";

    public BoxSharedLink() {
    }

    public BoxSharedLink(Map<String, Object> map) {
        super(map);
    }

    public String getURL() {
        return (String)this.mProperties.get(FIELD_URL);
    }

    public String getDownloadURL() {
        return (String)this.mProperties.get(FIELD_DOWNLOAD_URL);
    }

    public String getVanityURL() {
        return (String)this.mProperties.get(FIELD_VANITY_URL);
    }

    public Boolean getIsPasswordEnabled() {
        return (Boolean)this.mProperties.get(FIELD_IS_PASSWORD_ENABLED);
    }

    public Date getUnsharedDate() {
        return (Date)this.mProperties.get(FIELD_UNSHARED_AT);
    }

    public Long getDownloadCount() {
        return (Long)this.mProperties.get(FIELD_DOWNLOAD_COUNT);
    }

    public Long getPreviewCount() {
        return (Long)this.mProperties.get(FIELD_PREVIEW_COUNT);
    }

    public Access getAccess() {
        return (Access)((Object)this.mProperties.get(FIELD_ACCESS));
    }

    public String getPassword() {
        return (String)this.mProperties.get(FIELD_PASSWORD);
    }

    public Access getEffectiveAccess() {
        return (Access)((Object)this.mProperties.get(FIELD_EFFECTIVE_ACCESS));
    }

    public Permissions getPermissions() {
        return (Permissions)this.mProperties.get(FIELD_PERMISSIONS);
    }

    @Override
    protected void parseJSONMember(JsonObject.Member member) {
        block12: {
            JsonValue value = member.getValue();
            try {
                if (member.getName().equals(FIELD_URL)) {
                    this.mProperties.put(FIELD_URL, value.asString());
                    return;
                }
                if (member.getName().equals(FIELD_DOWNLOAD_URL)) {
                    this.mProperties.put(FIELD_DOWNLOAD_URL, value.asString());
                    return;
                }
                if (member.getName().equals(FIELD_VANITY_URL)) {
                    this.mProperties.put(FIELD_VANITY_URL, value.asString());
                    return;
                }
                if (member.getName().equals(FIELD_IS_PASSWORD_ENABLED)) {
                    this.mProperties.put(FIELD_IS_PASSWORD_ENABLED, value.asBoolean());
                    return;
                }
                if (member.getName().equals(FIELD_UNSHARED_AT)) {
                    this.mProperties.put(FIELD_UNSHARED_AT, BoxDateFormat.parse(value.asString()));
                    return;
                }
                if (member.getName().equals(FIELD_DOWNLOAD_COUNT)) {
                    this.mProperties.put(FIELD_DOWNLOAD_COUNT, Double.valueOf(value.toString()).longValue());
                    return;
                }
                if (member.getName().equals(FIELD_PREVIEW_COUNT)) {
                    this.mProperties.put(FIELD_PREVIEW_COUNT, Double.valueOf(value.toString()).longValue());
                    return;
                }
                if (member.getName().equals(FIELD_ACCESS)) {
                    this.mProperties.put(FIELD_ACCESS, Access.fromString(value.asString()));
                    return;
                }
                if (member.getName().equals(FIELD_EFFECTIVE_ACCESS)) {
                    this.mProperties.put(FIELD_EFFECTIVE_ACCESS, Access.fromString(value.asString()));
                    return;
                }
                if (member.getName().equals(FIELD_PERMISSIONS)) {
                    Permissions permissions = new Permissions();
                    permissions.createFromJson(value.asObject());
                    this.mProperties.put(FIELD_PERMISSIONS, permissions);
                    return;
                }
            }
            catch (ParseException e) {
                if ($assertionsDisabled) break block12;
                throw new AssertionError((Object)"A ParseException indicates a bug in the SDK.");
            }
        }
        super.parseJSONMember(member);
    }

    public static enum Access {
        DEFAULT(null),
        OPEN("open"),
        COMPANY("company"),
        COLLABORATORS("collaborators");

        private final String mValue;

        public static Access fromString(String text) {
            if (!TextUtils.isEmpty((CharSequence)text)) {
                for (Access e : Access.values()) {
                    if (!text.equalsIgnoreCase(e.toString())) continue;
                    return e;
                }
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "No enum with text %s found", text));
        }

        private Access(String value) {
            this.mValue = value;
        }

        public String toString() {
            return this.mValue;
        }
    }

    public static class Permissions
    extends BoxJsonObject {
        public static final String FIELD_CAN_DOWNLOAD = "can_download";
        private static final String FIELD_CAN_PREVIEW = "can_preview";

        public Permissions() {
        }

        public Permissions(Map<String, Object> map) {
            super(map);
        }

        public Boolean getCanDownload() {
            return (Boolean)this.mProperties.get(FIELD_CAN_DOWNLOAD);
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            if (member.getName().equals(FIELD_CAN_DOWNLOAD)) {
                this.mProperties.put(FIELD_CAN_DOWNLOAD, value.asBoolean());
            } else if (member.getName().equals(FIELD_CAN_PREVIEW)) {
                this.mProperties.put(FIELD_CAN_PREVIEW, value.asBoolean());
            }
        }
    }
}

