/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.models;

import android.text.TextUtils;
import com.box.androidsdk.content.models.BoxCollaborator;
import com.box.androidsdk.content.models.BoxEnterprise;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BoxUser
extends BoxCollaborator {
    private static final long serialVersionUID = -9176113409457879123L;
    public static final String TYPE = "user";
    public static final String FIELD_LOGIN = "login";
    public static final String FIELD_ROLE = "role";
    public static final String FIELD_LANGUAGE = "language";
    public static final String FIELD_TIMEZONE = "timezone";
    public static final String FIELD_SPACE_AMOUNT = "space_amount";
    public static final String FIELD_SPACE_USED = "space_used";
    public static final String FIELD_MAX_UPLOAD_SIZE = "max_upload_size";
    public static final String FIELD_STATUS = "status";
    public static final String FIELD_JOB_TITLE = "job_title";
    public static final String FIELD_PHONE = "phone";
    public static final String FIELD_ADDRESS = "address";
    public static final String FIELD_AVATAR_URL = "avatar_url";
    public static final String FIELD_TRACKING_CODES = "tracking_codes";
    public static final String FIELD_CAN_SEE_MANAGED_USERS = "can_see_managed_users";
    public static final String FIELD_IS_SYNC_ENABLED = "is_sync_enabled";
    public static final String FIELD_IS_EXTERNAL_COLLAB_RESTRICTED = "is_external_collab_restricted";
    public static final String FIELD_IS_EXEMPT_FROM_DEVICE_LIMITS = "is_exempt_from_device_limits";
    public static final String FIELD_IS_EXEMPT_FROM_LOGIN_VERIFICATION = "is_exempt_from_login_verification";
    public static final String FIELD_ENTERPRISE = "enterprise";
    public static final String FIELD_HOSTNAME = "hostname";
    public static final String[] ALL_FIELDS = new String[]{"type", "id", "name", "login", "created_at", "modified_at", "role", "language", "timezone", "space_amount", "space_used", "max_upload_size", "tracking_codes", "can_see_managed_users", "is_sync_enabled", "is_external_collab_restricted", "status", "job_title", "phone", "address", "avatar_url", "is_exempt_from_device_limits", "is_exempt_from_login_verification", "enterprise", "hostname"};

    public BoxUser() {
    }

    public BoxUser(Map<String, Object> map) {
        super(map);
    }

    public static BoxUser createFromId(String userId) {
        LinkedHashMap<String, Object> userMap = new LinkedHashMap<String, Object>();
        userMap.put("id", userId);
        userMap.put("type", TYPE);
        return new BoxUser(userMap);
    }

    public String getLogin() {
        return (String)this.mProperties.get(FIELD_LOGIN);
    }

    public Role getRole() {
        return (Role)((Object)this.mProperties.get(FIELD_ROLE));
    }

    public String getLanguage() {
        return (String)this.mProperties.get(FIELD_LANGUAGE);
    }

    public String getTimezone() {
        return (String)this.mProperties.get(FIELD_TIMEZONE);
    }

    public Long getSpaceAmount() {
        return (Long)this.mProperties.get(FIELD_SPACE_AMOUNT);
    }

    public Long getSpaceUsed() {
        return (Long)this.mProperties.get(FIELD_SPACE_USED);
    }

    public Long getMaxUploadSize() {
        return (Long)this.mProperties.get(FIELD_MAX_UPLOAD_SIZE);
    }

    public Status getStatus() {
        return (Status)((Object)this.mProperties.get(FIELD_STATUS));
    }

    public String getJobTitle() {
        return (String)this.mProperties.get(FIELD_JOB_TITLE);
    }

    public String getPhone() {
        return (String)this.mProperties.get(FIELD_PHONE);
    }

    public String getAddress() {
        return (String)this.mProperties.get(FIELD_ADDRESS);
    }

    public String getAvatarURL() {
        return (String)this.mProperties.get(FIELD_AVATAR_URL);
    }

    public List<String> getTrackingCodes() {
        return (List)this.mProperties.get(FIELD_TRACKING_CODES);
    }

    public Boolean getCanSeeManagedUsers() {
        return (Boolean)this.mProperties.get(FIELD_CAN_SEE_MANAGED_USERS);
    }

    public Boolean getIsSyncEnabled() {
        return (Boolean)this.mProperties.get(FIELD_IS_SYNC_ENABLED);
    }

    public Boolean getIsExternalCollabRestricted() {
        return (Boolean)this.mProperties.get(FIELD_IS_EXTERNAL_COLLAB_RESTRICTED);
    }

    public Boolean getIsExemptFromDeviceLimits() {
        return (Boolean)this.mProperties.get(FIELD_IS_EXEMPT_FROM_DEVICE_LIMITS);
    }

    public Boolean getIsExemptFromLoginVerification() {
        return (Boolean)this.mProperties.get(FIELD_IS_EXEMPT_FROM_LOGIN_VERIFICATION);
    }

    public BoxEnterprise getEnterprise() {
        return (BoxEnterprise)this.mProperties.get(FIELD_ENTERPRISE);
    }

    public String getHostname() {
        return (String)this.mProperties.get(FIELD_HOSTNAME);
    }

    @Override
    protected void parseJSONMember(JsonObject.Member member) {
        String memberName = member.getName();
        JsonValue value = member.getValue();
        if (memberName.equals(FIELD_LOGIN)) {
            this.mProperties.put(FIELD_LOGIN, value.asString());
            return;
        }
        if (memberName.equals(FIELD_ROLE)) {
            this.mProperties.put(FIELD_ROLE, this.parseRole(value));
            return;
        }
        if (memberName.equals(FIELD_LANGUAGE)) {
            this.mProperties.put(FIELD_LANGUAGE, value.asString());
            return;
        }
        if (memberName.equals(FIELD_TIMEZONE)) {
            this.mProperties.put(FIELD_TIMEZONE, value.asString());
            return;
        }
        if (memberName.equals(FIELD_SPACE_AMOUNT)) {
            this.mProperties.put(FIELD_SPACE_AMOUNT, Double.valueOf(value.toString()).longValue());
            return;
        }
        if (memberName.equals(FIELD_SPACE_USED)) {
            this.mProperties.put(FIELD_SPACE_USED, Double.valueOf(value.toString()).longValue());
            return;
        }
        if (memberName.equals(FIELD_MAX_UPLOAD_SIZE)) {
            this.mProperties.put(FIELD_MAX_UPLOAD_SIZE, Double.valueOf(value.toString()).longValue());
            return;
        }
        if (memberName.equals(FIELD_STATUS)) {
            this.mProperties.put(FIELD_STATUS, this.parseStatus(value));
            return;
        }
        if (memberName.equals(FIELD_JOB_TITLE)) {
            this.mProperties.put(FIELD_JOB_TITLE, value.asString());
            return;
        }
        if (memberName.equals(FIELD_PHONE)) {
            this.mProperties.put(FIELD_PHONE, value.asString());
            return;
        }
        if (memberName.equals(FIELD_ADDRESS)) {
            this.mProperties.put(FIELD_ADDRESS, value.asString());
            return;
        }
        if (memberName.equals(FIELD_AVATAR_URL)) {
            this.mProperties.put(FIELD_AVATAR_URL, value.asString());
            return;
        }
        if (memberName.equals(FIELD_TRACKING_CODES)) {
            this.mProperties.put(FIELD_TRACKING_CODES, this.parseTrackingCodes(value.asArray()));
            return;
        }
        if (memberName.equals(FIELD_CAN_SEE_MANAGED_USERS)) {
            this.mProperties.put(FIELD_CAN_SEE_MANAGED_USERS, value.asBoolean());
            return;
        }
        if (memberName.equals(FIELD_IS_SYNC_ENABLED)) {
            this.mProperties.put(FIELD_IS_SYNC_ENABLED, value.asBoolean());
            return;
        }
        if (memberName.equals(FIELD_IS_EXTERNAL_COLLAB_RESTRICTED)) {
            this.mProperties.put(FIELD_IS_EXTERNAL_COLLAB_RESTRICTED, value.asBoolean());
            return;
        }
        if (memberName.equals(FIELD_IS_EXEMPT_FROM_DEVICE_LIMITS)) {
            this.mProperties.put(FIELD_IS_EXEMPT_FROM_DEVICE_LIMITS, value.asBoolean());
            return;
        }
        if (memberName.equals(FIELD_IS_EXEMPT_FROM_LOGIN_VERIFICATION)) {
            this.mProperties.put(FIELD_IS_EXEMPT_FROM_LOGIN_VERIFICATION, value.asBoolean());
            return;
        }
        if (memberName.equals(FIELD_ENTERPRISE)) {
            BoxEnterprise enterprise = new BoxEnterprise();
            enterprise.createFromJson(value.asObject());
            this.mProperties.put(FIELD_ENTERPRISE, enterprise);
            return;
        }
        if (memberName.equals(FIELD_HOSTNAME)) {
            this.mProperties.put(FIELD_HOSTNAME, value.asString());
            return;
        }
        super.parseJSONMember(member);
    }

    private Role parseRole(JsonValue value) {
        String roleString = value.asString().toUpperCase();
        return Role.valueOf(roleString);
    }

    private Status parseStatus(JsonValue value) {
        String statusString = value.asString().toUpperCase();
        return Status.valueOf(statusString);
    }

    private List<String> parseTrackingCodes(JsonArray jsonArray) {
        ArrayList<String> tags = new ArrayList<String>(jsonArray.size());
        for (JsonValue value : jsonArray) {
            tags.add(value.asString());
        }
        return tags;
    }

    public static enum Status {
        ACTIVE("active"),
        INACTIVE("inactive"),
        CANNOT_DELETE_EDIT("cannot_delete_edit"),
        CANNOT_DELETE_EDIT_UPLOAD("cannot_delete_edit_upload");

        private final String mValue;

        private Status(String value) {
            this.mValue = value;
        }

        public static Status fromString(String text) {
            if (!TextUtils.isEmpty((CharSequence)text)) {
                for (Status e : Status.values()) {
                    if (!text.equalsIgnoreCase(e.toString())) continue;
                    return e;
                }
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "No enum with text %s found", text));
        }

        public String toString() {
            return this.mValue;
        }
    }

    public static enum Role {
        ADMIN("admin"),
        COADMIN("coadmin"),
        USER("user");

        private final String mValue;

        private Role(String value) {
            this.mValue = value;
        }

        public static Role fromString(String text) {
            if (!TextUtils.isEmpty((CharSequence)text)) {
                for (Role e : Role.values()) {
                    if (!text.equalsIgnoreCase(e.toString())) continue;
                    return e;
                }
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "No enum with text %s found", text));
        }

        public String toString() {
            return this.mValue;
        }
    }
}

