/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.requests;

import com.box.androidsdk.content.BoxException;
import com.box.androidsdk.content.listeners.ProgressListener;
import com.box.androidsdk.content.utils.ProgressInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.zip.GZIPInputStream;

public class BoxHttpResponse {
    private static final int BUFFER_SIZE = 8192;
    protected final HttpURLConnection mConnection;
    protected int mResponseCode;
    protected String mContentType;
    private String mBodyString;
    private String mContentEncoding;
    private InputStream rawInputStream;
    private InputStream mInputStream;

    public BoxHttpResponse(HttpURLConnection connection) {
        this.mConnection = connection;
        this.mInputStream = null;
    }

    public void open() throws IOException {
        this.mConnection.connect();
        this.mContentType = this.mConnection.getContentType();
        this.mResponseCode = this.mConnection.getResponseCode();
        this.mContentEncoding = this.mConnection.getContentEncoding();
    }

    public int getResponseCode() {
        return this.mResponseCode;
    }

    public int getContentLength() {
        return this.mConnection.getContentLength();
    }

    public String getContentType() {
        return this.mContentType;
    }

    public InputStream getBody() throws BoxException {
        return this.getBody(null);
    }

    public InputStream getBody(ProgressListener listener) throws BoxException {
        if (this.mInputStream == null) {
            String contentEncoding = this.mConnection.getContentEncoding();
            try {
                if (this.rawInputStream == null) {
                    this.rawInputStream = this.mConnection.getInputStream();
                }
                this.mInputStream = listener == null ? this.rawInputStream : new ProgressInputStream(this.rawInputStream, listener, this.getContentLength());
                if (contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip")) {
                    this.mInputStream = new GZIPInputStream(this.mInputStream);
                }
                return this.mInputStream;
            }
            catch (IOException e) {
                throw new BoxException("Couldn't connect to the Box API due to a network error.", e);
            }
        }
        return this.mInputStream;
    }

    public void disconnect() throws BoxException {
        try {
            if (this.rawInputStream == null) {
                this.rawInputStream = this.mConnection.getInputStream();
            }
            byte[] buffer = new byte[8192];
            int n = this.rawInputStream.read(buffer);
            while (n != -1) {
                n = this.rawInputStream.read(buffer);
            }
            this.rawInputStream.close();
            if (this.mInputStream != null) {
                this.mInputStream.close();
            }
        }
        catch (IOException e) {
            throw new BoxException("Couldn't finish closing the connection to the Box API due to a network error or because the stream was already closed.", e);
        }
    }

    public String getStringBody() throws BoxException {
        if (this.mBodyString != null) {
            return this.mBodyString;
        }
        InputStream stream = null;
        try {
            stream = BoxHttpResponse.isErrorCode(this.mResponseCode) ? this.mConnection.getErrorStream() : this.mConnection.getInputStream();
            this.mBodyString = this.readStream(stream);
        }
        catch (IOException e) {
            throw new BoxException("Unable to get string body", e);
        }
        return this.mBodyString;
    }

    private String readStream(InputStream inputStream) throws IOException, BoxException {
        if (inputStream == null) {
            return null;
        }
        InputStream stream = this.mContentEncoding != null && this.mContentEncoding.equalsIgnoreCase("gzip") ? new GZIPInputStream(inputStream) : inputStream;
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[8192];
        try {
            InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
            int read = reader.read(buffer, 0, 8192);
            while (read != -1) {
                builder.append(buffer, 0, read);
                read = reader.read(buffer, 0, 8192);
            }
            reader.close();
        }
        catch (IOException e) {
            throw new BoxException("Unable to read stream", e);
        }
        return builder.toString();
    }

    public HttpURLConnection getHttpURLConnection() {
        return this.mConnection;
    }

    private static boolean isErrorCode(int responseCode) {
        return responseCode >= 400;
    }
}

