/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.requests;

import android.text.TextUtils;
import com.box.androidsdk.content.BoxException;
import com.box.androidsdk.content.BoxFutureTask;
import com.box.androidsdk.content.auth.BoxAuthentication;
import com.box.androidsdk.content.listeners.ProgressListener;
import com.box.androidsdk.content.models.BoxJsonObject;
import com.box.androidsdk.content.models.BoxObject;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.models.BoxSharedLinkSession;
import com.box.androidsdk.content.requests.BoxHttpRequest;
import com.box.androidsdk.content.requests.BoxHttpResponse;
import com.box.androidsdk.content.utils.BoxLogUtils;
import com.box.androidsdk.content.utils.SdkUtils;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public abstract class BoxRequest<T extends BoxObject, R extends BoxRequest<T, R>> {
    protected String mRequestUrlString;
    protected Methods mRequestMethod;
    protected HashMap<String, String> mQueryMap = new HashMap();
    protected LinkedHashMap<String, Object> mBodyMap = new LinkedHashMap();
    protected LinkedHashMap<String, String> mHeaderMap = new LinkedHashMap();
    protected ContentTypes mContentType = ContentTypes.JSON;
    protected BoxSession mSession;
    protected ProgressListener mListener;
    private int mTimeout;
    BoxRequestHandler mRequestHandler;
    Class<T> mClazz;
    private String mStringBody;
    private String mIfMatchEtag;
    private String mIfNoneMatchEtag;

    public BoxRequest(Class<T> clazz, String requestUrl, BoxSession session) {
        this.mClazz = clazz;
        this.mRequestUrlString = requestUrl;
        this.mSession = session;
        this.setRequestHandler(new BoxRequestHandler());
    }

    protected BoxRequest(BoxRequest request) {
        this.mSession = request.getSession();
        this.mClazz = request.mClazz;
        this.mRequestHandler = request.getRequestHandler();
        this.mRequestMethod = request.mRequestMethod;
        this.mContentType = request.mContentType;
        this.mIfMatchEtag = request.getIfMatchEtag();
        this.mListener = request.mListener;
        this.mRequestUrlString = request.mRequestUrlString;
        this.mIfNoneMatchEtag = request.getIfNoneMatchEtag();
        this.mTimeout = request.mTimeout;
        this.mStringBody = request.mStringBody;
        this.importRequestContentMapsFrom(request);
    }

    protected void importRequestContentMapsFrom(BoxRequest source) {
        this.mQueryMap = new HashMap<String, String>(source.mQueryMap);
        this.mBodyMap = new LinkedHashMap<String, Object>(source.mBodyMap);
    }

    public BoxSession getSession() {
        return this.mSession;
    }

    public BoxRequestHandler getRequestHandler() {
        return this.mRequestHandler;
    }

    public R setRequestHandler(BoxRequestHandler handler) {
        this.mRequestHandler = handler;
        return (R)this;
    }

    public R setContentType(ContentTypes contentType) {
        this.mContentType = contentType;
        return (R)this;
    }

    public R setTimeOut(int timeOut) {
        this.mTimeout = timeOut;
        return (R)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T send() throws BoxException {
        BoxRequestHandler requestHandler = this.getRequestHandler();
        BoxHttpResponse response = null;
        HttpURLConnection connection = null;
        try {
            BoxHttpRequest request = this.createHttpRequest();
            connection = request.getUrlConnection();
            if (this.mTimeout > 0) {
                connection.setConnectTimeout(this.mTimeout);
                connection.setReadTimeout(this.mTimeout);
            }
            response = new BoxHttpResponse(connection);
            response.open();
            this.logDebug(response);
            if (requestHandler.isResponseSuccess(response)) {
                T t = requestHandler.onResponse(this.mClazz, response);
                return t;
            }
            try {
                throw new BoxException("An error occurred while sending the request", response);
            }
            catch (IOException e) {
                T t = this.handleSendException(requestHandler, response, e);
                return t;
            }
            catch (InstantiationException e) {
                T t = this.handleSendException(requestHandler, response, e);
                return t;
            }
            catch (IllegalAccessException e) {
                T t = this.handleSendException(requestHandler, response, e);
                return t;
            }
            catch (BoxException e) {
                T t = this.handleSendException(requestHandler, response, e);
                return t;
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private T handleSendException(BoxRequestHandler requestHandler, BoxHttpResponse response, Exception ex) throws BoxException {
        if (ex instanceof BoxException) {
            if (requestHandler.onException(this, response, (BoxException)ex)) {
                return this.send();
            }
            throw (BoxException)ex;
        }
        BoxException e = new BoxException("Couldn't connect to the Box API due to a network error.", ex);
        requestHandler.onException(this, response, e);
        throw e;
    }

    public BoxFutureTask<T> toTask() {
        return new BoxFutureTask<T>(this.mClazz, this);
    }

    protected BoxHttpRequest createHttpRequest() throws IOException, BoxException {
        URL requestUrl = this.buildUrl();
        BoxHttpRequest httpRequest = new BoxHttpRequest(requestUrl, this.mRequestMethod, this.mListener);
        this.setHeaders(httpRequest);
        this.setBody(httpRequest);
        return httpRequest;
    }

    protected URL buildUrl() throws MalformedURLException, UnsupportedEncodingException {
        String queryString = this.createQuery(this.mQueryMap);
        URL requestUrl = TextUtils.isEmpty((CharSequence)queryString) ? new URL(this.mRequestUrlString) : new URL(String.format(Locale.ENGLISH, "%s?%s", this.mRequestUrlString, queryString));
        return requestUrl;
    }

    protected String createQuery(Map<String, String> map) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        String queryPattern = "%s=%s";
        boolean first = true;
        for (Map.Entry<String, String> pair : map.entrySet()) {
            sb.append(String.format(Locale.ENGLISH, queryPattern, URLEncoder.encode(pair.getKey(), "UTF-8"), URLEncoder.encode(pair.getValue(), "UTF-8")));
            if (!first) continue;
            queryPattern = "&" + queryPattern;
            first = false;
        }
        return sb.toString();
    }

    protected void setHeaders(BoxHttpRequest request) {
        String accessToken;
        this.mHeaderMap.clear();
        BoxAuthentication.BoxAuthenticationInfo info = this.mSession.getAuthInfo();
        String string2 = accessToken = info == null ? null : info.accessToken();
        if (!SdkUtils.isEmptyString(accessToken)) {
            this.mHeaderMap.put("Authorization", String.format(Locale.ENGLISH, "Bearer %s", accessToken));
        }
        this.mHeaderMap.put("User-Agent", this.mSession.getUserAgent());
        this.mHeaderMap.put("Accept-Encoding", "gzip");
        this.mHeaderMap.put("Accept-Charset", "utf-8");
        if (this.mIfMatchEtag != null) {
            this.mHeaderMap.put("If-Match", this.mIfMatchEtag);
        }
        if (this.mIfNoneMatchEtag != null) {
            this.mHeaderMap.put("If-None-Match", this.mIfNoneMatchEtag);
        }
        if (this.mSession instanceof BoxSharedLinkSession) {
            BoxSharedLinkSession slSession = (BoxSharedLinkSession)this.mSession;
            String shareLinkHeader = String.format(Locale.ENGLISH, "shared_link=%s", slSession.getSharedLink());
            if (slSession.getPassword() != null) {
                shareLinkHeader = shareLinkHeader + String.format(Locale.ENGLISH, "&shared_link_password=%s", slSession.getPassword());
            }
            this.mHeaderMap.put("BoxApi", shareLinkHeader);
        }
        for (Map.Entry<String, String> h : this.mHeaderMap.entrySet()) {
            request.addHeader(h.getKey(), h.getValue());
        }
    }

    protected R setIfMatchEtag(String etag) {
        this.mIfMatchEtag = etag;
        return (R)this;
    }

    protected String getIfMatchEtag() {
        return this.mIfMatchEtag;
    }

    protected R setIfNoneMatchEtag(String etag) {
        this.mIfNoneMatchEtag = etag;
        return (R)this;
    }

    protected String getIfNoneMatchEtag() {
        return this.mIfNoneMatchEtag;
    }

    protected void setBody(BoxHttpRequest request) throws IOException {
        if (!this.mBodyMap.isEmpty()) {
            String body = this.getStringBody();
            byte[] bytes = body.getBytes("UTF-8");
            request.setBody(new ByteArrayInputStream(bytes));
        }
    }

    public String getStringBody() throws UnsupportedEncodingException {
        if (this.mStringBody != null) {
            return this.mStringBody;
        }
        switch (this.mContentType) {
            case JSON: {
                JsonObject jsonBody = new JsonObject();
                for (Map.Entry<String, Object> entry : this.mBodyMap.entrySet()) {
                    this.parseHashMapEntry(jsonBody, entry);
                }
                this.mStringBody = jsonBody.toString();
                break;
            }
            case URL_ENCODED: {
                HashMap<String, String> stringMap = new HashMap<String, String>();
                for (Map.Entry<String, Object> entry : this.mBodyMap.entrySet()) {
                    stringMap.put(entry.getKey(), (String)entry.getValue());
                }
                this.mStringBody = this.createQuery(stringMap);
            }
        }
        return this.mStringBody;
    }

    protected void parseHashMapEntry(JsonObject jsonBody, Map.Entry<String, Object> entry) {
        Object obj = entry.getValue();
        if (obj instanceof BoxJsonObject) {
            jsonBody.add(entry.getKey(), this.parseJsonObject(obj));
        } else if (obj instanceof Double) {
            jsonBody.add(entry.getKey(), Double.toString((Double)obj));
        } else if (obj instanceof Enum || obj instanceof Boolean) {
            jsonBody.add(entry.getKey(), obj.toString());
        } else {
            jsonBody.add(entry.getKey(), (String)entry.getValue());
        }
    }

    protected JsonValue parseJsonObject(Object obj) {
        String json = ((BoxJsonObject)obj).toJson();
        JsonValue value = JsonValue.readFrom((String)json);
        return value;
    }

    protected void logDebug(BoxHttpResponse response) throws BoxException {
        BoxLogUtils.i("BoxContentSdk", String.format(Locale.ENGLISH, "Request (%s):  %s", new Object[]{this.mRequestMethod, this.mRequestUrlString}));
        BoxLogUtils.i("BoxContentSdk", "Request Header", this.mHeaderMap);
        switch (this.mContentType) {
            case JSON: {
                if (SdkUtils.isBlank(this.mStringBody)) break;
                BoxLogUtils.i("BoxContentSdk", String.format(Locale.ENGLISH, "Request JSON:  %s", this.mStringBody));
                break;
            }
            case URL_ENCODED: {
                HashMap<String, String> stringMap = new HashMap<String, String>();
                for (Map.Entry<String, Object> entry : this.mBodyMap.entrySet()) {
                    stringMap.put(entry.getKey(), (String)entry.getValue());
                }
                BoxLogUtils.i("BoxContentSdk", "Request Form Data", stringMap);
                break;
            }
        }
        BoxLogUtils.i("BoxContentSdk", String.format(Locale.ENGLISH, "Response (%s):  %s", response.getResponseCode(), response.getStringBody()));
    }

    public static enum ContentTypes {
        JSON("application/json"),
        URL_ENCODED("application/x-www-form-urlencoded");

        private String mName;

        private ContentTypes(String name) {
            this.mName = name;
        }

        public String toString() {
            return this.mName;
        }
    }

    public static enum Methods {
        GET,
        POST,
        PUT,
        DELETE,
        OPTIONS;

    }

    public static class BoxRequestHandler {
        public static final String OAUTH_ERROR_HEADER = "error";
        public static final String OAUTH_INVALID_TOKEN = "invalid_token";
        public static final String WWW_AUTHENTICATE = "WWW-Authenticate";

        public boolean isResponseSuccess(BoxHttpResponse response) {
            int responseCode = response.getResponseCode();
            return responseCode >= 200 && responseCode < 300;
        }

        public <T extends BoxObject> T onResponse(Class<T> clazz, BoxHttpResponse response) throws IllegalAccessException, InstantiationException, BoxException {
            String contentType = response.getContentType();
            BoxObject entity = (BoxObject)clazz.newInstance();
            if (entity instanceof BoxJsonObject && contentType.contains(ContentTypes.JSON.toString())) {
                String json = response.getStringBody();
                ((BoxJsonObject)entity).createFromJson(json);
            }
            return (T)entity;
        }

        public boolean onException(BoxRequest request, BoxHttpResponse response, BoxException ex) {
            BoxSession session = request.getSession();
            if (this.oauthExpired(response)) {
                try {
                    session.refresh().get();
                    return true;
                }
                catch (Throwable e) {}
            } else if (this.authFailed(response)) {
                session.getAuthInfo().setUser(null);
                try {
                    session.authenticate().get();
                    return session.getUser() != null;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return false;
        }

        private boolean authFailed(BoxHttpResponse response) {
            return response != null && response.getResponseCode() == 401;
        }

        private boolean oauthExpired(BoxHttpResponse response) {
            if (response == null) {
                return false;
            }
            if (401 != response.getResponseCode()) {
                return false;
            }
            String header = response.mConnection.getHeaderField(WWW_AUTHENTICATE);
            if (!SdkUtils.isEmptyString(header)) {
                String[] authStrs;
                for (String str : authStrs = header.split(",")) {
                    if (!this.isInvalidTokenError(str)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isInvalidTokenError(String str) {
            String[] parts = str.split("=");
            return parts.length == 2 && parts[0] != null && parts[1] != null && OAUTH_ERROR_HEADER.equalsIgnoreCase(parts[0].trim()) && OAUTH_INVALID_TOKEN.equalsIgnoreCase(parts[1].replace("\"", "").trim());
        }
    }
}

