/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.requests;

import com.box.androidsdk.content.BoxException;
import com.box.androidsdk.content.listeners.DownloadStartListener;
import com.box.androidsdk.content.listeners.ProgressListener;
import com.box.androidsdk.content.models.BoxDownload;
import com.box.androidsdk.content.models.BoxObject;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.requests.BoxHttpRequest;
import com.box.androidsdk.content.requests.BoxHttpResponse;
import com.box.androidsdk.content.requests.BoxRequest;
import com.box.androidsdk.content.utils.ProgressOutputStream;
import com.box.androidsdk.content.utils.SdkUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

abstract class BoxRequestDownload<E extends BoxObject, R extends BoxRequest<E, R>>
extends BoxRequest<E, R> {
    long mRangeStart = -1L;
    long mRangeEnd = -1L;
    OutputStream mFileOutputStream;
    File mTarget;
    DownloadStartListener mDownloadStartListener;
    private static final String QUERY_VERSION = "version";

    public BoxRequestDownload(Class<E> clazz, OutputStream outputStream, String requestUrl, BoxSession session) {
        super(clazz, requestUrl, session);
        this.mRequestMethod = BoxRequest.Methods.GET;
        this.mRequestUrlString = requestUrl;
        this.mFileOutputStream = outputStream;
        this.setRequestHandler(new DownloadRequestHandler(this));
    }

    public BoxRequestDownload(Class<E> clazz, File target, String requestUrl, BoxSession session) {
        super(clazz, requestUrl, session);
        this.mRequestMethod = BoxRequest.Methods.GET;
        this.mRequestUrlString = requestUrl;
        this.mTarget = target;
        this.setRequestHandler(new DownloadRequestHandler(this));
    }

    @Override
    protected void setHeaders(BoxHttpRequest request) {
        super.setHeaders(request);
        if (this.mRangeStart != -1L && this.mRangeEnd != -1L) {
            request.addHeader("Range", String.format("bytes=%s-%s", Long.toString(this.mRangeStart), Long.toString(this.mRangeEnd)));
        }
    }

    @Override
    protected void logDebug(BoxHttpResponse response) throws BoxException {
    }

    public File getTarget() {
        return this.mTarget;
    }

    public OutputStream getTargetStream() {
        return this.mFileOutputStream;
    }

    public long getRangeStart() {
        return this.mRangeStart;
    }

    public long getRangeEnd() {
        return this.mRangeEnd;
    }

    public R setRange(long rangeStart, long rangeEnd) {
        this.mRangeStart = rangeStart;
        this.mRangeEnd = rangeEnd;
        return (R)this;
    }

    public R setVersion(String versionId) {
        this.mQueryMap.put(QUERY_VERSION, versionId);
        return (R)this;
    }

    public String getVersion() {
        return (String)this.mQueryMap.get(QUERY_VERSION);
    }

    public R setProgressListener(ProgressListener listener) {
        this.mListener = listener;
        return (R)this;
    }

    public R setDownloadStartListener(DownloadStartListener listener) {
        this.mDownloadStartListener = listener;
        return (R)this;
    }

    public static class DownloadRequestHandler
    extends BoxRequest.BoxRequestHandler {
        private final BoxRequestDownload mRequest;

        public DownloadRequestHandler(BoxRequestDownload request) {
            this.mRequest = request;
        }

        protected OutputStream getOutputStream(BoxDownload downloadInfo) throws FileNotFoundException, IOException {
            if (this.mRequest.mFileOutputStream == null) {
                if (!downloadInfo.getOutputFile().exists()) {
                    downloadInfo.getOutputFile().createNewFile();
                }
                return new FileOutputStream(downloadInfo.getOutputFile());
            }
            return this.mRequest.mFileOutputStream;
        }

        public BoxDownload onResponse(Class clazz, BoxHttpResponse response) throws IllegalAccessException, InstantiationException, BoxException {
            String contentType = response.getContentType();
            long contentLength = -1L;
            if (response.getResponseCode() == 200 || response.getResponseCode() == 206) {
                String contentLengthString = response.getHttpURLConnection().getHeaderField("Content-Length");
                String contentDisposition = response.getHttpURLConnection().getHeaderField("Content-Disposition");
                try {
                    contentLength = Long.parseLong(contentLengthString);
                }
                catch (Exception e) {
                    // empty catch block
                }
                String contentRange = response.getHttpURLConnection().getHeaderField("Content-Range");
                String date = response.getHttpURLConnection().getHeaderField("Date");
                String expirationDate = response.getHttpURLConnection().getHeaderField("Expiration");
                BoxDownload downloadInfo = new BoxDownload(contentDisposition, contentLength, contentType, contentRange, date, expirationDate){

                    @Override
                    public File getOutputFile() {
                        if (DownloadRequestHandler.this.mRequest.getTarget() == null) {
                            return null;
                        }
                        if (DownloadRequestHandler.this.mRequest.getTarget().isFile()) {
                            return DownloadRequestHandler.this.mRequest.getTarget();
                        }
                        if (!SdkUtils.isEmptyString(this.getFileName())) {
                            return new File(DownloadRequestHandler.this.mRequest.getTarget(), this.getFileName());
                        }
                        return super.getOutputFile();
                    }
                };
                if (this.mRequest.mDownloadStartListener != null) {
                    this.mRequest.mDownloadStartListener.onStart(downloadInfo);
                }
                OutputStream output = null;
                try {
                    if (this.mRequest.mListener != null) {
                        output = new ProgressOutputStream(this.getOutputStream(downloadInfo), this.mRequest.mListener, contentLength);
                        this.mRequest.mListener.onProgressChanged(0L, contentLength);
                    } else {
                        output = this.getOutputStream(downloadInfo);
                    }
                    SdkUtils.copyStream(response.getHttpURLConnection().getInputStream(), output);
                }
                catch (Exception e) {
                    throw new BoxException(e.getMessage(), e);
                }
                finally {
                    if (this.mRequest.getTargetStream() == null) {
                        try {
                            output.close();
                        }
                        catch (IOException e) {}
                    }
                }
                return downloadInfo;
            }
            return new BoxDownload(null, 0L, null, null, null, null);
        }
    }
}

