/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.requests;

import com.box.androidsdk.content.BoxException;
import com.box.androidsdk.content.models.BoxJsonObject;
import com.box.androidsdk.content.models.BoxListEvents;
import com.box.androidsdk.content.models.BoxObject;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.requests.BoxHttpResponse;
import com.box.androidsdk.content.requests.BoxRequest;
import com.box.androidsdk.content.utils.IStreamPosition;
import java.util.Collection;

abstract class BoxRequestEvent<E extends BoxJsonObject, R extends BoxRequest<E, R>>
extends BoxRequest<E, R> {
    public static final String STREAM_TYPE_ALL = "all";
    public static final String STREAM_TYPE_CHANGES = "changes";
    public static final String STREAM_TYPE_SYNC = "sync";
    public static final String FIELD_STREAM_POSITION = "stream_position";
    public static final String FIELD_STREAM_TYPE = "stream_type";
    public static final String FIELD_LIMIT = "stream_limit";
    private boolean mFilterDuplicates = true;
    private E mListEvents;

    public BoxRequestEvent(Class<E> clazz, String requestUrl, BoxSession session) {
        super(clazz, requestUrl, session);
        this.mRequestUrlString = requestUrl;
        this.mRequestMethod = BoxRequest.Methods.GET;
        this.setRequestHandler(new BoxRequest.BoxRequestHandler(){

            @Override
            public <T extends BoxObject> T onResponse(Class<T> clazz, BoxHttpResponse response) throws IllegalAccessException, InstantiationException, BoxException {
                String contentType = response.getContentType();
                BoxObject entity = (BoxObject)clazz.newInstance();
                if (entity instanceof BoxListEvents) {
                    ((BoxListEvents)entity).setFilterDuplicates(BoxRequestEvent.this.mFilterDuplicates);
                }
                if (entity instanceof BoxJsonObject && contentType.contains(BoxRequest.ContentTypes.JSON.toString())) {
                    String json = response.getStringBody();
                    char charA = json.charAt(json.indexOf("event") - 1);
                    char charB = json.charAt(json.indexOf("user") - 1);
                    ((BoxJsonObject)entity).createFromJson(json);
                }
                return (T)entity;
            }
        });
    }

    public R setStreamPosition(String streamPosition) {
        this.mQueryMap.put(FIELD_STREAM_POSITION, streamPosition);
        return (R)this;
    }

    protected R setStreamType(String streamType) {
        this.mQueryMap.put(FIELD_STREAM_TYPE, streamType);
        return (R)this;
    }

    public R setLimit(int limit) {
        this.mQueryMap.put(FIELD_LIMIT, Integer.toString(limit));
        return (R)this;
    }

    public R setFilterDuplicates(boolean filterDuplicates) {
        this.mFilterDuplicates = filterDuplicates;
        return (R)this;
    }

    public R setPreviousListEvents(E listEvents) {
        this.mListEvents = listEvents;
        this.setStreamPosition(((IStreamPosition)this.mListEvents).getNextStreamPosition().toString());
        return (R)this;
    }

    @Override
    public E send() throws BoxException {
        if (this.mListEvents != null) {
            BoxJsonObject nextEvents = (BoxJsonObject)super.send();
            ((Collection)this.mListEvents).addAll((Collection)super.send());
            ((Collection)((Object)nextEvents)).clear();
            ((Collection)((Object)nextEvents)).addAll((Collection)this.mListEvents);
            return (E)nextEvents;
        }
        return (E)((BoxJsonObject)super.send());
    }
}

