/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.requests;

import com.box.androidsdk.content.models.BoxItem;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.models.BoxSharedLink;
import com.box.androidsdk.content.requests.BoxRequest;
import com.box.androidsdk.content.requests.BoxRequestItemUpdate;
import com.box.androidsdk.content.utils.BoxDateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;

public abstract class BoxRequestUpdateSharedItem<E extends BoxItem, R extends BoxRequest<E, R>>
extends BoxRequestItemUpdate<E, R> {
    public BoxRequestUpdateSharedItem(Class<E> clazz, String id2, String requestUrl, BoxSession session) {
        super(clazz, id2, requestUrl, session);
        this.mRequestMethod = BoxRequest.Methods.PUT;
    }

    protected BoxRequestUpdateSharedItem(BoxRequestItemUpdate r) {
        super(r);
    }

    public BoxSharedLink.Access getAccess() {
        return this.mBodyMap.containsKey("shared_link") ? ((BoxSharedLink)this.mBodyMap.get("shared_link")).getAccess() : null;
    }

    public R setAccess(BoxSharedLink.Access access) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.mBodyMap.containsKey("shared_link")) {
            BoxSharedLink sl = (BoxSharedLink)this.mBodyMap.get("shared_link");
            map = new LinkedHashMap<String, Object>(sl.getPropertiesAsHashMap());
        }
        map.put("access", (Object)access);
        BoxSharedLink sharedLink = new BoxSharedLink(map);
        this.mBodyMap.put("shared_link", sharedLink);
        return (R)this;
    }

    public Date getUnsharedAt() {
        return this.mBodyMap.containsKey("shared_link") ? ((BoxSharedLink)this.mBodyMap.get("shared_link")).getUnsharedDate() : null;
    }

    public R setUnsharedAt(Date unsharedAt) throws ParseException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.mBodyMap.containsKey("shared_link")) {
            BoxSharedLink sl = (BoxSharedLink)this.mBodyMap.get("shared_link");
            map = new LinkedHashMap<String, Object>(sl.getPropertiesAsHashMap());
        }
        if (unsharedAt == null) {
            map.put("unshared_at", null);
        } else {
            String roundDay = BoxDateFormat.formatRoundToDay(unsharedAt);
            Date unsharedAtRounded = BoxDateFormat.parseRoundToDay(roundDay);
            map.put("unshared_at", unsharedAtRounded);
        }
        BoxSharedLink sharedLink = new BoxSharedLink(map);
        this.mBodyMap.put("shared_link", sharedLink);
        return (R)this;
    }

    public R setRemoveUnsharedAtDate() throws ParseException {
        return this.setUnsharedAt(null);
    }

    public String getPassword() {
        return this.mBodyMap.containsKey("shared_link") ? ((BoxSharedLink)this.mBodyMap.get("shared_link")).getPassword() : null;
    }

    public R setPassword(String password) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.mBodyMap.containsKey("shared_link")) {
            BoxSharedLink sl = (BoxSharedLink)this.mBodyMap.get("shared_link");
            map = new LinkedHashMap<String, Object>(sl.getPropertiesAsHashMap());
        }
        map.put("password", password);
        BoxSharedLink sharedLink = new BoxSharedLink(map);
        this.mBodyMap.put("shared_link", sharedLink);
        return (R)this;
    }

    protected Boolean getCanDownload() {
        return this.mBodyMap.containsKey("shared_link") ? ((BoxSharedLink)this.mBodyMap.get("shared_link")).getPermissions().getCanDownload() : null;
    }

    protected R setCanDownload(boolean canDownload) {
        BoxSharedLink.Permissions permissions;
        LinkedHashMap<Object, Object> sharedLinkMap = new LinkedHashMap();
        if (this.mBodyMap.containsKey("shared_link")) {
            BoxSharedLink sl = (BoxSharedLink)this.mBodyMap.get("shared_link");
            sharedLinkMap = new LinkedHashMap<String, Object>(sl.getPropertiesAsHashMap());
        }
        LinkedHashMap<String, Object> permissionsMap = new LinkedHashMap<String, Object>();
        if (sharedLinkMap.containsKey("permissions")) {
            permissions = (BoxSharedLink.Permissions)sharedLinkMap.get("permissions");
            permissionsMap = new LinkedHashMap<String, Object>(permissions.getPropertiesAsHashMap());
        }
        permissionsMap.put("can_download", canDownload);
        permissions = new BoxSharedLink.Permissions(permissionsMap);
        sharedLinkMap.put("permissions", permissions);
        BoxSharedLink sharedLink = new BoxSharedLink(sharedLinkMap);
        this.mBodyMap.put("shared_link", sharedLink);
        return (R)this;
    }

    @Override
    public BoxRequestUpdateSharedItem updateSharedLink() {
        return this;
    }
}

