/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.requests;

import com.box.androidsdk.content.BoxException;
import com.box.androidsdk.content.listeners.ProgressListener;
import com.box.androidsdk.content.models.BoxJsonObject;
import com.box.androidsdk.content.models.BoxList;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.requests.BoxHttpRequest;
import com.box.androidsdk.content.requests.BoxHttpResponse;
import com.box.androidsdk.content.requests.BoxRequest;
import com.box.androidsdk.content.requests.BoxRequestMultipart;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Locale;

public abstract class BoxRequestUpload<E extends BoxJsonObject, R extends BoxRequest<E, R>>
extends BoxRequest<E, R> {
    InputStream mStream;
    long mUploadSize;
    Date mCreatedDate;
    Date mModifiedDate;
    String mFileName;
    String mSha1;
    File mFile;

    public BoxRequestUpload(Class<E> clazz, InputStream fileInputStream, String requestUrl, BoxSession session) {
        super(clazz, requestUrl, session);
        this.mRequestMethod = BoxRequest.Methods.POST;
        this.mStream = fileInputStream;
        this.mFileName = "";
    }

    @Override
    protected void setHeaders(BoxHttpRequest request) {
        super.setHeaders(request);
        if (this.mSha1 != null) {
            request.addHeader("Content-MD5", this.mSha1);
        }
    }

    protected InputStream getInputStream() throws FileNotFoundException {
        if (this.mStream != null) {
            return this.mStream;
        }
        return new FileInputStream(this.mFile);
    }

    protected BoxRequestMultipart createMultipartRequest() throws IOException, BoxException {
        URL requestUrl = this.buildUrl();
        BoxRequestMultipart httpRequest = new BoxRequestMultipart(requestUrl, this.mRequestMethod, this.mListener);
        this.setHeaders(httpRequest);
        httpRequest.setFile(this.getInputStream(), this.mFileName, this.mUploadSize);
        if (this.mCreatedDate != null) {
            httpRequest.putField("content_created_at", this.mCreatedDate);
        }
        if (this.mModifiedDate != null) {
            httpRequest.putField("content_modified_at", this.mModifiedDate);
        }
        return httpRequest;
    }

    @Override
    protected BoxHttpRequest createHttpRequest() throws IOException, BoxException {
        BoxRequestMultipart httpRequest = this.createMultipartRequest();
        httpRequest.writeBody(httpRequest.mUrlConnection, this.mListener);
        return httpRequest;
    }

    @Override
    public E send() throws BoxException {
        BoxRequest.BoxRequestHandler requestHandler = this.getRequestHandler();
        BoxHttpResponse response = null;
        try {
            BoxHttpRequest request = this.createHttpRequest();
            response = new BoxHttpResponse(request.getUrlConnection());
            response.open();
            if (requestHandler.isResponseSuccess(response)) {
                BoxList list = requestHandler.onResponse(BoxList.class, response);
                return (E)((BoxJsonObject)list.toArray()[0]);
            }
            int code = response.getResponseCode();
            throw new BoxException(String.format(Locale.ENGLISH, "An error occurred while sending the request (%s)", code), response);
        }
        catch (IOException e) {
            throw this.handleSendException(requestHandler, response, e);
        }
        catch (InstantiationException e) {
            throw this.handleSendException(requestHandler, response, e);
        }
        catch (IllegalAccessException e) {
            throw this.handleSendException(requestHandler, response, e);
        }
        catch (BoxException e) {
            throw this.handleSendException(requestHandler, response, e);
        }
    }

    private BoxException handleSendException(BoxRequest.BoxRequestHandler requestHandler, BoxHttpResponse response, Exception ex) throws BoxException {
        BoxException e = ex instanceof BoxException ? (BoxException)ex : new BoxException("Couldn't connect to the Box API due to a network error.", ex);
        requestHandler.onException(this, response, e);
        return e;
    }

    public R setProgressListener(ProgressListener listener) {
        this.mListener = listener;
        return (R)this;
    }

    public long getUploadSize() {
        return this.mUploadSize;
    }

    public R setUploadSize(long mUploadSize) {
        this.mUploadSize = mUploadSize;
        return (R)this;
    }

    public Date getModifiedDate() {
        return this.mModifiedDate;
    }

    public R setModifiedDate(Date mModifiedDate) {
        this.mModifiedDate = mModifiedDate;
        return (R)this;
    }

    public Date getCreatedDate() {
        return this.mCreatedDate;
    }

    public R setCreatedDate(Date mCreatedDate) {
        this.mCreatedDate = mCreatedDate;
        return (R)this;
    }

    public String getSha1() {
        return this.mSha1;
    }

    public void setSha1(String sha1) {
        this.mSha1 = sha1;
    }

    public File getFile() {
        return this.mFile;
    }
}

