/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.requests;

import com.box.androidsdk.content.models.BoxBookmark;
import com.box.androidsdk.content.models.BoxComment;
import com.box.androidsdk.content.models.BoxFolder;
import com.box.androidsdk.content.models.BoxListComments;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.requests.BoxRequest;
import com.box.androidsdk.content.requests.BoxRequestCollectionUpdate;
import com.box.androidsdk.content.requests.BoxRequestCommentAdd;
import com.box.androidsdk.content.requests.BoxRequestItem;
import com.box.androidsdk.content.requests.BoxRequestItemCopy;
import com.box.androidsdk.content.requests.BoxRequestItemDelete;
import com.box.androidsdk.content.requests.BoxRequestItemRestoreTrashed;
import com.box.androidsdk.content.requests.BoxRequestItemUpdate;
import com.box.androidsdk.content.requests.BoxRequestUpdateSharedItem;
import java.util.HashMap;

public class BoxRequestsBookmark {

    public static class DeleteBookmarkFromCollection
    extends BoxRequestCollectionUpdate<BoxBookmark, DeleteBookmarkFromCollection> {
        public DeleteBookmarkFromCollection(String id2, String requestUrl, BoxSession session) {
            super(BoxBookmark.class, id2, requestUrl, session);
            this.setCollectionId(null);
        }
    }

    public static class AddBookmarkToCollection
    extends BoxRequestCollectionUpdate<BoxBookmark, AddBookmarkToCollection> {
        public AddBookmarkToCollection(String id2, String collectionId, String requestUrl, BoxSession session) {
            super(BoxBookmark.class, id2, requestUrl, session);
            this.setCollectionId(collectionId);
        }

        @Override
        public AddBookmarkToCollection setCollectionId(String id2) {
            return (AddBookmarkToCollection)super.setCollectionId(id2);
        }
    }

    public static class AddCommentToBookmark
    extends BoxRequestCommentAdd<BoxComment, AddCommentToBookmark> {
        public AddCommentToBookmark(String bookmarkId, String message, String requestUrl, BoxSession session) {
            super(BoxComment.class, requestUrl, session);
            this.setItemId(bookmarkId);
            this.setItemType("web_link");
            this.setMessage(message);
        }
    }

    public static class GetBookmarkComments
    extends BoxRequestItem<BoxListComments, GetBookmarkComments> {
        public GetBookmarkComments(String id2, String requestUrl, BoxSession session) {
            super(BoxListComments.class, id2, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.GET;
        }
    }

    public static class RestoreTrashedBookmark
    extends BoxRequestItemRestoreTrashed<BoxBookmark, RestoreTrashedBookmark> {
        public RestoreTrashedBookmark(String id2, String requestUrl, BoxSession session) {
            super(BoxBookmark.class, id2, requestUrl, session);
        }
    }

    public static class DeleteTrashedBookmark
    extends BoxRequestItemDelete<DeleteTrashedBookmark> {
        public DeleteTrashedBookmark(String id2, String requestUrl, BoxSession session) {
            super(id2, requestUrl, session);
        }
    }

    public static class GetTrashedBookmark
    extends BoxRequestItem<BoxBookmark, GetTrashedBookmark> {
        public GetTrashedBookmark(String id2, String requestUrl, BoxSession session) {
            super(BoxBookmark.class, id2, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.GET;
        }

        @Override
        public GetTrashedBookmark setIfNoneMatchEtag(String etag) {
            return (GetTrashedBookmark)super.setIfNoneMatchEtag(etag);
        }

        @Override
        public String getIfNoneMatchEtag() {
            return super.getIfNoneMatchEtag();
        }
    }

    public static class DeleteBookmark
    extends BoxRequestItemDelete<DeleteBookmark> {
        public DeleteBookmark(String id2, String requestUrl, BoxSession session) {
            super(id2, requestUrl, session);
        }
    }

    public static class CopyBookmark
    extends BoxRequestItemCopy<BoxBookmark, CopyBookmark> {
        public CopyBookmark(String id2, String parentId, String requestUrl, BoxSession session) {
            super(BoxBookmark.class, id2, parentId, requestUrl, session);
        }
    }

    public static class UpdateSharedBookmark
    extends BoxRequestUpdateSharedItem<BoxBookmark, UpdateSharedBookmark> {
        public UpdateSharedBookmark(String id2, String requestUrl, BoxSession session) {
            super(BoxBookmark.class, id2, requestUrl, session);
        }

        public UpdateSharedBookmark(UpdateBookmark update) {
            super(update);
        }
    }

    public static class UpdateBookmark
    extends BoxRequestItemUpdate<BoxBookmark, UpdateBookmark> {
        public UpdateBookmark(String id2, String requestUrl, BoxSession session) {
            super(BoxBookmark.class, id2, requestUrl, session);
        }

        public String getUrl() {
            return (String)this.mBodyMap.get("url");
        }

        public UpdateBookmark setUrl(String url) {
            this.mBodyMap.put("url", url);
            return this;
        }

        @Override
        public UpdateSharedBookmark updateSharedLink() {
            return new UpdateSharedBookmark(this);
        }
    }

    public static class CreateBookmark
    extends BoxRequestItem<BoxBookmark, CreateBookmark> {
        public CreateBookmark(String parentId, String url, String requestUrl, BoxSession session) {
            super(BoxBookmark.class, null, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.POST;
            this.setParentId(parentId);
            this.setUrl(url);
        }

        public String getParentId() {
            return this.mBodyMap.containsKey("parent") ? (String)this.mBodyMap.get("id") : null;
        }

        public CreateBookmark setParentId(String id2) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", id2);
            BoxFolder parentFolder = new BoxFolder(map);
            this.mBodyMap.put("parent", parentFolder);
            return this;
        }

        public String getUrl() {
            return (String)this.mBodyMap.get("url");
        }

        public CreateBookmark setUrl(String url) {
            this.mBodyMap.put("url", url);
            return this;
        }

        public String getName() {
            return (String)this.mBodyMap.get("name");
        }

        public CreateBookmark setName(String name) {
            this.mBodyMap.put("name", name);
            return this;
        }

        public String getDescription() {
            return (String)this.mBodyMap.get("description");
        }

        public CreateBookmark setDescription(String description) {
            this.mBodyMap.put("description", description);
            return this;
        }
    }

    public static class GetBookmarkInfo
    extends BoxRequestItem<BoxBookmark, GetBookmarkInfo> {
        public GetBookmarkInfo(String id2, String requestUrl, BoxSession session) {
            super(BoxBookmark.class, id2, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.GET;
        }

        @Override
        public GetBookmarkInfo setIfNoneMatchEtag(String etag) {
            return (GetBookmarkInfo)super.setIfNoneMatchEtag(etag);
        }

        @Override
        public String getIfNoneMatchEtag() {
            return super.getIfNoneMatchEtag();
        }
    }
}

