/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.requests;

import com.box.androidsdk.content.models.BoxComment;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.models.BoxVoid;
import com.box.androidsdk.content.requests.BoxRequest;
import com.box.androidsdk.content.requests.BoxRequestCommentAdd;
import com.box.androidsdk.content.requests.BoxRequestItem;

public class BoxRequestsComment {

    public static class DeleteComment
    extends BoxRequest<BoxVoid, DeleteComment> {
        private final String mId;

        public DeleteComment(String id2, String requestUrl, BoxSession session) {
            super(BoxVoid.class, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.DELETE;
            this.mId = id2;
        }

        public String getId() {
            return this.mId;
        }
    }

    public static class UpdateComment
    extends BoxRequest<BoxComment, UpdateComment> {
        String mId;

        public UpdateComment(String id2, String message, String requestUrl, BoxSession session) {
            super(BoxComment.class, requestUrl, session);
            this.mId = id2;
            this.mRequestMethod = BoxRequest.Methods.PUT;
            this.setMessage(message);
        }

        public String getId() {
            return this.mId;
        }

        public String getMessage() {
            return (String)this.mBodyMap.get("message");
        }

        public UpdateComment setMessage(String message) {
            this.mBodyMap.put("message", message);
            return this;
        }
    }

    public static class AddReplyComment
    extends BoxRequestCommentAdd<BoxComment, AddReplyComment> {
        public AddReplyComment(String itemId, String message, String requestUrl, BoxSession session) {
            super(BoxComment.class, requestUrl, session);
            this.setItemId(itemId);
            this.setItemType("comment");
            this.setMessage(message);
        }
    }

    public static class GetCommentInfo
    extends BoxRequestItem<BoxComment, GetCommentInfo> {
        public GetCommentInfo(String id2, String requestUrl, BoxSession session) {
            super(BoxComment.class, id2, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.GET;
        }
    }
}

