/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.requests;

import com.box.androidsdk.content.BoxException;
import com.box.androidsdk.content.models.BoxComment;
import com.box.androidsdk.content.models.BoxDownload;
import com.box.androidsdk.content.models.BoxFile;
import com.box.androidsdk.content.models.BoxFileVersion;
import com.box.androidsdk.content.models.BoxListComments;
import com.box.androidsdk.content.models.BoxListFileVersions;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.models.BoxVoid;
import com.box.androidsdk.content.requests.BoxRequest;
import com.box.androidsdk.content.requests.BoxRequestCollectionUpdate;
import com.box.androidsdk.content.requests.BoxRequestCommentAdd;
import com.box.androidsdk.content.requests.BoxRequestDownload;
import com.box.androidsdk.content.requests.BoxRequestItem;
import com.box.androidsdk.content.requests.BoxRequestItemCopy;
import com.box.androidsdk.content.requests.BoxRequestItemDelete;
import com.box.androidsdk.content.requests.BoxRequestItemRestoreTrashed;
import com.box.androidsdk.content.requests.BoxRequestItemUpdate;
import com.box.androidsdk.content.requests.BoxRequestMultipart;
import com.box.androidsdk.content.requests.BoxRequestUpdateSharedItem;
import com.box.androidsdk.content.requests.BoxRequestUpload;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public class BoxRequestsFile {

    public static class DeleteFileFromCollection
    extends BoxRequestCollectionUpdate<BoxFile, DeleteFileFromCollection> {
        public DeleteFileFromCollection(String id2, String requestUrl, BoxSession session) {
            super(BoxFile.class, id2, requestUrl, session);
            this.setCollectionId(null);
        }
    }

    public static class AddFileToCollection
    extends BoxRequestCollectionUpdate<BoxFile, AddFileToCollection> {
        public AddFileToCollection(String id2, String collectionId, String requestUrl, BoxSession session) {
            super(BoxFile.class, id2, requestUrl, session);
            this.setCollectionId(collectionId);
        }

        @Override
        public AddFileToCollection setCollectionId(String id2) {
            return (AddFileToCollection)super.setCollectionId(id2);
        }
    }

    public static class DownloadThumbnail
    extends BoxRequestDownload<BoxDownload, DownloadThumbnail> {
        private static final String FIELD_MIN_WIDTH = "min_width";
        private static final String FIELD_MIN_HEIGHT = "min_height";
        private static final String FIELD_MAX_WIDTH = "max_width";
        private static final String FIELD_MAX_HEIGHT = "max_height";
        public static int SIZE_32 = 32;
        public static int SIZE_64 = 64;
        public static int SIZE_128 = 128;
        public static int SIZE_256 = 256;

        public DownloadThumbnail(OutputStream outputStream, String requestUrl, BoxSession session) {
            super(BoxDownload.class, outputStream, requestUrl, session);
        }

        public DownloadThumbnail(File target, String requestUrl, BoxSession session) {
            super(BoxDownload.class, target, requestUrl, session);
        }

        public DownloadThumbnail setMinWidth(int width) {
            this.mQueryMap.put(FIELD_MIN_WIDTH, Integer.toString(width));
            return this;
        }

        public DownloadThumbnail setMaxWidth(int width) {
            this.mQueryMap.put(FIELD_MAX_WIDTH, Integer.toString(width));
            return this;
        }

        public DownloadThumbnail setMinHeight(int height) {
            this.mQueryMap.put(FIELD_MIN_HEIGHT, Integer.toString(height));
            return this;
        }

        public DownloadThumbnail setMaxHeight(int height) {
            this.mQueryMap.put(FIELD_MAX_HEIGHT, Integer.toString(height));
            return this;
        }

        public DownloadThumbnail setMinSize(int size) {
            this.setMinWidth(size);
            this.setMinHeight(size);
            return this;
        }
    }

    public static class DownloadFile
    extends BoxRequestDownload<BoxDownload, DownloadFile> {
        public DownloadFile(OutputStream outputStream, String requestUrl, BoxSession session) {
            super(BoxDownload.class, outputStream, requestUrl, session);
        }

        public DownloadFile(File target, String requestUrl, BoxSession session) {
            super(BoxDownload.class, target, requestUrl, session);
        }
    }

    public static class UploadNewVersion
    extends BoxRequestUpload<BoxFile, UploadNewVersion> {
        public UploadNewVersion(InputStream fileInputStream, String requestUrl, BoxSession session) {
            super(BoxFile.class, fileInputStream, requestUrl, session);
        }

        @Override
        public UploadNewVersion setIfMatchEtag(String etag) {
            return (UploadNewVersion)super.setIfMatchEtag(etag);
        }

        @Override
        public String getIfMatchEtag() {
            return super.getIfMatchEtag();
        }
    }

    public static class UploadFile
    extends BoxRequestUpload<BoxFile, UploadFile> {
        String mDestinationFolderId;

        public UploadFile(InputStream inputStream, String fileName, String destinationFolderId, String requestUrl, BoxSession session) {
            super(BoxFile.class, inputStream, requestUrl, session);
            this.mRequestUrlString = requestUrl;
            this.mRequestMethod = BoxRequest.Methods.POST;
            this.mFileName = fileName;
            this.mStream = inputStream;
            this.mDestinationFolderId = destinationFolderId;
        }

        public UploadFile(File file, String destinationFolderId, String requestUrl, BoxSession session) {
            super(BoxFile.class, null, requestUrl, session);
            this.mRequestUrlString = requestUrl;
            this.mRequestMethod = BoxRequest.Methods.POST;
            this.mDestinationFolderId = destinationFolderId;
            this.mFileName = file.getName();
            this.mFile = file;
            this.mUploadSize = file.length();
            this.mModifiedDate = new Date(file.lastModified());
        }

        @Override
        protected BoxRequestMultipart createMultipartRequest() throws IOException, BoxException {
            BoxRequestMultipart request = super.createMultipartRequest();
            request.putField("parent_id", this.mDestinationFolderId);
            return request;
        }

        public String getFileName() {
            return this.mFileName;
        }

        public UploadFile setFileName(String mFileName) {
            this.mFileName = mFileName;
            return this;
        }

        public String getDestinationFolderId() {
            return this.mDestinationFolderId;
        }
    }

    public static class DeleteFileVersion
    extends BoxRequest<BoxVoid, DeleteFileVersion> {
        private final String mVersionId;

        public DeleteFileVersion(String versionId, String requestUrl, BoxSession session) {
            super(BoxVoid.class, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.DELETE;
            this.mVersionId = versionId;
        }

        public String getVersionId() {
            return this.mVersionId;
        }
    }

    public static class PromoteFileVersion
    extends BoxRequestItem<BoxFileVersion, PromoteFileVersion> {
        public PromoteFileVersion(String id2, String versionId, String requestUrl, BoxSession session) {
            super(BoxFileVersion.class, id2, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.POST;
            this.setVersionId(versionId);
        }

        public PromoteFileVersion setVersionId(String versionId) {
            this.mBodyMap.put("type", "file_version");
            this.mBodyMap.put("id", versionId);
            return this;
        }
    }

    public static class GetFileVersions
    extends BoxRequestItem<BoxListFileVersions, GetFileVersions> {
        public GetFileVersions(String id2, String requestUrl, BoxSession session) {
            super(BoxListFileVersions.class, id2, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.GET;
            this.setFields(BoxFileVersion.ALL_FIELDS);
        }
    }

    public static class AddCommentToFile
    extends BoxRequestCommentAdd<BoxComment, AddCommentToFile> {
        public AddCommentToFile(String fileId, String message, String requestUrl, BoxSession session) {
            super(BoxComment.class, requestUrl, session);
            this.setItemId(fileId);
            this.setItemType("file");
            this.setMessage(message);
        }
    }

    public static class GetFileComments
    extends BoxRequestItem<BoxListComments, GetFileComments> {
        public GetFileComments(String id2, String requestUrl, BoxSession session) {
            super(BoxListComments.class, id2, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.GET;
        }
    }

    public static class RestoreTrashedFile
    extends BoxRequestItemRestoreTrashed<BoxFile, RestoreTrashedFile> {
        public RestoreTrashedFile(String id2, String requestUrl, BoxSession session) {
            super(BoxFile.class, id2, requestUrl, session);
        }
    }

    public static class DeleteTrashedFile
    extends BoxRequestItemDelete<DeleteTrashedFile> {
        public DeleteTrashedFile(String id2, String requestUrl, BoxSession session) {
            super(id2, requestUrl, session);
        }
    }

    public static class GetTrashedFile
    extends BoxRequestItem<BoxFile, GetTrashedFile> {
        public GetTrashedFile(String id2, String requestUrl, BoxSession session) {
            super(BoxFile.class, id2, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.GET;
        }

        @Override
        public GetTrashedFile setIfNoneMatchEtag(String etag) {
            return (GetTrashedFile)super.setIfNoneMatchEtag(etag);
        }

        @Override
        public String getIfNoneMatchEtag() {
            return super.getIfNoneMatchEtag();
        }
    }

    public static class DeleteFile
    extends BoxRequestItemDelete<DeleteFile> {
        public DeleteFile(String id2, String requestUrl, BoxSession session) {
            super(id2, requestUrl, session);
        }
    }

    public static class CopyFile
    extends BoxRequestItemCopy<BoxFile, CopyFile> {
        public CopyFile(String id2, String parentId, String requestUrl, BoxSession session) {
            super(BoxFile.class, id2, parentId, requestUrl, session);
        }
    }

    public static class UpdatedSharedFile
    extends BoxRequestUpdateSharedItem<BoxFile, UpdatedSharedFile> {
        public UpdatedSharedFile(String id2, String requestUrl, BoxSession session) {
            super(BoxFile.class, id2, requestUrl, session);
        }

        protected UpdatedSharedFile(UpdateFile r) {
            super(r);
        }

        @Override
        public UpdatedSharedFile setCanDownload(boolean canDownload) {
            return (UpdatedSharedFile)super.setCanDownload(canDownload);
        }

        @Override
        public Boolean getCanDownload() {
            return super.getCanDownload();
        }
    }

    public static class UpdateFile
    extends BoxRequestItemUpdate<BoxFile, UpdateFile> {
        public UpdateFile(String id2, String requestUrl, BoxSession session) {
            super(BoxFile.class, id2, requestUrl, session);
        }

        @Override
        public UpdatedSharedFile updateSharedLink() {
            return new UpdatedSharedFile(this);
        }
    }

    public static class GetFileInfo
    extends BoxRequestItem<BoxFile, GetFileInfo> {
        public GetFileInfo(String id2, String requestUrl, BoxSession session) {
            super(BoxFile.class, id2, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.GET;
        }

        @Override
        public GetFileInfo setIfNoneMatchEtag(String etag) {
            return (GetFileInfo)super.setIfNoneMatchEtag(etag);
        }

        @Override
        public String getIfNoneMatchEtag() {
            return super.getIfNoneMatchEtag();
        }
    }
}

