/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.requests;

import com.box.androidsdk.content.models.BoxFolder;
import com.box.androidsdk.content.models.BoxListCollaborations;
import com.box.androidsdk.content.models.BoxListItems;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.models.BoxUploadEmail;
import com.box.androidsdk.content.models.BoxUser;
import com.box.androidsdk.content.requests.BoxRequest;
import com.box.androidsdk.content.requests.BoxRequestCollectionUpdate;
import com.box.androidsdk.content.requests.BoxRequestItem;
import com.box.androidsdk.content.requests.BoxRequestItemCopy;
import com.box.androidsdk.content.requests.BoxRequestItemDelete;
import com.box.androidsdk.content.requests.BoxRequestItemRestoreTrashed;
import com.box.androidsdk.content.requests.BoxRequestItemUpdate;
import com.box.androidsdk.content.requests.BoxRequestUpdateSharedItem;
import com.eclipsesource.json.JsonObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class BoxRequestsFolder {

    public static class GetTrashedItems
    extends BoxRequest<BoxListItems, GetTrashedItems> {
        public GetTrashedItems(String requestUrl, BoxSession session) {
            super(BoxListItems.class, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.GET;
        }
    }

    public static class DeleteFolderFromCollection
    extends BoxRequestCollectionUpdate<BoxFolder, AddFolderToCollection> {
        public DeleteFolderFromCollection(String id2, String requestUrl, BoxSession session) {
            super(BoxFolder.class, id2, requestUrl, session);
            this.setCollectionId(null);
        }
    }

    public static class AddFolderToCollection
    extends BoxRequestCollectionUpdate<BoxFolder, AddFolderToCollection> {
        public AddFolderToCollection(String id2, String collectionId, String requestUrl, BoxSession session) {
            super(BoxFolder.class, id2, requestUrl, session);
            this.setCollectionId(collectionId);
            this.mRequestMethod = BoxRequest.Methods.PUT;
        }

        @Override
        public AddFolderToCollection setCollectionId(String id2) {
            return (AddFolderToCollection)super.setCollectionId(id2);
        }
    }

    public static class GetFolderItems
    extends BoxRequestItem<BoxListItems, GetFolderItems> {
        private static final String LIMIT = "limit";
        private static final String OFFSET = "offset";
        private static final String DEFAULT_LIMIT = "1000";
        private static final String DEFAULT_OFFSET = "0";

        public GetFolderItems(String id2, String requestUrl, BoxSession session) {
            super(BoxListItems.class, id2, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.GET;
            this.mQueryMap.put(LIMIT, DEFAULT_LIMIT);
            this.mQueryMap.put(OFFSET, DEFAULT_OFFSET);
        }

        public GetFolderItems setLimit(int limit) {
            this.mQueryMap.put(LIMIT, String.valueOf(limit));
            return this;
        }

        public GetFolderItems setOffset(int offset) {
            this.mQueryMap.put(OFFSET, String.valueOf(offset));
            return this;
        }
    }

    public static class RestoreTrashedFolder
    extends BoxRequestItemRestoreTrashed<BoxFolder, RestoreTrashedFolder> {
        public RestoreTrashedFolder(String id2, String requestUrl, BoxSession session) {
            super(BoxFolder.class, id2, requestUrl, session);
        }
    }

    public static class DeleteTrashedFolder
    extends BoxRequestItemDelete<DeleteTrashedFolder> {
        public DeleteTrashedFolder(String id2, String requestUrl, BoxSession session) {
            super(id2, requestUrl, session);
        }
    }

    public static class GetTrashedFolder
    extends BoxRequestItem<BoxFolder, GetTrashedFolder> {
        public GetTrashedFolder(String id2, String requestUrl, BoxSession session) {
            super(BoxFolder.class, id2, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.GET;
        }

        @Override
        public GetTrashedFolder setIfNoneMatchEtag(String etag) {
            return (GetTrashedFolder)super.setIfNoneMatchEtag(etag);
        }

        @Override
        public String getIfNoneMatchEtag() {
            return super.getIfNoneMatchEtag();
        }
    }

    public static class DeleteFolder
    extends BoxRequestItemDelete<DeleteFolder> {
        private static final String FIELD_RECURSIVE = "recursive";
        private static final String TRUE = "true";
        private static final String FALSE = "false";

        public DeleteFolder(String id2, String requestUrl, BoxSession session) {
            super(id2, requestUrl, session);
            this.setRecursive(true);
        }

        public DeleteFolder setRecursive(boolean recursive) {
            this.mQueryMap.put(FIELD_RECURSIVE, recursive ? TRUE : FALSE);
            return this;
        }

        public Boolean getRecursive() {
            return TRUE.equals(this.mQueryMap.get(FIELD_RECURSIVE));
        }
    }

    public static class CreateFolder
    extends BoxRequestItem<BoxFolder, CreateFolder> {
        public CreateFolder(String parentId, String name, String requestUrl, BoxSession session) {
            super(BoxFolder.class, null, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.POST;
            this.setParentId(parentId);
            this.setName(name);
        }

        public String getParentId() {
            return this.mBodyMap.containsKey("parent") ? (String)this.mBodyMap.get("id") : null;
        }

        public CreateFolder setParentId(String id2) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", id2);
            BoxFolder parentFolder = new BoxFolder(map);
            this.mBodyMap.put("parent", parentFolder);
            return this;
        }

        public String getName() {
            return (String)this.mBodyMap.get("name");
        }

        public CreateFolder setName(String name) {
            this.mBodyMap.put("name", name);
            return this;
        }
    }

    public static class CopyFolder
    extends BoxRequestItemCopy<BoxFolder, CopyFolder> {
        public CopyFolder(String id2, String parentId, String requestUrl, BoxSession session) {
            super(BoxFolder.class, id2, parentId, requestUrl, session);
        }
    }

    public static class UpdateSharedFolder
    extends BoxRequestUpdateSharedItem<BoxFolder, UpdateSharedFolder> {
        public UpdateSharedFolder(String id2, String requestUrl, BoxSession session) {
            super(BoxFolder.class, id2, requestUrl, session);
        }

        protected UpdateSharedFolder(UpdateFolder r) {
            super(r);
        }

        @Override
        public UpdateSharedFolder setCanDownload(boolean canDownload) {
            return (UpdateSharedFolder)super.setCanDownload(canDownload);
        }

        @Override
        public Boolean getCanDownload() {
            return super.getCanDownload();
        }
    }

    public static class UpdateFolder
    extends BoxRequestItemUpdate<BoxFolder, UpdateFolder> {
        public UpdateFolder(String id2, String requestUrl, BoxSession session) {
            super(BoxFolder.class, id2, requestUrl, session);
        }

        @Override
        public UpdateSharedFolder updateSharedLink() {
            return new UpdateSharedFolder(this);
        }

        public BoxFolder.SyncState getSyncState() {
            return this.mBodyMap.containsKey("sync_state") ? (BoxFolder.SyncState)((Object)this.mBodyMap.get("sync_state")) : null;
        }

        public UpdateFolder setSyncState(BoxFolder.SyncState syncState) {
            this.mBodyMap.put("sync_state", syncState);
            return this;
        }

        public BoxUploadEmail.Access getUploadEmailAccess() {
            return this.mBodyMap.containsKey("folder_upload_email") ? ((BoxUploadEmail)this.mBodyMap.get("folder_upload_email")).getAccess() : null;
        }

        public UpdateFolder setFolderUploadEmailAccess(BoxUploadEmail.Access access) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("access", access == null ? "null" : access.toString());
            BoxUploadEmail uploadEmail = new BoxUploadEmail(map);
            this.mBodyMap.put("folder_upload_email", uploadEmail);
            return this;
        }

        public String getOwnedById() {
            return this.mBodyMap.containsKey("owned_by") ? ((BoxUser)this.mBodyMap.get("owned_by")).getId() : null;
        }

        public UpdateFolder setOwnedById(String userId) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("id", userId);
            BoxUser user = new BoxUser(map);
            this.mBodyMap.put("owned_by", user);
            return this;
        }

        @Override
        protected void parseHashMapEntry(JsonObject jsonBody, Map.Entry<String, Object> entry) {
            if (entry.getKey().equals("folder_upload_email")) {
                jsonBody.add(entry.getKey(), this.parseJsonObject(entry.getValue()));
                return;
            }
            if (entry.getKey().equals("owned_by")) {
                jsonBody.add(entry.getKey(), this.parseJsonObject(entry.getValue()));
                return;
            }
            if (entry.getKey().equals("sync_state")) {
                BoxFolder.SyncState syncState = (BoxFolder.SyncState)((Object)entry.getValue());
                jsonBody.add(entry.getKey(), syncState.toString());
                return;
            }
            super.parseHashMapEntry(jsonBody, entry);
        }
    }

    public static class GetCollaborations
    extends BoxRequestItem<BoxListCollaborations, GetCollaborations> {
        public GetCollaborations(String id2, String requestUrl, BoxSession session) {
            super(BoxListCollaborations.class, id2, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.GET;
        }
    }

    public static class GetFolderInfo
    extends BoxRequestItem<BoxFolder, GetFolderInfo> {
        public GetFolderInfo(String id2, String requestUrl, BoxSession session) {
            super(BoxFolder.class, id2, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.GET;
        }

        @Override
        public GetFolderInfo setIfNoneMatchEtag(String etag) {
            return (GetFolderInfo)super.setIfNoneMatchEtag(etag);
        }

        @Override
        public String getIfNoneMatchEtag() {
            return super.getIfNoneMatchEtag();
        }
    }
}

