/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.requests;

import com.box.androidsdk.content.models.BoxListItems;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.requests.BoxRequest;
import com.box.androidsdk.content.utils.BoxDateFormat;
import com.box.androidsdk.content.utils.SdkUtils;
import java.util.Date;
import java.util.Locale;

public class BoxRequestsSearch {

    public static class Search
    extends BoxRequest<BoxListItems, Search> {
        public static String CONTENT_TYPE_NAME = "name";
        public static String CONTENT_TYPE_DESCRIPTION = "description";
        public static String CONTENT_TYPE_COMMENTS = "comments";
        public static String CONTENT_TYPE_FILE_CONTENTS = "file_content";
        public static String CONTENT_TYPE_TAGS = "tags";
        protected static final String FIELD_QUERY = "query";
        protected static final String FIELD_SCOPE = "scope";
        protected static final String FIELD_FILE_EXTENSIONS = "file_extensions";
        protected static final String FIELD_CREATED_AT_RANGE = "created_at_range";
        protected static final String FIELD_UPDATED_AT_RANGE = "updated_at_range";
        protected static final String FIELD_SIZE_RANGE = "size_range";
        protected static final String FIELD_OWNER_USER_IDS = "owner_user_ids";
        protected static final String FIELD_ANCESTOR_FOLDER_IDS = "ancestor_folder_ids";
        protected static final String FIELD_CONTENT_TYPES = "content_types";
        protected static final String FIELD_TYPE = "type";
        protected static final String FIELD_LIMIT = "limit";
        protected static final String FIELD_OFFSET = "offset";

        public Search(String query, String requestUrl, BoxSession session) {
            super(BoxListItems.class, requestUrl, session);
            this.limitValueForKey(FIELD_QUERY, query);
            this.mRequestMethod = BoxRequest.Methods.GET;
        }

        public Search limitValueForKey(String key, String value) {
            this.mQueryMap.put(key, value);
            return this;
        }

        public Search limitSearchScope(Scope scope) {
            this.limitValueForKey(FIELD_SCOPE, scope.name().toLowerCase(Locale.US));
            return this;
        }

        public Search limitFileExtensions(String[] extensions) {
            this.limitValueForKey(FIELD_FILE_EXTENSIONS, SdkUtils.concatStringWithDelimiter(extensions, ","));
            return this;
        }

        public Search limitCreationTime(Date fromDate, Date toDate) {
            this.addTimeRange(FIELD_CREATED_AT_RANGE, fromDate, toDate);
            return this;
        }

        public Search limitLastUpdateTime(Date fromDate, Date toDate) {
            this.addTimeRange(FIELD_UPDATED_AT_RANGE, fromDate, toDate);
            return this;
        }

        public Search limitSizeRange(long minSize, long maxSize) {
            this.limitValueForKey(FIELD_SIZE_RANGE, String.format("%d,%d", minSize, maxSize));
            return this;
        }

        public Search limitOwnerUserIds(String[] userIds) {
            this.limitValueForKey(FIELD_OWNER_USER_IDS, SdkUtils.concatStringWithDelimiter(userIds, ","));
            return this;
        }

        public Search limitAncestorFolderIds(String[] folderIds) {
            this.limitValueForKey(FIELD_ANCESTOR_FOLDER_IDS, SdkUtils.concatStringWithDelimiter(folderIds, ","));
            return this;
        }

        public Search limitContentTypes(String[] contentTypes) {
            this.limitValueForKey(FIELD_CONTENT_TYPES, SdkUtils.concatStringWithDelimiter(contentTypes, ","));
            return this;
        }

        public Search limitType(String type) {
            this.limitValueForKey(FIELD_TYPE, type);
            return this;
        }

        public Search setLimit(int limit) {
            this.limitValueForKey(FIELD_LIMIT, String.valueOf(limit));
            return this;
        }

        public Search setOffset(int offset) {
            this.limitValueForKey(FIELD_OFFSET, String.valueOf(offset));
            return this;
        }

        public Date getLastUpdatedAtDateRangeFrom() {
            return this.returnFromDate(FIELD_UPDATED_AT_RANGE);
        }

        public Date getLastUpdatedAtDateRangeTo() {
            return this.returnToDate(FIELD_UPDATED_AT_RANGE);
        }

        public Date getCreatedAtDateRangeFrom() {
            return this.returnFromDate(FIELD_CREATED_AT_RANGE);
        }

        public Date getCreatedAtDateRangeTo() {
            return this.returnToDate(FIELD_CREATED_AT_RANGE);
        }

        public Long getSizeRangeFrom() {
            String range = (String)this.mQueryMap.get(FIELD_SIZE_RANGE);
            if (SdkUtils.isEmptyString(range)) {
                return null;
            }
            String[] ranges = range.split(",");
            return Long.parseLong(ranges[0]);
        }

        public Long getSizeRangeTo() {
            String range = (String)this.mQueryMap.get(FIELD_SIZE_RANGE);
            if (SdkUtils.isEmptyString(range)) {
                return null;
            }
            String[] ranges = range.split(",");
            return Long.parseLong(ranges[1]);
        }

        public String[] getOwnerUserIds() {
            return this.getStringArray(FIELD_OWNER_USER_IDS);
        }

        public String[] getAncestorFolderIds() {
            return this.getStringArray(FIELD_ANCESTOR_FOLDER_IDS);
        }

        public String[] getContentTypes() {
            return this.getStringArray(FIELD_CONTENT_TYPES);
        }

        public String getType() {
            return (String)this.mQueryMap.get(FIELD_TYPE);
        }

        public String getLimit() {
            return (String)this.mQueryMap.get(FIELD_LIMIT);
        }

        public String getOffset() {
            return (String)this.mQueryMap.get(FIELD_OFFSET);
        }

        public String getQuery() {
            return (String)this.mQueryMap.get(FIELD_QUERY);
        }

        public String getScope() {
            return (String)this.mQueryMap.get(FIELD_SCOPE);
        }

        public String[] getFileExtensions() {
            return this.getStringArray(FIELD_FILE_EXTENSIONS);
        }

        private String[] getStringArray(String key) {
            String types = (String)this.mQueryMap.get(key);
            if (SdkUtils.isEmptyString(types)) {
                return null;
            }
            return types.split(",");
        }

        private Date returnFromDate(String timeRangeKey) {
            String range = (String)this.mQueryMap.get(timeRangeKey);
            if (!SdkUtils.isEmptyString(range)) {
                return BoxDateFormat.getTimeRangeDates(range)[0];
            }
            return null;
        }

        private Date returnToDate(String timeRangeKey) {
            String range = (String)this.mQueryMap.get(timeRangeKey);
            if (!SdkUtils.isEmptyString(range)) {
                return BoxDateFormat.getTimeRangeDates(range)[1];
            }
            return null;
        }

        private void addTimeRange(String key, Date fromDate, Date toDate) {
            String range = BoxDateFormat.getTimeRangeString(fromDate, toDate);
            if (!SdkUtils.isEmptyString(range)) {
                this.limitValueForKey(key, range);
            }
        }

        public static enum Scope {
            USER_CONTENT,
            ENTERPRISE_CONTENT;

        }
    }
}

