/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.requests;

import com.box.androidsdk.content.BoxException;
import com.box.androidsdk.content.models.BoxBookmark;
import com.box.androidsdk.content.models.BoxCollaboration;
import com.box.androidsdk.content.models.BoxCollaborator;
import com.box.androidsdk.content.models.BoxEntity;
import com.box.androidsdk.content.models.BoxFile;
import com.box.androidsdk.content.models.BoxFolder;
import com.box.androidsdk.content.models.BoxGroup;
import com.box.androidsdk.content.models.BoxItem;
import com.box.androidsdk.content.models.BoxListCollaborations;
import com.box.androidsdk.content.models.BoxMapJsonObject;
import com.box.androidsdk.content.models.BoxObject;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.models.BoxSharedLinkSession;
import com.box.androidsdk.content.models.BoxUser;
import com.box.androidsdk.content.models.BoxVoid;
import com.box.androidsdk.content.requests.BoxHttpResponse;
import com.box.androidsdk.content.requests.BoxRequest;
import com.box.androidsdk.content.utils.SdkUtils;
import java.util.HashMap;

public class BoxRequestsShare {

    public static class UpdateCollaboration
    extends BoxRequest<BoxCollaboration, UpdateCollaboration> {
        private String mId;

        public UpdateCollaboration(String collaborationId, String requestUrl, BoxSession session) {
            super(BoxCollaboration.class, requestUrl, session);
            this.mId = collaborationId;
            this.mRequestMethod = BoxRequest.Methods.PUT;
        }

        public String getId() {
            return this.mId;
        }

        public UpdateCollaboration setNewRole(BoxCollaboration.Role newRole) {
            this.mBodyMap.put("role", newRole.toString());
            return this;
        }

        public UpdateCollaboration setNewStatus(String status) {
            this.mBodyMap.put("status", status);
            return this;
        }
    }

    public static class DeleteCollaboration
    extends BoxRequest<BoxVoid, DeleteCollaboration> {
        private String mId;

        public DeleteCollaboration(String collaborationId, String requestUrl, BoxSession session) {
            super(BoxVoid.class, requestUrl, session);
            this.mId = collaborationId;
            this.mRequestMethod = BoxRequest.Methods.DELETE;
        }

        public String getId() {
            return this.mId;
        }
    }

    public static class AddCollaboration
    extends BoxRequest<BoxCollaboration, AddCollaboration> {
        public static final String ERROR_CODE_USER_ALREADY_COLLABORATOR = "user_already_collaborator";
        private final String mFolderId;

        public AddCollaboration(String url, String folderId, BoxCollaboration.Role role, String userEmail, BoxSession session) {
            super(BoxCollaboration.class, url, session);
            this.mRequestMethod = BoxRequest.Methods.POST;
            this.mFolderId = folderId;
            this.setFolder(folderId);
            this.setAccessibleBy(null, userEmail, "user");
            this.mBodyMap.put("role", role.toString());
        }

        public AddCollaboration(String url, String folderId, BoxCollaboration.Role role, BoxCollaborator collaborator, BoxSession session) {
            super(BoxCollaboration.class, url, session);
            this.mRequestMethod = BoxRequest.Methods.POST;
            this.mFolderId = folderId;
            this.setFolder(folderId);
            this.setAccessibleBy(collaborator.getId(), null, collaborator.getType());
            this.mBodyMap.put("role", role.toString());
        }

        public AddCollaboration notifyCollaborators(boolean notify) {
            this.mQueryMap.put("notify", Boolean.toString(notify));
            return this;
        }

        public String getFolderId() {
            return this.mFolderId;
        }

        private void setFolder(String id2) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", id2);
            map.put("type", "folder");
            this.mBodyMap.put("item", new BoxMapJsonObject(map));
        }

        private void setAccessibleBy(String accessibleById, String accessibleByEmail, String accessibleByType) {
            BoxCollaborator collaborator;
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (!SdkUtils.isEmptyString(accessibleById)) {
                map.put("id", accessibleById);
            }
            if (!SdkUtils.isEmptyString(accessibleByEmail)) {
                map.put("login", accessibleByEmail);
            }
            map.put("type", accessibleByType);
            if (accessibleByType.equals("user")) {
                collaborator = new BoxUser(map);
            } else if (accessibleByType.equals("group")) {
                collaborator = new BoxGroup(map);
            } else {
                throw new IllegalArgumentException("AccessibleBy property can only be set with type BoxUser.TYPE or BoxGroup.TYPE");
            }
            this.mBodyMap.put("accessible_by", collaborator);
        }

        public BoxCollaborator getAccessibleBy() {
            return this.mBodyMap.containsKey("accessible_by") ? (BoxCollaborator)this.mBodyMap.get("accessible_by") : null;
        }
    }

    public static class GetPendingCollaborations
    extends BoxRequest<BoxListCollaborations, GetPendingCollaborations> {
        public GetPendingCollaborations(String requestUrl, BoxSession session) {
            super(BoxListCollaborations.class, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.GET;
            this.mQueryMap.put("status", BoxCollaboration.Status.PENDING.toString());
        }
    }

    public static class GetCollaborationInfo
    extends BoxRequest<BoxCollaboration, GetCollaborationInfo> {
        private final String mId;

        public GetCollaborationInfo(String collaborationId, String requestUrl, BoxSession session) {
            super(BoxCollaboration.class, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.GET;
            this.mId = collaborationId;
        }

        public String getId() {
            return this.mId;
        }
    }

    public static class GetSharedLink
    extends BoxRequest<BoxItem, GetSharedLink> {
        public GetSharedLink(String requestUrl, BoxSharedLinkSession session) {
            super(BoxItem.class, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.GET;
            this.setRequestHandler(new BoxRequest.BoxRequestHandler(){

                @Override
                public <T extends BoxObject> T onResponse(Class<T> clazz, BoxHttpResponse response) throws BoxException {
                    String contentType = response.getContentType();
                    BoxEntity entity = new BoxEntity();
                    if (contentType.contains(BoxRequest.ContentTypes.JSON.toString())) {
                        String json = response.getStringBody();
                        entity.createFromJson(json);
                        if (entity.getType().equals("folder")) {
                            entity = new BoxFolder();
                            entity.createFromJson(json);
                        } else if (entity.getType().equals("file")) {
                            entity = new BoxFile();
                            entity.createFromJson(json);
                        } else if (entity.getType().equals("web_link")) {
                            entity = new BoxBookmark();
                            entity.createFromJson(json);
                        }
                    }
                    return (T)entity;
                }
            });
        }

        @Override
        public GetSharedLink setIfNoneMatchEtag(String etag) {
            return (GetSharedLink)super.setIfNoneMatchEtag(etag);
        }

        @Override
        public String getIfNoneMatchEtag() {
            return super.getIfNoneMatchEtag();
        }
    }
}

