/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.requests;

import com.box.androidsdk.content.models.BoxListUsers;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.models.BoxUser;
import com.box.androidsdk.content.models.BoxVoid;
import com.box.androidsdk.content.requests.BoxRequest;
import com.box.androidsdk.content.requests.BoxRequestItem;
import com.box.androidsdk.content.requests.BoxRequestUserUpdate;
import com.eclipsesource.json.JsonObject;
import java.util.Map;

public class BoxRequestsUser {

    public static class DeleteEnterpriseUser
    extends BoxRequest<BoxVoid, DeleteEnterpriseUser> {
        protected static final String QUERY_NOTIFY = "notify";
        protected static final String QUERY_FORCE = "force";
        protected String mId;

        public DeleteEnterpriseUser(String requestUrl, BoxSession session, String userId) {
            super(BoxVoid.class, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.DELETE;
            this.mId = userId;
        }

        public String getId() {
            return this.mId;
        }

        public Boolean getShouldNotify() {
            return Boolean.valueOf((String)this.mQueryMap.get(QUERY_NOTIFY));
        }

        public DeleteEnterpriseUser setShouldNotify(Boolean shouldNotify) {
            this.mQueryMap.put(QUERY_NOTIFY, Boolean.toString(shouldNotify));
            return this;
        }

        public Boolean getShouldForce() {
            return Boolean.valueOf((String)this.mQueryMap.get(QUERY_FORCE));
        }

        public DeleteEnterpriseUser setShouldForce(Boolean shouldForce) {
            this.mQueryMap.put(QUERY_FORCE, Boolean.toString(shouldForce));
            return this;
        }
    }

    public static class UpdateUserInformation
    extends BoxRequestUserUpdate<BoxUser, UpdateUserInformation> {
        protected static final String FIELD_IS_PASSWORD_RESET_REQUIRED = "is_password_reset_required";

        public UpdateUserInformation(String requestUrl, BoxSession session, String login, String name) {
            super(BoxUser.class, null, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.PUT;
        }

        public String getEnterprise() {
            return (String)this.mBodyMap.get("enterprise");
        }

        public UpdateUserInformation setEnterprise(String enterprise) {
            this.mBodyMap.put("enterprise", enterprise);
            return this;
        }

        public String getIsPasswordResetRequired() {
            return (String)this.mBodyMap.get(FIELD_IS_PASSWORD_RESET_REQUIRED);
        }

        public UpdateUserInformation setIsPasswordResetRequired(boolean isPasswordResetRequired) {
            this.mBodyMap.put(FIELD_IS_PASSWORD_RESET_REQUIRED, isPasswordResetRequired);
            return this;
        }

        @Override
        protected void parseHashMapEntry(JsonObject jsonBody, Map.Entry<String, Object> entry) {
            if (entry.getKey().equals("enterprise")) {
                jsonBody.add(entry.getKey(), entry.getValue() == null ? null : (String)entry.getValue());
                return;
            }
            super.parseHashMapEntry(jsonBody, entry);
        }
    }

    public static class CreateEnterpriseUser
    extends BoxRequestUserUpdate<BoxUser, CreateEnterpriseUser> {
        public CreateEnterpriseUser(String requestUrl, BoxSession session, String login, String name) {
            super(BoxUser.class, null, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.POST;
            this.setLogin(login);
            this.setName(name);
        }

        public String getLogin() {
            return (String)this.mBodyMap.get("login");
        }

        public CreateEnterpriseUser setLogin(String login) {
            this.mBodyMap.put("login", login);
            return this;
        }
    }

    public static class GetEnterpriseUsers
    extends BoxRequestItem<BoxListUsers, GetEnterpriseUsers> {
        protected static final String QUERY_FILTER_TERM = "filter_term";
        protected static final String QUERY_LIMIT = "limit";
        protected static final String QUERY_OFFSET = "offset";

        public GetEnterpriseUsers(String requestUrl, BoxSession session) {
            super(BoxListUsers.class, null, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.GET;
        }

        public String getFilterTerm() {
            return (String)this.mQueryMap.get(QUERY_FILTER_TERM);
        }

        public GetEnterpriseUsers setFilterTerm(String filterTerm) {
            this.mQueryMap.put(QUERY_FILTER_TERM, filterTerm);
            return this;
        }

        public long getLimit() {
            return Long.valueOf((String)this.mQueryMap.get(QUERY_LIMIT));
        }

        public GetEnterpriseUsers setLimit(long limit) {
            this.mQueryMap.put(QUERY_LIMIT, Long.toString(limit));
            return this;
        }

        public long getOffset() {
            return Long.valueOf((String)this.mQueryMap.get(QUERY_OFFSET));
        }

        public GetEnterpriseUsers setOffset(long offset) {
            this.mQueryMap.put(QUERY_OFFSET, Long.toString(offset));
            return this;
        }
    }

    public static class GetUserInfo
    extends BoxRequestItem<BoxUser, GetUserInfo> {
        public GetUserInfo(String requestUrl, BoxSession session) {
            super(BoxUser.class, null, requestUrl, session);
            this.mRequestMethod = BoxRequest.Methods.GET;
        }
    }
}

