/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.utils;

import com.box.androidsdk.content.utils.SdkUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class BoxDateFormat {
    private static final ThreadLocal<DateFormat> THREAD_LOCAL_DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        }
    };
    private static final ThreadLocal<DateFormat> THREAD_LOCAL_ROUND_TO_DAY_DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private static final ThreadLocal<DateFormat> THREAD_LOCAL_HEADER_DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        }
    };
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

    private BoxDateFormat() {
    }

    public static Date parse(String dateString) throws ParseException {
        return THREAD_LOCAL_DATE_FORMAT.get().parse(dateString);
    }

    public static String format(Date date) {
        String format = THREAD_LOCAL_DATE_FORMAT.get().format(date);
        return format.substring(0, 22) + ":" + format.substring(22);
    }

    public static Date parseRoundToDay(String dateString) throws ParseException {
        return THREAD_LOCAL_ROUND_TO_DAY_DATE_FORMAT.get().parse(dateString);
    }

    public static String formatRoundToDay(Date date) {
        return THREAD_LOCAL_ROUND_TO_DAY_DATE_FORMAT.get().format(date);
    }

    public static Date parseHeaderDate(String dateString) throws ParseException {
        return THREAD_LOCAL_HEADER_DATE_FORMAT.get().parse(dateString);
    }

    public static String getTimeRangeString(Date fromDate, Date toDate) {
        if (fromDate == null && toDate == null) {
            return null;
        }
        StringBuilder sbr = new StringBuilder();
        if (fromDate != null) {
            sbr.append(BoxDateFormat.format(fromDate));
        }
        sbr.append(",");
        if (toDate != null) {
            sbr.append(BoxDateFormat.format(toDate));
        }
        return sbr.toString();
    }

    public static Date[] getTimeRangeDates(String timeRangeString) {
        if (SdkUtils.isEmptyString(timeRangeString)) {
            return null;
        }
        String[] dateStrings = timeRangeString.split(",");
        Date[] dates = new Date[2];
        try {
            dates[0] = BoxDateFormat.parse(dateStrings[0]);
        }
        catch (ParseException e) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            dates[1] = BoxDateFormat.parse(dateStrings[1]);
        }
        catch (ParseException e) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return dates;
    }
}

