/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.utils;

import android.util.Log;
import com.box.androidsdk.content.BoxConfig;
import java.util.Locale;
import java.util.Map;

public class BoxLogUtils {
    public static boolean getIsLoggingEnabled() {
        return BoxConfig.IS_LOG_ENABLED && BoxConfig.IS_DEBUG;
    }

    public static void i(String tag, String msg) {
        if (BoxLogUtils.getIsLoggingEnabled()) {
            Log.i((String)tag, (String)msg);
        }
    }

    public static void i(String tag, String msg, Map<String, String> map) {
        if (BoxLogUtils.getIsLoggingEnabled() && map != null) {
            for (Map.Entry<String, String> e : map.entrySet()) {
                Log.i((String)tag, (String)String.format(Locale.ENGLISH, "%s:  %s:%s", msg, e.getKey(), e.getValue()));
            }
        }
    }

    public static void d(String tag, String msg) {
        if (BoxLogUtils.getIsLoggingEnabled()) {
            Log.d((String)tag, (String)msg);
        }
    }

    public static void e(String tag, String msg) {
        if (BoxLogUtils.getIsLoggingEnabled()) {
            Log.e((String)tag, (String)msg);
        }
    }

    public static void e(String tag, String msg, Throwable t) {
        if (BoxLogUtils.getIsLoggingEnabled()) {
            Log.e((String)tag, (String)msg, (Throwable)t);
        }
    }
}

