/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.utils;

import com.box.androidsdk.content.BoxException;
import com.box.androidsdk.content.BoxFutureTask;
import com.box.androidsdk.content.models.BoxListRealTimeServers;
import com.box.androidsdk.content.models.BoxRealTimeServer;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.models.BoxSimpleMessage;
import com.box.androidsdk.content.requests.BoxRequest;
import com.box.androidsdk.content.requests.BoxRequestsEvent;
import com.box.androidsdk.content.requests.BoxResponse;
import com.box.androidsdk.content.utils.SdkUtils;
import java.net.SocketTimeoutException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RealTimeServerConnection
implements BoxFutureTask.OnCompletedListener<BoxSimpleMessage> {
    private BoxRequest mRequest;
    private BoxRealTimeServer mBoxRealTimeServer;
    private BoxSession mSession;
    private final OnChangeListener mChangeListener;
    private final ThreadPoolExecutor mExectuor = SdkUtils.createDefaultThreadPoolExecutor(1, 1, 3600L, TimeUnit.SECONDS);
    private int mRetries = 0;

    public RealTimeServerConnection(BoxRequest getRealTimeServerRequest, OnChangeListener changeListener, BoxSession session) {
        this.mRequest = getRealTimeServerRequest;
        this.mSession = session;
        this.mChangeListener = changeListener;
    }

    public BoxRequest getRequest() {
        return this.mRequest;
    }

    public int getTimesRetried() {
        return this.mRetries;
    }

    public BoxRealTimeServer getRealTimeServer() {
        return this.mBoxRealTimeServer;
    }

    public FutureTask<BoxSimpleMessage> toTask() {
        return new FutureTask<BoxSimpleMessage>(new Callable<BoxSimpleMessage>(){

            @Override
            public BoxSimpleMessage call() throws Exception {
                return RealTimeServerConnection.this.connect();
            }
        });
    }

    public BoxSimpleMessage connect() {
        this.mRetries = 0;
        try {
            BoxListRealTimeServers servers = (BoxListRealTimeServers)this.mRequest.send();
            this.mBoxRealTimeServer = (BoxRealTimeServer)servers.get(0);
        }
        catch (BoxException e) {
            this.mChangeListener.onException(e, this);
            return null;
        }
        BoxRequestsEvent.LongPollMessageRequest messageRequest = new BoxRequestsEvent.LongPollMessageRequest(this.mBoxRealTimeServer.getUrl(), this.mSession);
        messageRequest.setTimeOut(this.mBoxRealTimeServer.getFieldRetryTimeout().intValue() * 1000);
        boolean shouldRetry = true;
        do {
            BoxFutureTask<BoxSimpleMessage> task = null;
            try {
                task = messageRequest.toTask().addOnCompletedListener(this);
                this.mExectuor.submit(task);
                BoxResponse response = (BoxResponse)task.get(this.mBoxRealTimeServer.getFieldRetryTimeout().intValue(), TimeUnit.SECONDS);
                if (response.isSuccess() && !((BoxSimpleMessage)response.getResult()).getMessage().equals("reconnect")) {
                    return (BoxSimpleMessage)response.getResult();
                }
            }
            catch (TimeoutException e) {
                if (task != null) {
                    try {
                        task.cancel(true);
                    }
                    catch (CancellationException e1) {}
                }
            }
            catch (InterruptedException e) {
                this.mChangeListener.onException(e, this);
            }
            catch (ExecutionException e) {
                this.mChangeListener.onException(e, this);
            }
            ++this.mRetries;
            if (this.mBoxRealTimeServer.getMaxRetries() >= (long)this.mRetries) continue;
            shouldRetry = false;
        } while (shouldRetry);
        this.mChangeListener.onException(new MaxRetriesExceededException("Max retries exceeded, ", this.mRetries), this);
        return null;
    }

    protected void handleResponse(BoxResponse<BoxSimpleMessage> response) {
        if (response.isSuccess()) {
            if (!response.getResult().getMessage().equals("reconnect")) {
                this.mChangeListener.onChange(response.getResult(), this);
            }
        } else {
            if (response.getException() instanceof BoxException && response.getException().getCause() instanceof SocketTimeoutException) {
                return;
            }
            this.mChangeListener.onException(response.getException(), this);
        }
    }

    @Override
    public void onCompleted(BoxResponse<BoxSimpleMessage> response) {
        this.handleResponse(response);
    }

    public static class MaxRetriesExceededException
    extends Exception {
        private final int mTimesTried;

        public MaxRetriesExceededException(String message, int timesTried) {
            super(message + timesTried);
            this.mTimesTried = timesTried;
        }

        public int getTimesTried() {
            return this.mTimesTried;
        }
    }

    public static interface OnChangeListener {
        public void onChange(BoxSimpleMessage var1, RealTimeServerConnection var2);

        public void onException(Exception var1, RealTimeServerConnection var2);
    }
}

