/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content.utils;

import com.eclipsesource.json.JsonValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SdkUtils {
    private static final int BUFFER_SIZE = 8192;
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    public static String generateStateToken() {
        return UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException, InterruptedException {
        byte[] buffer = new byte[8192];
        int bufferLength = 0;
        try {
            while ((bufferLength = inputStream.read(buffer)) > 0) {
                if (Thread.currentThread().isInterrupted()) {
                    InterruptedException e = new InterruptedException();
                    throw e;
                }
                outputStream.write(buffer, 0, bufferLength);
            }
        }
        finally {
            Object exception = null;
            outputStream.flush();
            inputStream.close();
        }
    }

    public static OutputStream createArrayOutputStream(final OutputStream[] outputStreams) {
        return new OutputStream(){

            @Override
            public void close() throws IOException {
                for (OutputStream o : outputStreams) {
                    o.close();
                }
                super.close();
            }

            @Override
            public void flush() throws IOException {
                for (OutputStream o : outputStreams) {
                    o.flush();
                }
                super.flush();
            }

            @Override
            public void write(int oneByte) throws IOException {
                for (OutputStream o : outputStreams) {
                    o.write(oneByte);
                }
            }

            @Override
            public void write(byte[] buffer) throws IOException {
                for (OutputStream o : outputStreams) {
                    o.write(buffer);
                }
            }

            @Override
            public void write(byte[] buffer, int offset, int count) throws IOException {
                for (OutputStream o : outputStreams) {
                    o.write(buffer, offset, count);
                }
            }
        };
    }

    public static boolean isEmptyString(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String sha1(InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        int byteCount;
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] bytes = new byte[8192];
        while ((byteCount = inputStream.read(bytes)) > 0) {
            md.update(bytes, 0, byteCount);
        }
        inputStream.close();
        return new String(SdkUtils.encodeHex(md.digest()));
    }

    private static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = HEX_CHARS[(0xF0 & data[i]) >>> 4];
            out[j++] = HEX_CHARS[0xF & data[i]];
        }
        return out;
    }

    public static long parseJsonValueToLong(JsonValue value) {
        try {
            return value.asLong();
        }
        catch (UnsupportedOperationException e) {
            String s = value.asString().replace("\"", "");
            return Long.parseLong(s);
        }
    }

    public static long parseJsonValueToInteger(JsonValue value) {
        try {
            return value.asInt();
        }
        catch (UnsupportedOperationException e) {
            String s = value.asString().replace("\"", "");
            return Integer.parseInt(s);
        }
    }

    public static String concatStringWithDelimiter(String[] strings, String delimiter) {
        StringBuilder sbr = new StringBuilder();
        int size = strings.length;
        for (int i = 0; i < size - 1; ++i) {
            sbr.append(strings[i]).append(delimiter);
        }
        sbr.append(strings[size - 1]);
        return sbr.toString();
    }

    public static ThreadPoolExecutor createDefaultThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static <T> T cloneSerializable(T source) {
        Object object;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(source);
            bais = new ByteArrayInputStream(baos.toByteArray());
            ois = new ObjectInputStream(bais);
            object = ois.readObject();
        }
        catch (IOException e) {
            T t = null;
            SdkUtils.closeQuietly(baos, oos, bais, ois);
            return t;
        }
        catch (ClassNotFoundException e2) {
            T t = null;
            {
                catch (Throwable throwable) {
                    SdkUtils.closeQuietly(baos, oos, bais, ois);
                    throw throwable;
                }
            }
            SdkUtils.closeQuietly(baos, oos, bais, ois);
            return t;
        }
        SdkUtils.closeQuietly(baos, oos, bais, ois);
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertSerializableToString(Serializable obj) {
        String string2;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            string2 = new String(baos.toByteArray());
        }
        catch (IOException e) {
            String string3;
            try {
                string3 = null;
            }
            catch (Throwable throwable) {
                SdkUtils.closeQuietly(baos, oos);
                SdkUtils.closeQuietly(oos);
                throw throwable;
            }
            SdkUtils.closeQuietly(baos, oos);
            SdkUtils.closeQuietly(oos);
            return string3;
        }
        SdkUtils.closeQuietly(baos, oos);
        SdkUtils.closeQuietly(oos);
        return string2;
    }

    public static void closeQuietly(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static boolean deleteFolderRecursive(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files == null) {
                return false;
            }
            for (File c : files) {
                SdkUtils.deleteFolderRecursive(c);
            }
        }
        return f.delete();
    }
}

