/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.cas.config;

import com.centit.framework.cas.actions.AuthenticationFailureAction;
import com.centit.framework.cas.actions.ChangeAuthenticationAction;
import com.centit.framework.cas.actions.FingerMarkAuthenticationAction;
import com.centit.framework.cas.actions.LdapAuthenticationAction;
import com.centit.framework.cas.actions.Md5PasswordAuthenticationAction;
import com.centit.framework.cas.actions.UsbKeyAuthenticationAction;
import com.centit.framework.cas.audit.AuditPolicy;
import com.centit.framework.cas.audit.IpMacAuditPolicy;
import com.centit.framework.cas.audit.JdbcLoginLogger;
import com.centit.framework.cas.audit.LoginLogger;
import com.centit.framework.cas.config.ComplexConfigurationProperties;
import com.centit.framework.cas.controller.CaptchaController;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.pm.config.PasswordManagementConfiguration;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.webflow.execution.Action;

@Configuration(value="complexAuthWebflowConfiguation")
@EnableConfigurationProperties(value={ComplexConfigurationProperties.class})
@AutoConfigureAfter(value={PasswordManagementConfiguration.class})
public class ComplexAuthWebflowConfiguation {
    @Autowired
    private ComplexConfigurationProperties complexProperties;
    @Autowired
    @Qualifier(value="serviceTicketRequestWebflowEventResolver")
    private CasWebflowEventResolver serviceTicketRequestWebflowEventResolver;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver;
    @Autowired
    @Qualifier(value="adaptiveAuthenticationPolicy")
    private AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy;

    @Bean
    @ConditionalOnMissingBean(name={"captchaController"})
    public CaptchaController captchaController() {
        return new CaptchaController();
    }

    @Bean
    public AuditPolicy auditPolicy() {
        return new IpMacAuditPolicy();
    }

    @Bean
    public LoginLogger loginLogger() {
        JdbcLoginLogger logger = new JdbcLoginLogger();
        logger.setJdbcLoggerConfig(this.complexProperties.getJdbcLogger());
        return logger;
    }

    @ConditionalOnMissingBean(name={"md5PasswordAuthenticationAction"})
    @Bean
    public Action md5PasswordAuthenticationAction(@Autowired AuditPolicy auditPolicy, @Autowired LoginLogger loginLogger) {
        Md5PasswordAuthenticationAction action = new Md5PasswordAuthenticationAction(this.initialAuthenticationAttemptWebflowEventResolver, this.serviceTicketRequestWebflowEventResolver, this.adaptiveAuthenticationPolicy);
        action.setAuditPolicy(auditPolicy);
        action.setLoginLogger(loginLogger);
        action.setStrategyConfig(this.complexProperties.getStrategy());
        return action;
    }

    @ConditionalOnMissingBean(name={"ldapAuthenticationAction"})
    @Bean
    public Action ldapAuthenticationAction(@Autowired AuditPolicy auditPolicy, @Autowired LoginLogger loginLogger) {
        LdapAuthenticationAction action = new LdapAuthenticationAction(this.initialAuthenticationAttemptWebflowEventResolver, this.serviceTicketRequestWebflowEventResolver, this.adaptiveAuthenticationPolicy);
        action.setAuditPolicy(auditPolicy);
        action.setLoginLogger(loginLogger);
        action.setStrategyConfig(this.complexProperties.getStrategy());
        return action;
    }

    @ConditionalOnMissingBean(name={"fingerMarkAuthenticationAction"})
    @Bean
    public Action fingerMarkAuthenticationAction(@Autowired AuditPolicy auditPolicy, @Autowired LoginLogger loginLogger) {
        FingerMarkAuthenticationAction action = new FingerMarkAuthenticationAction(this.initialAuthenticationAttemptWebflowEventResolver, this.serviceTicketRequestWebflowEventResolver, this.adaptiveAuthenticationPolicy);
        action.setAuditPolicy(auditPolicy);
        action.setLoginLogger(loginLogger);
        action.setStrategyConfig(this.complexProperties.getStrategy());
        return action;
    }

    @ConditionalOnMissingBean(name={"usbKeyAuthenticationAction"})
    @Bean
    public Action usbKeyAuthenticationAction(@Autowired AuditPolicy auditPolicy, @Autowired LoginLogger loginLogger) {
        UsbKeyAuthenticationAction action = new UsbKeyAuthenticationAction(this.initialAuthenticationAttemptWebflowEventResolver, this.serviceTicketRequestWebflowEventResolver, this.adaptiveAuthenticationPolicy);
        action.setAuditPolicy(auditPolicy);
        action.setLoginLogger(loginLogger);
        action.setStrategyConfig(this.complexProperties.getStrategy());
        return action;
    }

    @Bean
    public Action changeAuthenticationAction() {
        ChangeAuthenticationAction changeAuthenticationAction = new ChangeAuthenticationAction();
        changeAuthenticationAction.setStrategyConfig(this.complexProperties.getStrategy());
        return changeAuthenticationAction;
    }

    @Bean
    public Action authenticationFailureAction() {
        AuthenticationFailureAction authenticationAction = new AuthenticationFailureAction();
        authenticationAction.setStrategyConfig(this.complexProperties.getStrategy());
        return authenticationAction;
    }
}

