/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.cas.model;

import com.centit.framework.cas.model.ComplexAuthCredential;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apereo.cas.authentication.RememberMeCredential;

public abstract class AbstractPasswordCredential
extends ComplexAuthCredential
implements RememberMeCredential {
    private static final long serialVersionUID = 1L;
    private String username;
    private String password;
    private String validateCode;
    private boolean rememberMe = false;
    private String topUnit;

    public AbstractPasswordCredential(String authType) {
        super(authType);
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.username).append((Object)this.password).append(this.rememberMe).append((Object)this.topUnit).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPasswordCredential other = (AbstractPasswordCredential)obj;
        if (this.password != null ? !this.password.equals(other.password) : other.password != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(other.username) : other.username != null) {
            return false;
        }
        if (this.topUnit != null ? !this.topUnit.equals(other.topUnit) : other.topUnit != null) {
            return false;
        }
        return this.rememberMe == other.rememberMe;
    }

    @Override
    public String checkInput() {
        if (StringUtils.isBlank((CharSequence)this.username) || StringUtils.isBlank((CharSequence)this.password)) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7528\u6237\u540d\u3001\u5bc6\u7801\u548c\u516c\u53f8\u4ee3\u7801\u3002";
        }
        return null;
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }

    public String getId() {
        return this.username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getValidateCode() {
        return this.validateCode;
    }

    public void setValidateCode(String validateCode) {
        this.validateCode = validateCode;
    }

    public String toString() {
        return this.username;
    }

    public String getTopUnit() {
        return this.topUnit;
    }

    public void setTopUnit(String topUnit) {
        this.topUnit = topUnit;
    }
}

