/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.cas.handler;

import com.alibaba.fastjson.JSONObject;
import com.centit.framework.cas.config.QueryUserProperties;
import com.centit.framework.cas.model.Md5PasswordCredential;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.DbcpConnectPools;
import com.centit.support.database.utils.TransactionHandler;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.exceptions.AccountDisabledException;
import org.apereo.cas.authentication.exceptions.AccountPasswordMustChangeException;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.CollectionUtils;

public class Md5PasswordAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    public QueryUserProperties queryUserProperties;
    private PasswordEncoder passwordEncoder;

    public Md5PasswordAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order) {
        super(name, servicesManager, principalFactory, order);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential) throws GeneralSecurityException, PreventedException {
        String userName = null;
        String userPwd = null;
        String topUnit = null;
        if (credential instanceof Md5PasswordCredential) {
            Md5PasswordCredential pc = (Md5PasswordCredential)credential;
            userName = pc.getUsername();
            userPwd = pc.getPassword();
            topUnit = pc.getTopUnit();
        }
        if (credential instanceof UsernamePasswordCredential) {
            UsernamePasswordCredential nc = (UsernamePasswordCredential)credential;
            String[] params = nc.getUsername().split("@");
            if (params.length > 1) {
                userName = params[0];
                topUnit = params[1];
            } else {
                userName = nc.getUsername();
            }
            userPwd = nc.getPassword();
        }
        if (StringUtils.isBlank(userName)) {
            throw new AccountNotFoundException("\u8f93\u5165\u7684\u7528\u6237\u540d\u4e3a\u7a7a\uff01");
        }
        try (Connection conn = DbcpConnectPools.getDbcpConnect((DataSourceDescription)this.queryUserProperties.getDatasource());){
            String tempPrincipal;
            Object dbDisabled;
            Integer intParamsTimes = this.queryUserProperties.getParamRepeatTimes();
            if (intParamsTimes == null || intParamsTimes < 1) {
                intParamsTimes = 1;
            }
            Object[] param = new Object[intParamsTimes.intValue()];
            for (int i = 0; i < intParamsTimes; ++i) {
                param[i] = userName;
            }
            JSONObject user = DatabaseAccess.getObjectAsJSON((Connection)conn, (String)this.queryUserProperties.getSql(), (Object[])param);
            if (user == null) {
                throw new AccountNotFoundException("\u7528\u6237\u627e\u4e0d\u5230\uff01");
            }
            String password = user.getString(DatabaseAccess.mapColumnNameToField((String)this.queryUserProperties.getPinField()));
            if (!this.passwordEncoder.matches((CharSequence)userPwd, password)) {
                throw new FailedLoginException("\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5339\u914d\u3002");
            }
            if (StringUtils.isNotBlank((CharSequence)this.queryUserProperties.getDisabledField()) && BooleanBaseOpt.castObjectToBoolean((Object)(dbDisabled = user.get((Object)DatabaseAccess.mapColumnNameToField((String)this.queryUserProperties.getDisabledField()))), (Boolean)false).booleanValue()) {
                throw new AccountDisabledException("\u7528\u6237\u5df2\u7ecf\u5931\u6548");
            }
            if (StringUtils.isNotBlank((CharSequence)this.queryUserProperties.getExpiredField()) && BooleanBaseOpt.castObjectToBoolean((Object)(dbDisabled = user.get((Object)DatabaseAccess.mapColumnNameToField((String)this.queryUserProperties.getExpiredField()))), (Boolean)false).booleanValue()) {
                throw new AccountPasswordMustChangeException("\u5bc6\u7801\u5df2\u8fc7\u671f");
            }
            Object[] unitParam = new Object[2];
            String userCode = user.getString("userCode");
            String topUnitCode = user.getString("topUnit");
            unitParam[0] = userCode;
            unitParam[1] = userCode;
            String sql = "SELECT UNIT_WORD,TOP_UNIT FROM F_UNITINFO WHERE UNIT_CODE IN ( SELECT DISTINCT TOP_UNIT FROM F_USERUNIT WHERE USER_CODE = ? )UNION SELECT UNIT_WORD,TOP_UNIT FROM F_UNITINFO WHERE UNIT_CODE IN (SELECT DISTINCT UNIT_CODE FROM F_USERUNIT WHERE USER_CODE = ? )";
            List units = DatabaseAccess.findObjectsBySql((Connection)conn, (String)sql, (Object[])unitParam);
            ArrayList unitList = new ArrayList();
            HashMap topUnitMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)units)) {
                units.forEach(unit -> {
                    if (null != unit && ((Object[])unit).length > 0 && null != unit[0]) {
                        unitList.add(unit[0].toString());
                    }
                    if (((Object[])unit).length > 1 && null != unit[1]) {
                        topUnitMap.put(unit[0].toString(), unit[1].toString());
                    }
                });
                if (CollectionUtils.isEmpty(unitList)) {
                    throw new FailedLoginException(userName + "\u8be5\u7528\u6237\u672a\u5206\u914d\u516c\u53f8\u4ee3\u7801");
                }
                if (!unitList.contains(topUnit)) {
                    throw new FailedLoginException(userName + "\u7528\u6237\u516c\u53f8\u4ee3\u7801\u4e0d\u5339\u914d\uff01");
                }
            } else {
                sql = "SELECT DISTINCT TOP_UNIT FROM F_USERUNIT WHERE USER_CODE = ? ";
                List topUnits = DatabaseAccess.findObjectsBySql((Connection)conn, (String)sql, (Object[])unitParam);
                if (CollectionUtils.isEmpty((Collection)topUnits)) throw new FailedLoginException(userName + "\u8be5\u7528\u6237\u672a\u5206\u914d\u516c\u53f8\u4ee3\u7801");
                topUnits.forEach(unit -> {
                    if (null != unit && ((Object[])unit).length > 0 && null != unit[0]) {
                        unitList.add(unit[0].toString());
                    }
                });
                if (CollectionUtils.isEmpty(unitList)) {
                    throw new FailedLoginException(userName + "\u8be5\u7528\u6237\u672a\u5206\u914d\u516c\u53f8\u4ee3\u7801");
                }
                if (!unitList.contains(topUnit)) {
                    throw new FailedLoginException(userName + "\u7528\u6237\u516c\u53f8\u4ee3\u7801\u4e0d\u5339\u914d\uff01");
                }
            }
            if (null != topUnitMap.get(topUnit) && !((String)topUnitMap.get(topUnit)).equals(topUnitCode)) {
                sql = "SELECT UNIT_CODE FROM F_USERUNIT WHERE REL_TYPE ='T' AND USER_CODE = ? AND TOP_UNIT= ? ";
                Object[] userParam = new Object[]{userCode, topUnitMap.get(topUnit)};
                String userUnitCode = "";
                List userUnits = DatabaseAccess.findObjectsBySql((Connection)conn, (String)sql, (Object[])userParam);
                if (CollectionUtils.isEmpty((Collection)userUnits)) {
                    throw new FailedLoginException(userName + "\u8be5\u516c\u53f8\u4e0b\u672a\u5206\u914d\u9ed8\u8ba4\u673a\u6784");
                }
                if (userUnits.size() > 1) {
                    throw new FailedLoginException(userName + "\u8be5\u516c\u53f8\u4e0b\u9ed8\u8ba4\u673a\u6784\u53ea\u80fd\u5206\u914d\u4e00\u4e2a");
                }
                userUnitCode = ((Object[])userUnits.get(0))[0].toString();
                Object[] updateParam = new Object[]{topUnitMap.get(topUnit), userUnitCode, userCode};
                String updateSql = "UPDATE F_USERINFO SET TOP_UNIT = ?,PRIMARY_UNIT = ? WHERE USER_CODE = ? ";
                try {
                    TransactionHandler.executeInTransaction((DataSourceDescription)this.queryUserProperties.getDatasource(), connection -> DatabaseAccess.doExecuteSql((Connection)connection, (String)updateSql, (Object[])updateParam));
                }
                catch (SQLException e) {
                    throw new FailedLoginException("\u66f4\u6539\u7528\u6237\u9ed8\u8ba4\u516c\u53f8\u4ee3\u7801\u5f02\u5e38\uff01");
                }
                user.put("primaryUnit", (Object)userUnitCode);
                user.put("topUnit", topUnitMap.get(topUnit));
            }
            String principal = userName;
            String principalKey = this.queryUserProperties.getPrincipalField();
            if (StringUtils.isNotBlank((CharSequence)principalKey) && !"none".equalsIgnoreCase(principalKey) && StringUtils.isNotBlank((CharSequence)(tempPrincipal = user.getString(DatabaseAccess.mapColumnNameToField((String)principalKey))))) {
                principal = tempPrincipal;
            }
            user.remove((Object)DatabaseAccess.mapColumnNameToField((String)this.queryUserProperties.getPinField()));
            AuthenticationHandlerExecutionResult authenticationHandlerExecutionResult = this.createHandlerResult(credential, this.principalFactory.createPrincipal(principal, (Map)user));
            return authenticationHandlerExecutionResult;
        }
        catch (IOException | SQLException e) {
            throw new AccountNotFoundException("\u67e5\u627e\u7528\u6237 " + userName + " \u62a5\u9519 " + e.getLocalizedMessage());
        }
    }

    public boolean supports(Credential credential) {
        return credential instanceof Md5PasswordCredential || credential instanceof UsernamePasswordCredential;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void setQueryUserProperties(QueryUserProperties queryUserProperties) {
        this.queryUserProperties = queryUserProperties;
    }
}

