/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.cas.actions;

import com.centit.framework.cas.actions.ActionUtils;
import com.centit.framework.cas.audit.AuditPolicy;
import com.centit.framework.cas.audit.LoginLogger;
import com.centit.framework.cas.config.StrategyProperties;
import com.centit.framework.cas.model.AbstractPasswordCredential;
import com.centit.framework.cas.model.ComplexAuthCredential;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.image.CaptchaImageUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.adaptive.UnauthorizedAuthenticationException;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractComplexAuthenticationAction
extends AbstractAction {
    private String supportAuthType;
    private AuditPolicy auditPolicy;
    private LoginLogger loginLogger;
    private StrategyProperties strategyConfig;
    private final CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver;
    private final AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy;
    private final CasWebflowEventResolver serviceTicketRequestWebflowEventResolver;

    public AbstractComplexAuthenticationAction(CasDelegatingWebflowEventResolver delegatingWebflowEventResolver, CasWebflowEventResolver webflowEventResolver, AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy) {
        this.initialAuthenticationAttemptWebflowEventResolver = delegatingWebflowEventResolver;
        this.serviceTicketRequestWebflowEventResolver = webflowEventResolver;
        this.adaptiveAuthenticationPolicy = adaptiveAuthenticationPolicy;
    }

    public void setSupportAuthType(String supportAuthType) {
        this.supportAuthType = supportAuthType;
    }

    public abstract ComplexAuthCredential doPrepareExecute(RequestContext var1);

    protected Event makeError(RequestContext requestContext, String sourceCode, String msg) {
        MessageContext messageContext = requestContext.getMessageContext();
        messageContext.addMessage(new MessageBuilder().error().code("error").source((Object)sourceCode).defaultText(msg).build());
        Map map = CollectionUtils.wrap((String)AuthenticationException.class.getSimpleName(), AuthenticationException.class);
        AuthenticationException error = new AuthenticationException(msg, map, new HashMap(0));
        this.onFailedLogin(requestContext);
        return new Event((Object)this, "error", (AttributeMap)new LocalAttributeMap("error", (Object)error));
    }

    protected Event doExecute(RequestContext requestContext) {
        GeoLocationRequest geoLocation;
        String captchaCode;
        ComplexAuthCredential credential = this.doPrepareExecute(requestContext);
        if (credential == null) {
            return this.makeError(requestContext, "credentialError", "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9a8c\u8bc1\u4fe1\u606f\uff01");
        }
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute("_currentAuthType", (Object)credential.getAuthType());
        if (StringUtils.isNotBlank((CharSequence)credential.getAuthType()) && !StringUtils.equals((CharSequence)this.supportAuthType, (CharSequence)credential.getAuthType())) {
            return new Event((Object)this, "changeAuth");
        }
        String inputCheckRes = credential.checkInput();
        if (StringUtils.isNotBlank((CharSequence)inputCheckRes)) {
            return this.makeError(requestContext, "inputError", inputCheckRes);
        }
        requestContext.getFlowScope().put("credential", (Object)credential);
        if (credential instanceof AbstractPasswordCredential && StringUtils.isNotBlank((CharSequence)(captchaCode = StringBaseOpt.castObjectToString((Object)httpSession.getAttribute("session_checkcode")))) && !CaptchaImageUtil.checkcodeMatch((String)captchaCode, (String)((AbstractPasswordCredential)credential).getValidateCode())) {
            return this.makeError(requestContext, "captchaError", "\u9a8c\u8bc1\u7801\u8f93\u5165\u9519\u8bef\uff01");
        }
        String agent = WebUtils.getHttpServletRequestUserAgentFromRequestContext();
        if (!this.adaptiveAuthenticationPolicy.apply(agent, geoLocation = WebUtils.getHttpServletRequestGeoLocationFromRequestContext())) {
            String msg = "Adaptive authentication policy does not allow this request for " + agent + " and " + geoLocation;
            Map map = CollectionUtils.wrap((String)UnauthorizedAuthenticationException.class.getSimpleName(), UnauthorizedAuthenticationException.class);
            AuthenticationException error = new AuthenticationException(msg, map, new HashMap(0));
            return new Event((Object)this, "error", (AttributeMap)new LocalAttributeMap("error", (Object)error));
        }
        Event serviceTicketEvent = this.serviceTicketRequestWebflowEventResolver.resolveSingle(requestContext);
        if (serviceTicketEvent != null) {
            this.fireEventHooks(serviceTicketEvent, requestContext);
            return serviceTicketEvent;
        }
        Event finalEvent = this.initialAuthenticationAttemptWebflowEventResolver.resolveSingle(requestContext);
        if (finalEvent.getId().equals("success")) {
            Authentication auth = WebUtils.getAuthentication((RequestContext)requestContext);
            if (this.auditPolicy != null && !this.auditPolicy.apply(credential, auth, requestContext)) {
                finalEvent = this.makeError(requestContext, "autidNotPass", "IP\u5730\u5740\u548cMac\u5730\u5740\u5ba1\u6838\u4e0d\u901a\u8fc7!");
            }
        } else if (finalEvent.getId().equals("authenticationFailure")) {
            Throwable throwable;
            Map errorMap;
            AuthenticationException authenticationException = (AuthenticationException)finalEvent.getAttributes().get("error");
            String errorMessage = "\u9a8c\u8bc1\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u7528\u6237\u540d\u5bc6\u7801\u51fa\u9519\uff01";
            if (authenticationException != null && (errorMap = authenticationException.getHandlerErrors()) != null && errorMap.size() > 0 && (throwable = (Throwable)errorMap.values().iterator().next()) != null) {
                errorMessage = throwable.getMessage();
            }
            return this.makeError(requestContext, "inputError", errorMessage);
        }
        this.fireEventHooks(finalEvent, requestContext);
        return finalEvent;
    }

    private void fireEventHooks(Event e, RequestContext ctx) {
        switch (e.getId()) {
            case "error": {
                this.onError(ctx);
                break;
            }
            case "warn": {
                this.onWarn(ctx);
                break;
            }
            case "success": {
                this.onSuccess(ctx);
                break;
            }
        }
    }

    protected void onWarn(RequestContext context) {
        ComplexAuthCredential credential = (ComplexAuthCredential)WebUtils.getCredential((RequestContext)context);
        this.loginLogger.logWarn(credential, ClientInfoHolder.getClientInfo());
    }

    protected void onSuccess(RequestContext context) {
        ComplexAuthCredential credential = (ComplexAuthCredential)WebUtils.getCredential((RequestContext)context);
        Authentication auth = WebUtils.getAuthentication((RequestContext)context);
        this.loginLogger.logSuccess(credential, ClientInfoHolder.getClientInfo(), auth);
    }

    protected void onError(RequestContext context) {
        ComplexAuthCredential credential = (ComplexAuthCredential)WebUtils.getCredential((RequestContext)context);
        this.loginLogger.logError(credential, ClientInfoHolder.getClientInfo());
        ActionUtils.incLoginTimes(context, this.strategyConfig.getMaxFailTimesBeforeValidateCode());
    }

    protected void onFailedLogin(RequestContext context) {
        ComplexAuthCredential credential = (ComplexAuthCredential)WebUtils.getCredential((RequestContext)context);
        this.loginLogger.logFailedLogin(credential, ClientInfoHolder.getClientInfo());
        ActionUtils.incLoginTimes(context, this.strategyConfig.getMaxFailTimesBeforeValidateCode());
    }

    public void setAuditPolicy(AuditPolicy auditPolicy) {
        this.auditPolicy = auditPolicy;
    }

    public void setLoginLogger(LoginLogger loginLogger) {
        this.loginLogger = loginLogger;
    }

    public void setStrategyConfig(StrategyProperties strategyConfig) {
        this.strategyConfig = strategyConfig;
    }
}

