/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.service.impl;

import com.centit.framework.common.ResponseData;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.users.config.AppConfig;
import com.centit.framework.users.service.DingTalkLoginService;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiSnsGetuserinfoBycodeRequest;
import com.dingtalk.api.request.OapiUserGetbyunionidRequest;
import com.dingtalk.api.request.OapiV2DepartmentCreateRequest;
import com.dingtalk.api.request.OapiV2UserCreateRequest;
import com.dingtalk.api.request.OapiV2UserGetRequest;
import com.dingtalk.api.response.OapiSnsGetuserinfoBycodeResponse;
import com.dingtalk.api.response.OapiUserGetbyunionidResponse;
import com.dingtalk.api.response.OapiV2DepartmentCreateResponse;
import com.dingtalk.api.response.OapiV2UserCreateResponse;
import com.dingtalk.api.response.OapiV2UserGetResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dingTalkLoginService")
public class DingTalkLoginServiceImpl
implements DingTalkLoginService {
    private static final Logger logger = LoggerFactory.getLogger(DingTalkLoginServiceImpl.class);
    @Autowired
    private AppConfig appConfig;

    @Override
    public ResponseData getUserByCode(String authCode) {
        OapiSnsGetuserinfoBycodeResponse response;
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/sns/getuserinfo_bycode");
        OapiSnsGetuserinfoBycodeRequest request = new OapiSnsGetuserinfoBycodeRequest();
        request.setTmpAuthCode(authCode);
        try {
            response = (OapiSnsGetuserinfoBycodeResponse)client.execute((TaobaoRequest)request, this.appConfig.getAppKey(), this.appConfig.getAppSecret());
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/sns/getuserinfo_bycode", (Object)e);
            return ResponseData.makeErrorMessage((int)Integer.valueOf(e.getErrCode()), (String)("Failed to getuserinfo_bycode: " + e.getErrMsg()));
        }
        return ResponseData.makeResponseData((Object)response.getUserInfo().getUnionid());
    }

    @Override
    public ResponseData getUserByUnionId(String accessToken, String unionId) {
        OapiUserGetbyunionidResponse response;
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/user/getbyunionid");
        OapiUserGetbyunionidRequest request = new OapiUserGetbyunionidRequest();
        request.setUnionid(unionId);
        try {
            response = (OapiUserGetbyunionidResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/user/get", (Object)e);
            return ResponseData.makeErrorMessage((int)Integer.valueOf(e.getErrCode()), (String)("Failed to getByUnionid: " + e.getErrMsg()));
        }
        return ResponseData.makeResponseData((Object)response.getResult().getUserid());
    }

    @Override
    public ResponseData getUserInfo(String accessToken, String userId) {
        OapiV2UserGetResponse response;
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/get");
        OapiV2UserGetRequest request = new OapiV2UserGetRequest();
        request.setUserid(userId);
        request.setLanguage("zh_CN");
        try {
            response = (OapiV2UserGetResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/topapi/v2/user/get", (Object)e);
            return ResponseData.makeErrorMessage((int)Integer.valueOf(e.getErrCode()), (String)("Failed to getUser: " + e.getErrMsg()));
        }
        return ResponseData.makeResponseData((Object)response.getBody());
    }

    @Override
    public ResponseData userCreate(String accessToken, UserInfo userInfo) {
        OapiV2UserCreateResponse response;
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/create?access_token=ACCESS_TOKEN");
        OapiV2UserCreateRequest request = new OapiV2UserCreateRequest();
        request.setUserid(userInfo.getUserCode());
        request.setName(userInfo.getUserName());
        request.setMobile(userInfo.getRegCellPhone());
        request.setDeptIdList(userInfo.getPrimaryUnit());
        try {
            response = (OapiV2UserCreateResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/topapi/v2/user/create?access_token=ACCESS_TOKEN", (Object)e);
            return ResponseData.makeErrorMessage((int)Integer.valueOf(e.getErrCode()), (String)("Failed to getUser: " + e.getErrMsg()));
        }
        return ResponseData.makeResponseData((Object)response.getBody());
    }

    @Override
    public ResponseData unitCreate(String accessToken, UnitInfo unitInfo) {
        OapiV2DepartmentCreateResponse response;
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/create?access_token=ACCESS_TOKEN");
        OapiV2DepartmentCreateRequest request = new OapiV2DepartmentCreateRequest();
        request.setName(unitInfo.getUnitName());
        request.setParentId(Long.valueOf(1L));
        try {
            response = (OapiV2DepartmentCreateResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/topapi/v2/department/create?access_token=ACCESS_TOKEN", (Object)e);
            return ResponseData.makeErrorMessage((int)Integer.valueOf(e.getErrCode()), (String)("Failed to getUser: " + e.getErrMsg()));
        }
        return ResponseData.makeResponseData((Object)response.getBody());
    }
}

