/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.controller;

import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.users.config.AppConfig;
import com.centit.framework.users.po.Platform;
import com.centit.framework.users.po.UserPlat;
import com.centit.framework.users.service.PlatformService;
import com.centit.framework.users.service.TokenService;
import com.centit.framework.users.service.UserPlatService;
import com.centit.support.common.ParamName;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/plat"})
@Api(value="\u767b\u5f55\u5e73\u53f0\u7ba1\u7406\u64cd\u4f5c\u63a5\u53e3", tags={"\u767b\u5f55\u5e73\u53f0\u7ba1\u7406\u64cd\u4f5c\u63a5\u53e3"})
public class PlaformController
extends BaseController {
    @Autowired
    private PlatformService platformService;
    @Autowired
    private UserPlatService userPlatService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private AppConfig appConfig;
    @Autowired
    protected PlatformEnvironment platformEnvironment;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5e73\u53f0\u4fe1\u606f", notes="\u5206\u9875\u67e5\u8be2\u5e73\u53f0\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)
    @GetMapping(value={"/list"})
    @WrapUpResponseBody
    public PageQueryResult<Platform> list(PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        List<Platform> listObjects = this.platformService.listObjects(searchColumn, pageDesc);
        return PageQueryResult.createResultMapDict(listObjects, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u5e73\u53f0\u4fe1\u606f", notes="\u6839\u636e\u5e73\u53f0D\u67e5\u8be2\u5355\u4e2a\u5e73\u53f0\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="platId", value="\u5e73\u53f0ID", paramType="query", dataType="String")
    @GetMapping(value={"/{platId}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public Platform getPlatform(@PathVariable String platId) {
        return this.platformService.getObjectById(platId);
    }

    @ApiOperation(value="\u5220\u9664\u5e73\u53f0\u4fe1\u606f", notes="\u6839\u636e\u5e73\u53f0ID\u5220\u9664\u5e73\u53f0\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="platId", value="\u5e73\u53f0ID", paramType="query", dataType="String")
    @DeleteMapping(value={"/{platId}"})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u5e73\u53f0", tag="{platId}")
    @WrapUpResponseBody
    public ResponseData delete(@ParamName(value="platId") @PathVariable String platId) {
        Platform platform = this.platformService.getObjectById(platId);
        if (platform == null) {
            return ResponseData.makeErrorMessage((String)"The object not found!");
        }
        List<UserPlat> userPlats = this.userPlatService.listPlatUsersByPlatId(platId);
        if (!CollectionUtils.isEmpty(userPlats)) {
            return ResponseData.makeErrorMessage((String)"\u8be5\u5e73\u53f0\u5b58\u5728\u5173\u8054\u7528\u6237\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        this.platformService.deletePlatform(platform);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u65b0\u5efa\u5e73\u53f0", notes="\u65b0\u5efa\u4e00\u4e2a\u5e73\u53f0\u3002")
    @ApiImplicitParam(name="platform", value="json\u683c\u5f0f\uff0c\u5e73\u53f0\u4fe1\u606f\u5bf9\u8c61", paramType="body", dataTypeClass=Platform.class)
    @PostMapping
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u5e73\u53f0", tag="{pf.platId}:{pf.platSourceCode}")
    @WrapUpResponseBody
    public ResponseData create(@ParamName(value="pf") @Valid Platform platform) {
        if (this.platformService.hasSamePlat(platform)) {
            return ResponseData.makeErrorMessage((int)702, (String)("\u5e73\u53f0\u4ee3\u7801" + platform.getPlatSourceCode() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01"));
        }
        this.platformService.savePlatform(platform);
        return ResponseData.makeResponseData((Object)platform);
    }

    @ApiOperation(value="\u66f4\u65b0\u5e73\u53f0\u4fe1\u606f", notes="\u66f4\u65b0\u5e73\u53f0\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="platId", value="\u5e73\u53f0id", paramType="path", dataType="String"), @ApiImplicitParam(name="platform", value="json\u683c\u5f0f\uff0c\u5e73\u53f0\u4fe1\u606f\u5bf9\u8c61", paramType="body", dataTypeClass=Platform.class)})
    @PutMapping(value={"/{platId}"})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u5e73\u53f0", tag="{platId}")
    @WrapUpResponseBody
    public ResponseData edit(@ParamName(value="platId") @PathVariable String platId, @Valid Platform platform) {
        Platform dbPlatform = this.platformService.getObjectById(platId);
        if (null == dbPlatform) {
            return ResponseData.makeErrorMessage((String)"\u5e73\u53f0\u4e0d\u5b58\u5728");
        }
        if (!dbPlatform.getPlatSourceCode().equals(platform.getPlatSourceCode()) && this.platformService.hasSamePlat(platform)) {
            return ResponseData.makeErrorMessage((int)702, (String)("\u5e73\u53f0\u4ee3\u7801" + platform.getPlatSourceCode() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01"));
        }
        this.platformService.updatePlatform(platform);
        return ResponseData.makeResponseData((Object)platform);
    }

    @ApiOperation(value="\u83b7\u53d6AccessToken", notes="\u83b7\u53d6AccessToken\u3002")
    @GetMapping(value={"/getCacheToken"})
    @WrapUpResponseBody
    public ResponseData test(HttpServletRequest request, HttpServletResponse response) {
        String accessToken = this.tokenService.getFromDb(this.appConfig.getAppKey());
        return ResponseData.makeResponseData((Object)accessToken);
    }
}

