/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.service.impl;

import com.centit.framework.common.ResponseData;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.users.config.AppConfig;
import com.centit.framework.users.dao.SocialDeptAuthDao;
import com.centit.framework.users.po.SocialDeptAuth;
import com.centit.framework.users.service.DingTalkLoginService;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiSnsGetuserinfoBycodeRequest;
import com.dingtalk.api.request.OapiUserGetbyunionidRequest;
import com.dingtalk.api.request.OapiV2DepartmentCreateRequest;
import com.dingtalk.api.request.OapiV2DepartmentGetRequest;
import com.dingtalk.api.request.OapiV2UserCreateRequest;
import com.dingtalk.api.request.OapiV2UserGetRequest;
import com.dingtalk.api.response.OapiSnsGetuserinfoBycodeResponse;
import com.dingtalk.api.response.OapiUserGetbyunionidResponse;
import com.dingtalk.api.response.OapiV2DepartmentCreateResponse;
import com.dingtalk.api.response.OapiV2DepartmentGetResponse;
import com.dingtalk.api.response.OapiV2UserCreateResponse;
import com.dingtalk.api.response.OapiV2UserGetResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dingTalkLoginService")
public class DingTalkLoginServiceImpl
implements DingTalkLoginService {
    private static final Logger logger = LoggerFactory.getLogger(DingTalkLoginServiceImpl.class);
    @Autowired
    private AppConfig appConfig;
    @Autowired
    private SocialDeptAuthDao socialDeptAuthDao;

    @Override
    public ResponseData getUserByCode(String authCode) {
        OapiSnsGetuserinfoBycodeResponse response;
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/sns/getuserinfo_bycode");
        OapiSnsGetuserinfoBycodeRequest request = new OapiSnsGetuserinfoBycodeRequest();
        request.setTmpAuthCode(authCode);
        try {
            response = (OapiSnsGetuserinfoBycodeResponse)client.execute((TaobaoRequest)request, this.appConfig.getAppKey(), this.appConfig.getAppSecret());
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/sns/getuserinfo_bycode", (Object)e);
            return ResponseData.makeErrorMessage((int)Integer.valueOf(e.getErrCode()), (String)("Failed to getUserByCode: " + e.getErrMsg()));
        }
        return ResponseData.makeResponseData((Object)response.getUserInfo().getUnionid());
    }

    @Override
    public ResponseData getUserByUnionId(String accessToken, String unionId) {
        OapiUserGetbyunionidResponse response;
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/user/getbyunionid");
        OapiUserGetbyunionidRequest request = new OapiUserGetbyunionidRequest();
        request.setUnionid(unionId);
        try {
            response = (OapiUserGetbyunionidResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/user/get", (Object)e);
            return ResponseData.makeErrorMessage((int)Integer.valueOf(e.getErrCode()), (String)("Failed to getUserByUnionId: " + e.getErrMsg()));
        }
        return ResponseData.makeResponseData((Object)response.getResult().getUserid());
    }

    @Override
    public ResponseData getUserInfo(String accessToken, String userId) {
        OapiV2UserGetResponse response;
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/get");
        OapiV2UserGetRequest request = new OapiV2UserGetRequest();
        request.setUserid(userId);
        request.setLanguage("zh_CN");
        try {
            response = (OapiV2UserGetResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/topapi/v2/user/get", (Object)e);
            return ResponseData.makeErrorMessage((int)Integer.valueOf(e.getErrCode()), (String)("Failed to getUserInfo: " + e.getErrMsg()));
        }
        return ResponseData.makeResponseData((Object)response.getBody());
    }

    @Override
    public ResponseData userCreate(String accessToken, UserInfo userInfo) {
        OapiV2UserCreateResponse response;
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/create");
        OapiV2UserCreateRequest request = new OapiV2UserCreateRequest();
        request.setUserid(userInfo.getUserCode());
        request.setName(userInfo.getUserName());
        request.setMobile(userInfo.getRegCellPhone());
        SocialDeptAuth socialDeptAuth = (SocialDeptAuth)this.socialDeptAuthDao.getObjectById(userInfo.getPrimaryUnit());
        if (null == socialDeptAuth) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/topapi/v2/user/create", (Object)"\u90e8\u95e8\u672a\u540c\u6b65\u5230\u5e73\u53f0\u5e94\u7528");
            return ResponseData.makeErrorMessage((int)500, (String)"Failed to userCreate: \u90e8\u95e8\u672a\u540c\u6b65\u5230\u5e73\u53f0\u5e94\u7528");
        }
        request.setDeptIdList(socialDeptAuth.getDeptId());
        try {
            response = (OapiV2UserCreateResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/topapi/v2/user/create", (Object)e);
            return ResponseData.makeErrorMessage((int)Integer.valueOf(e.getErrCode()), (String)("Failed to userCreate: " + e.getErrMsg()));
        }
        return ResponseData.makeResponseData((Object)response.getBody());
    }

    @Override
    public ResponseData unitCreate(String accessToken, UnitInfo unitInfo) {
        OapiV2DepartmentCreateResponse response;
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/create");
        OapiV2DepartmentCreateRequest request = new OapiV2DepartmentCreateRequest();
        request.setName(unitInfo.getUnitName());
        if ("".equals(unitInfo.getParentUnit())) {
            request.setParentId(Long.valueOf(1L));
        } else {
            SocialDeptAuth socialDeptAuth = (SocialDeptAuth)this.socialDeptAuthDao.getObjectById(unitInfo.getParentUnit());
            if (null != socialDeptAuth) {
                request.setParentId(Long.valueOf(socialDeptAuth.getDeptId()));
            } else {
                logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/topapi/v2/department/create", (Object)"\u672a\u67e5\u8be2\u5230\u7236\u8282\u70b9\u673a\u6784");
                return ResponseData.makeErrorMessage((int)500, (String)"Failed to unitCreate: \u672a\u67e5\u8be2\u5230\u7236\u8282\u70b9\u673a\u6784");
            }
        }
        try {
            response = (OapiV2DepartmentCreateResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/topapi/v2/department/create", (Object)e);
            return ResponseData.makeErrorMessage((int)Integer.valueOf(e.getErrCode()), (String)("Failed to unitCreate: " + e.getErrMsg()));
        }
        SocialDeptAuth socialDeptAuth = new SocialDeptAuth();
        socialDeptAuth.setUnitCode(unitInfo.getUnitCode());
        socialDeptAuth.setDeptId(response.getResult().getDeptId().toString());
        this.socialDeptAuthDao.saveNewObject(socialDeptAuth);
        return ResponseData.makeResponseData((Object)response.getBody());
    }

    @Override
    public ResponseData getUnitInfo(String accessToken, String deptId) {
        OapiV2DepartmentGetResponse response = this.getDingUnitinfo(accessToken, deptId);
        if (response == null) {
            ResponseData.makeErrorMessage((String)"Failed to getDingUnitinfo");
        }
        return ResponseData.makeResponseData((Object)response.getBody());
    }

    private OapiV2DepartmentGetResponse getDingUnitinfo(String accessToken, String deptId) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/get");
        OapiV2DepartmentGetRequest request = new OapiV2DepartmentGetRequest();
        request.setDeptId(Long.valueOf(deptId));
        request.setLanguage("zh_CN");
        OapiV2DepartmentGetResponse response = null;
        try {
            response = (OapiV2DepartmentGetResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/topapi/v2/department/get", (Object)e);
        }
        return response;
    }
}

