/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.service.impl;

import com.centit.framework.users.dao.PlatformDao;
import com.centit.framework.users.po.Platform;
import com.centit.framework.users.service.PlatformService;
import com.centit.support.database.utils.PageDesc;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="platformService")
@Transactional
public class PlatformServiceImpl
implements PlatformService {
    @Autowired
    private PlatformDao platformDao;

    @Override
    public List<Platform> listObjects(Map<String, Object> filterMap) {
        return this.platformDao.listObjects(filterMap);
    }

    @Override
    public List<Platform> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.platformDao.listObjects(filterMap, pageDesc);
    }

    @Override
    public Platform getObjectById(String platId) {
        return (Platform)this.platformDao.getObjectById(platId);
    }

    @Override
    public Platform getPlatformByProperties(Map<String, Object> paramsMap) {
        return (Platform)this.platformDao.getObjectByProperties(paramsMap);
    }

    @Override
    public boolean hasSamePlat(Platform platform) {
        return this.platformDao.isUniquePlat(platform.getPlatSourceCode(), platform.getPlatId());
    }

    @Override
    public void savePlatform(Platform platform) {
        this.platformDao.saveNewObject(platform);
    }

    @Override
    public void updatePlatform(Platform platform) {
        this.platformDao.updateObject(platform);
    }

    @Override
    public void deletePlatform(Platform platform) {
        this.platformDao.deleteObjectById(platform.getPlatId());
    }
}

